/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncPacket {
    private final boolean canTeleport;
    private final List<ResourceLocation> allowedStructureKeys;
    private final ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedStructureKeys;
    private final Map<ResourceLocation, ResourceLocation> structureKeysToTypeKeys;
    private final ListMultimap<ResourceLocation, ResourceLocation> typeKeysToStructureKeys;

    public SyncPacket(boolean canTeleport, List<ResourceLocation> allowedStructures, ListMultimap<ResourceLocation, ResourceLocation> dimensionsForAllowedStructures, Map<ResourceLocation, ResourceLocation> structureKeysToTypeKeys, ListMultimap<ResourceLocation, ResourceLocation> typeKeysToStructureKeys) {
        this.canTeleport = canTeleport;
        this.allowedStructureKeys = allowedStructures;
        this.dimensionKeysForAllowedStructureKeys = dimensionsForAllowedStructures;
        this.structureKeysToTypeKeys = structureKeysToTypeKeys;
        this.typeKeysToStructureKeys = typeKeysToStructureKeys;
    }

    public SyncPacket(FriendlyByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedStructureKeys = new ArrayList<ResourceLocation>();
        this.dimensionKeysForAllowedStructureKeys = ArrayListMultimap.create();
        this.structureKeysToTypeKeys = new HashMap<ResourceLocation, ResourceLocation>();
        this.typeKeysToStructureKeys = ArrayListMultimap.create();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            ResourceLocation structureKey = buf.m_130281_();
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensions.add(buf.m_130281_());
            }
            ResourceLocation typeKey = buf.m_130281_();
            this.allowedStructureKeys.add(structureKey);
            this.dimensionKeysForAllowedStructureKeys.putAll((Object)structureKey, dimensions);
            this.structureKeysToTypeKeys.put(structureKey, typeKey);
        }
        int numTypes = buf.readInt();
        for (int i = 0; i < numTypes; ++i) {
            ResourceLocation typeKey = buf.m_130281_();
            int numStructuresToAdd = buf.readInt();
            for (int j = 0; j < numStructuresToAdd; ++j) {
                ResourceLocation structureKey = buf.m_130281_();
                this.typeKeysToStructureKeys.put((Object)typeKey, (Object)structureKey);
            }
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedStructureKeys.size());
        for (ResourceLocation structureKey : this.allowedStructureKeys) {
            buf.m_130085_(structureKey);
            List dimensions = this.dimensionKeysForAllowedStructureKeys.get((Object)structureKey);
            buf.writeInt(dimensions.size());
            for (ResourceLocation dimensionKey : dimensions) {
                buf.m_130085_(dimensionKey);
            }
            ResourceLocation typeKey = this.structureKeysToTypeKeys.get(structureKey);
            buf.m_130085_(typeKey);
        }
        buf.writeInt(this.typeKeysToStructureKeys.keySet().size());
        for (ResourceLocation typeKey : this.typeKeysToStructureKeys.keySet()) {
            buf.m_130085_(typeKey);
            List structureKeys = this.typeKeysToStructureKeys.get((Object)typeKey);
            buf.writeInt(structureKeys.size());
            for (ResourceLocation structureKey : structureKeys) {
                buf.m_130085_(structureKey);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ExplorersCompass.canTeleport = this.canTeleport;
            ExplorersCompass.allowedStructureKeys = this.allowedStructureKeys;
            ExplorersCompass.dimensionKeysForAllowedStructureKeys = this.dimensionKeysForAllowedStructureKeys;
            ExplorersCompass.structureKeysToTypeKeys = this.structureKeysToTypeKeys;
            ExplorersCompass.typeKeysToStructureKeys = this.typeKeysToStructureKeys;
        });
        ctx.get().setPacketHandled(true);
    }
}

