/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunkio.common;

import com.ibm.asyncutil.util.Either;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.structs.RawByteArrayOutputStream;
import com.ishland.c2me.base.common.util.SneakyThrow;
import com.ishland.c2me.base.mixin.access.IRegionBasedStorage;
import com.ishland.c2me.base.mixin.access.IRegionFile;
import com.ishland.c2me.opts.chunkio.common.ConfigConstants;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2MEStorageThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME Storage");
    private static final AtomicLong SERIAL = new AtomicLong(0L);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final RegionFileStorage storage;
    private final Long2ReferenceLinkedOpenHashMap<Either<CompoundTag, byte[]>> writeBacklog = new Long2ReferenceLinkedOpenHashMap();
    private final Long2ReferenceLinkedOpenHashMap<Either<CompoundTag, byte[]>> cache = new Long2ReferenceLinkedOpenHashMap();
    private final ConcurrentLinkedQueue<ReadRequest> pendingReadRequests = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<WriteRequest> pendingWriteRequests = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> pendingTasks = new ConcurrentLinkedQueue();
    private final Executor executor = command -> {
        if (Thread.currentThread() == this) {
            command.run();
        } else {
            boolean empty = this.pendingTasks.isEmpty();
            this.pendingTasks.add(command);
            if (empty) {
                this.wakeUp();
            }
        }
    };
    private final ObjectArraySet<CompletableFuture<Void>> writeFutures = new ObjectArraySet();
    private final Object sync = new Object();

    public C2MEStorageThread(Path directory, boolean dsync, String name) {
        this.storage = new RegionFileStorage(directory, dsync);
        this.setName("C2ME Storage #%d".formatted(SERIAL.incrementAndGet()));
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Thread %s died".formatted(t), e));
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            boolean hasWork = false;
            this.runWriteFutureGC();
            if (hasWork |= this.pollTasks()) continue;
            if (this.closing.get()) {
                this.flush0(true);
                try {
                    this.storage.close();
                }
                catch (Throwable t) {
                    LOGGER.error("Error closing storage", t);
                }
                break;
            }
            if (!this.pollTasks()) {
                Thread.interrupted();
                for (int i = 0; i < 5000; ++i) {
                    if (this.pollTasks()) continue block7;
                    LockSupport.parkNanos("Spin-waiting for tasks", 10000L);
                }
            }
            Object object = this.sync;
            synchronized (object) {
                if (this.hasPendingTasks() || this.closing.get()) {
                    continue;
                }
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.closeFuture.complete(null);
        LOGGER.info("Storage thread {} stopped", (Object)this);
    }

    private boolean pollTasks() {
        boolean hasWork = false;
        hasWork = this.handleTasks() || hasWork;
        hasWork = this.handlePendingWrites() || hasWork;
        hasWork = this.handlePendingReads() || hasWork;
        hasWork = this.writeBacklog() || hasWork;
        return hasWork;
    }

    private boolean hasPendingTasks() {
        return !this.pendingTasks.isEmpty() || !this.pendingReadRequests.isEmpty() || !this.pendingWriteRequests.isEmpty() || !this.writeBacklog.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    public CompletableFuture<CompoundTag> getChunkData(long pos, StreamTagVisitor scanner) {
        CompletableFuture<CompoundTag> future = new CompletableFuture<CompoundTag>();
        if (this.closing.get()) {
            future.completeExceptionally(new CancellationException());
            return future.thenApply(Function.identity());
        }
        boolean empty = this.pendingReadRequests.isEmpty();
        this.pendingReadRequests.add(new ReadRequest(pos, future, scanner));
        if (empty) {
            this.wakeUp();
        }
        ((CompletableFuture)future.thenApply(Function.identity())).orTimeout(60L, TimeUnit.SECONDS).exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                LOGGER.warn("Chunk read at pos {} took too long (> 1min)", (Object)new ChunkPos(pos).m_45588_());
            }
            return null;
        });
        return future.thenApply(Function.identity());
    }

    public void setChunkData(long pos, @Nullable CompoundTag nbt) {
        boolean empty = this.pendingWriteRequests.isEmpty();
        this.pendingWriteRequests.add(new WriteRequest(pos, (Either<CompoundTag, byte[]>)(nbt != null ? Either.left((Object)nbt) : null)));
        if (empty) {
            this.wakeUp();
        }
    }

    public void setChunkData(long pos, @Nullable byte[] data) {
        boolean empty = this.pendingWriteRequests.isEmpty();
        this.pendingWriteRequests.add(new WriteRequest(pos, (Either<CompoundTag, byte[]>)(data != null ? Either.right((Object)data) : null)));
        if (empty) {
            this.wakeUp();
        }
    }

    public CompletableFuture<Void> flush(boolean sync) {
        return CompletableFuture.runAsync(() -> this.flush0(sync), this.executor);
    }

    private void flush0(boolean sync) {
        try {
            do {
                this.runWriteFutureGC();
            } while (this.handleTasks() || this.handlePendingReads() || this.handlePendingWrites() || this.writeBacklog());
            this.flushBacklog();
            if (sync) {
                this.storage.m_63705_();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error flushing storage", t);
        }
    }

    public CompletableFuture<Void> close() {
        this.closing.set(true);
        this.wakeUp();
        return this.closeFuture.thenApply(Function.identity());
    }

    private boolean handleTasks() {
        Runnable runnable;
        boolean hasWork = false;
        while ((runnable = this.pendingTasks.poll()) != null) {
            hasWork = true;
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Error while executing task", t);
            }
        }
        return hasWork;
    }

    private boolean handlePendingWrites() {
        WriteRequest writeRequest;
        boolean hasWork = false;
        while ((writeRequest = this.pendingWriteRequests.poll()) != null) {
            hasWork = true;
            this.cache.put(writeRequest.pos, writeRequest.nbt);
            this.writeBacklog.put(writeRequest.pos, writeRequest.nbt);
        }
        return hasWork;
    }

    private boolean handlePendingReads() {
        boolean hasWork = false;
        while (!this.pendingReadRequests.isEmpty()) {
            ReadRequest readRequest = this.pendingReadRequests.poll();
            hasWork = true;
            assert (readRequest != null);
            long pos = readRequest.pos;
            CompletableFuture<CompoundTag> future = readRequest.future;
            StreamTagVisitor scanner = readRequest.scanner;
            if (this.cache.containsKey(pos)) {
                Either cached = (Either)this.cache.get(pos);
                if (cached == null) {
                    future.complete(null);
                    continue;
                }
                if (cached.left().isPresent()) {
                    if (scanner != null) {
                        GlobalExecutors.executor.execute(() -> {
                            try {
                                ((CompoundTag)cached.left().get()).m_197573_(scanner);
                                future.complete(null);
                            }
                            catch (Throwable t) {
                                future.completeExceptionally(t);
                            }
                        });
                        continue;
                    }
                    future.complete((CompoundTag)cached.left().get());
                    continue;
                }
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        DataInputStream input = new DataInputStream(new ByteArrayInputStream((byte[])cached.right().get()));
                        if (scanner != null) {
                            NbtIo.m_197509_((DataInput)input, (StreamTagVisitor)scanner);
                            return null;
                        }
                        CompoundTag compound = NbtIo.m_128928_((DataInput)input);
                        return compound;
                    }
                    catch (IOException e) {
                        SneakyThrow.sneaky((Throwable)e);
                        return null;
                    }
                }, GlobalExecutors.executor).thenAccept(future::complete)).exceptionally(throwable -> {
                    future.completeExceptionally((Throwable)throwable);
                    return null;
                });
                continue;
            }
            this.scheduleChunkRead(pos, future, scanner);
        }
        return hasWork;
    }

    private boolean writeBacklog() {
        if (!this.writeBacklog.isEmpty()) {
            long pos = this.writeBacklog.firstLongKey();
            Either nbt = (Either)this.writeBacklog.removeFirst();
            this.writeChunk(pos, (Either<CompoundTag, byte[]>)nbt);
            return true;
        }
        return false;
    }

    private void runWriteFutureGC() {
        this.writeFutures.removeIf(CompletableFuture::isDone);
    }

    private void flushBacklog() {
        while (!this.writeFutures.isEmpty()) {
            while (this.writeBacklog()) {
            }
            this.runWriteFutureGC();
            CompletableFuture<Void> allFuture = CompletableFuture.allOf((CompletableFuture[])this.writeFutures.stream().map(future -> future.exceptionally(unused -> null)).distinct().toArray(CompletableFuture[]::new));
            while (!allFuture.isDone()) {
                this.handleTasks();
            }
            this.runWriteFutureGC();
        }
    }

    private void scheduleChunkRead(long pos, CompletableFuture<CompoundTag> future, StreamTagVisitor scanner) {
        try {
            ChunkPos pos1 = new ChunkPos(pos);
            RegionFile regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
            DataInputStream chunkInputStream = regionFile.m_63645_(pos1);
            if (chunkInputStream == null) {
                future.complete(null);
                return;
            }
            CompletableFuture.supplyAsync(() -> {
                try (DataInputStream inputStream = chunkInputStream;){
                    if (scanner != null) {
                        NbtIo.m_197509_((DataInput)inputStream, (StreamTagVisitor)scanner);
                        CompoundTag compoundTag2 = null;
                        return compoundTag2;
                    }
                    CompoundTag compoundTag = NbtIo.m_128928_((DataInput)inputStream);
                    return compoundTag;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, GlobalExecutors.executor).handle((compound, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete((CompoundTag)compound);
                }
                return null;
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
    }

    private void writeChunk(long pos, Either<CompoundTag, byte[]> nbt) {
        if (nbt == null) {
            if (this.cache.get(pos) == null) {
                try {
                    ChunkPos pos1 = new ChunkPos(pos);
                    RegionFile regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                    regionFile.m_156613_(pos1);
                }
                catch (Throwable t) {
                    LOGGER.error("Error writing chunk %s".formatted(new ChunkPos(pos)), t);
                }
                this.cache.remove(pos);
            }
        } else {
            CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    RawByteArrayOutputStream out = new RawByteArrayOutputStream(8096);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(ConfigConstants.CHUNK_STREAM_VERSION.m_63755_());
                    try (DataOutputStream dataOutputStream = new DataOutputStream(ConfigConstants.CHUNK_STREAM_VERSION.m_63762_((OutputStream)out));){
                        if (nbt.left().isPresent()) {
                            NbtIo.m_128941_((CompoundTag)((CompoundTag)nbt.left().get()), (DataOutput)dataOutputStream);
                        } else {
                            dataOutputStream.write((byte[])nbt.right().get());
                        }
                    }
                    return out;
                }
                catch (Throwable t) {
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                }
            }, GlobalExecutors.executor).thenAcceptAsync(bytes -> {
                if (nbt == this.cache.get(pos)) {
                    try {
                        ChunkPos pos1 = new ChunkPos(pos);
                        RegionFile regionFile = ((IRegionBasedStorage)this.storage).invokeGetRegionFile(pos1);
                        ByteBuffer byteBuffer = bytes.asByteBuffer();
                        byteBuffer.putInt(0, bytes.size() - 5 + 1);
                        ((IRegionFile)regionFile).invokeWriteChunk(pos1, byteBuffer);
                    }
                    catch (Throwable t) {
                        SneakyThrow.sneaky((Throwable)t);
                    }
                    this.cache.remove(pos);
                }
            }, this.executor)).handleAsync((unused, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Error writing chunk %s".formatted(new ChunkPos(pos)), throwable);
                }
                return null;
            }, this.executor);
            this.writeFutures.add((Object)future);
        }
    }

    private record ReadRequest(long pos, CompletableFuture<CompoundTag> future, @Nullable StreamTagVisitor scanner) {
    }

    private record WriteRequest(long pos, Either<CompoundTag, byte[]> nbt) {
    }
}

