/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.world.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.mralxart.etheria.items.SpellScrollItem;
import it.mralxart.etheria.items.base.ILootData;
import it.mralxart.etheria.magic.spells.SpellsRegistry;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.LootModifierRegistry;
import it.mralxart.etheria.world.loot.data.LootData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ItemsLootModifier
extends LootModifier {
    public static final Codec<ItemsLootModifier> CODEC = RecordCodecBuilder.create(instance -> ItemsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ItemsLootModifier::new));

    public ItemsLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootId = context.getQueriedLootTableId().toString();
        Random random = new Random();
        for (RegistryObject item : ItemRegistry.ITEMS.getEntries()) {
            Iterator<Map.Entry<String, List<Float>>> iterator = item.get();
            if (iterator instanceof ILootData) {
                ILootData data = (ILootData)((Object)iterator);
                if (data.getLootData() == null) continue;
                for (Map.Entry<String, List<Float>> lootData : data.getLootData().getLootCollection().entrySet()) {
                    boolean matches;
                    try {
                        matches = lootId.matches(lootData.getKey());
                    }
                    catch (PatternSyntaxException e) {
                        matches = lootId.equals(lootData.getKey());
                    }
                    if (!matches) continue;
                    for (Float chance : lootData.getValue()) {
                        if (!(random.nextFloat() <= chance.floatValue())) continue;
                        generatedLoot.add((Object)new ItemStack((ItemLike)item.get()));
                    }
                }
            }
            if (!(item.get() instanceof SpellScrollItem)) continue;
            Map<String, SpellData> spells = SpellsRegistry.createSpellsList().getSpells().getSpells();
            spells.forEach((spellId, spellData) -> {
                boolean matches;
                String data = LootData.createPattern(spellData.getElement(), "epic");
                try {
                    matches = lootId.matches(data);
                }
                catch (PatternSyntaxException e) {
                    matches = lootId.equals(data);
                }
                if (matches && random.nextFloat() <= spellData.getLootChance()) {
                    ItemStack stack = new ItemStack((ItemLike)item.get());
                    CompoundTag nbt = stack.m_41784_();
                    nbt.m_128359_("spell_id", spellData.getId());
                    nbt.m_128359_("etheria$element", SpellsUtils.getSpellElement(spellData.getId()));
                    generatedLoot.add((Object)stack);
                }
            });
        }
        if (lootId.matches(LootData.createPattern("", "epic")) && random.nextFloat() <= 0.1f) {
            generatedLoot.add((Object)((Item)ItemRegistry.ELEMENTARY_SCROLL.get()).m_7968_());
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)LootModifierRegistry.ITEMS.get();
    }
}

