/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.world.feature;

import com.mojang.serialization.Codec;
import it.mralxart.etheria.blocks.EtherSource;
import it.mralxart.etheria.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EtherSourceFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState ETHER_SOURCE = ((EtherSource)BlockRegistry.ETHER_SOURCE.get()).m_49966_();
    private static final BlockState BLACKSTONE = Blocks.f_50730_.m_49966_();

    public EtherSourceFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        BlockPos surfacePos = this.findSurface((LevelAccessor)world, origin);
        if (surfacePos == null) {
            return false;
        }
        world.m_7731_(surfacePos, ETHER_SOURCE, 3);
        this.generateBlackstone((LevelAccessor)world, surfacePos.m_7495_(), random);
        return true;
    }

    private BlockPos findSurface(LevelAccessor world, BlockPos pos) {
        for (int y = world.m_151558_(); y > world.m_141937_(); --y) {
            BlockPos checkPos = pos.m_175288_(y);
            if (!world.m_8055_(checkPos).m_60795_() || world.m_8055_(checkPos.m_7495_()).m_60795_()) continue;
            return checkPos;
        }
        return null;
    }

    private void generateBlackstone(LevelAccessor world, BlockPos origin, RandomSource random) {
        int currentRadius;
        int baseRadius = 2 + random.m_188503_(3);
        int depth = 2 + random.m_188503_(2);
        world.m_7731_(origin, BLACKSTONE, 3);
        for (int dy = 0; dy <= depth && (currentRadius = baseRadius - dy) > 0; ++dy) {
            for (int dx = -currentRadius; dx <= currentRadius; ++dx) {
                for (int dz = -currentRadius; dz <= currentRadius; ++dz) {
                    BlockPos targetPos = origin.m_7918_(dx, -dy, dz);
                    if (dx * dx + dz * dz > currentRadius * currentRadius || !((double)random.m_188501_() < 0.5)) continue;
                    world.m_7731_(targetPos, BLACKSTONE, 3);
                }
            }
        }
    }
}

