/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.utils;

import com.mojang.datafixers.util.Pair;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.AttributeEffectBuilder;
import it.mralxart.etheria.magic.weapon.base.WeaponRarity;
import it.mralxart.etheria.magic.weapon.base.WeaponType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WeaponUtils {
    public static final String STATS_TAG = "etheria$stats";

    public static int getLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128451_("etheria$level") == 0) {
            tag.m_128405_("etheria$level", 1);
        }
        return tag.m_128451_("etheria$level");
    }

    public static int getXp(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int level = WeaponUtils.getLevel(stack);
        if (level >= 60) {
            return WeaponUtils.getRequiredXp(stack);
        }
        return tag.m_128451_("etheria$xp");
    }

    public static void setXp(ItemStack stack, int level) {
        stack.m_41784_().m_128405_("etheria$xp", level);
    }

    public static ItemStack setLevel(ItemStack stack, int level) {
        stack.m_41784_().m_128405_("etheria$level", level);
        return stack;
    }

    public static int getStars(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("etheria$stars")) {
            tag.m_128405_("etheria$stars", 1);
        }
        return tag.m_128451_("etheria$stars");
    }

    public static ItemStack setStars(ItemStack stack, int stars) {
        stack.m_41784_().m_128405_("etheria$stars", stars);
        return stack;
    }

    public static List<Component> getTooltip(ItemStack stack) {
        Pair<StatType, double[]> mainStat;
        Item item = stack.m_41720_();
        if (!(item instanceof WeaponItem)) {
            return new ArrayList<Component>();
        }
        WeaponItem weapon = (WeaponItem)item;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        WeaponRarity rarity = weapon.getWeaponRarity();
        WeaponType type = weapon.getType();
        String typeKey = "etheria.weapon.type." + type.name().toLowerCase();
        MutableComponent typeComponent = Component.m_237115_((String)typeKey);
        int xp = WeaponUtils.getXp(stack);
        int level = WeaponUtils.getLevel(stack);
        float attackDamage = weapon.calculateDamage(stack);
        float attackSpeed = weapon.calculateAttackSpeed(stack);
        int color = rarity.getEndColor();
        int reqXp = WeaponUtils.getRequiredXp(stack);
        tooltip.add((Component)typeComponent.m_130948_(Style.f_131099_.m_178520_(color)));
        String rarityKey = "etheria.weapon.rarity." + rarity.name().toLowerCase();
        tooltip.add((Component)Component.m_237115_((String)"etheria.tooltip.rarity").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)rarityKey).m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"etheria.tooltip.xp").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)("[" + xp + "/" + reqXp + "]")).m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237115_((String)"etheria.tooltip.level").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)("[" + level + "/60]")).m_130940_(ChatFormatting.WHITE)));
        if (weapon.getAdditionalAttributes() != null && (mainStat = weapon.getAdditionalAttributes().getMainStat()) != null && mainStat.getSecond() != null && ((double[])mainStat.getSecond()).length > 0) {
            StatType statType = (StatType)((Object)mainStat.getFirst());
            double[] values = (double[])mainStat.getSecond();
            double min = values[0];
            double max = values[values.length - 1];
            double currentValue = level >= 60 ? max : (level <= 1 ? min : min + (max - min) * ((double)(level - 1) / 59.0));
            String statKey = "etheria.stat." + statType.name().toLowerCase();
            tooltip.add((Component)Component.m_237113_((String)" \u25b6 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)statKey).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("+" + WeaponUtils.format(currentValue))).m_130948_(Style.f_131099_.m_178520_(color))));
        }
        tooltip.add((Component)Component.m_237119_());
        if (!weapon.getAdditionalAttributes().getAttributes().isEmpty()) {
            int stars = WeaponUtils.getStars(stack);
            weapon.getAdditionalAttributes().buildPassiveTooltip(stack.m_41720_(), tooltip, stars, color);
            tooltip.add((Component)Component.m_237119_());
        }
        tooltip.add((Component)Component.m_237115_((String)"etheria.tooltip.statistics").m_130948_(Style.f_131099_.m_178520_(color)));
        tooltip.add((Component)Component.m_237113_((String)" \u25b6 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"etheria.tooltip.stat.damage").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)WeaponUtils.format(attackDamage)).m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)" \u25b6 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"etheria.tooltip.stat.attack_speed").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)WeaponUtils.format(4.0f + attackSpeed)).m_130940_(ChatFormatting.GRAY)));
        return tooltip;
    }

    private static String format(double value) {
        return String.format(Locale.ROOT, "%.2f", value);
    }

    public static int getRequiredXp(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof WeaponItem)) {
            return -1;
        }
        WeaponItem weapon = (WeaponItem)item;
        int level = WeaponUtils.getLevel(stack);
        if (level == 60) {
            --level;
        }
        int factor = switch (weapon.getWeaponRarity()) {
            default -> throw new IncompatibleClassChangeError();
            case WeaponRarity.COMMON -> 8;
            case WeaponRarity.FORTIFIED -> 10;
            case WeaponRarity.RARE -> 12;
            case WeaponRarity.ANCIENT -> 14;
            case WeaponRarity.ASCENDED -> 19;
            case WeaponRarity.STARRY -> 24;
        };
        int reqXp = factor * (int)Math.pow(level, 1.5);
        return reqXp;
    }

    public static ItemStack addXp(ItemStack stack, int xpToAdd) {
        if (!(stack.m_41720_() instanceof WeaponItem)) {
            return stack;
        }
        int currentLevel = WeaponUtils.getLevel(stack);
        if (currentLevel >= 60) {
            return stack;
        }
        int currentXp = WeaponUtils.getXp(stack);
        int totalXp = currentXp + xpToAdd;
        while (currentLevel < 60) {
            int requiredXp = WeaponUtils.getRequiredXp(stack);
            if (totalXp < requiredXp) {
                WeaponUtils.setXp(stack, totalXp);
                return stack;
            }
            totalXp -= requiredXp;
            WeaponUtils.setLevel(stack, ++currentLevel);
            if (currentLevel < 60) continue;
            WeaponUtils.setXp(stack, 0);
            return stack;
        }
        WeaponUtils.setXp(stack, 0);
        return stack;
    }

    public static void writeStatsToNbt(ItemStack stack, AttributeEffectBuilder builder, int starLevel) {
        CompoundTag tag = stack.m_41698_(STATS_TAG);
        for (Map.Entry<StatType, double[]> entry : builder.getAttributes().entrySet()) {
            StatType stat = entry.getKey();
            double[] values = entry.getValue();
            if (values.length <= 0) continue;
            tag.m_128350_(stat.name(), (float)values[Math.min(starLevel, values.length - 1)]);
        }
    }
}

