/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.mralxart.etheria.EtheriaClient;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.utils.EtherUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderUtils {
    public static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    public static RenderType getGlowingEffect(ResourceLocation location) {
        return RenderType.m_173215_((String)"etheria:glow_effect", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172700_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110685_(EtheriaClient.TRANSPARENCY).m_110691_(true));
    }

    public static void renderEtherBar(PoseStack stack, ItemStack itemStack, int posX, int posY) {
        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof IEtherEntryItem)) {
            return;
        }
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 290.0f);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        MultiBufferSource.BufferSource source = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int currentEther = EtherUtils.getEther(itemStack);
        int maxEther = EtherUtils.getMaxEther(itemStack);
        int etherBarWidth = (int)Math.ceil((float)currentEther / (float)maxEther * 14.0f);
        RenderUtils.fillGradientRectangle(matrix4f, -1, posX + 2, posY + 13, posX + 15, posY + 15, -14806232, -14806232);
        RenderUtils.fillGradientRectangle(matrix4f, -1, posX + 2, posY + 13, posX + etherBarWidth + 1, posY + 14, -2646020, -2646020);
        source.m_109911_();
        stack.m_85849_();
    }

    public static void fillGradientRectangle(Matrix4f matrix4f, int depth, int startX, int startY, int endX, int endY, int color1, int color2) {
        float alpha1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(color1 & 0xFF) / 255.0f;
        float alpha2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder bufBuilder = tess.m_85915_();
        bufBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufBuilder.m_252986_(matrix4f, (float)endX, (float)startY, (float)depth).m_85950_(red1, green1, blue1, alpha1).m_5752_();
        bufBuilder.m_252986_(matrix4f, (float)startX, (float)startY, (float)depth).m_85950_(red1, green1, blue1, alpha1).m_5752_();
        bufBuilder.m_252986_(matrix4f, (float)startX, (float)endY, (float)depth).m_85950_(red2, green2, blue2, alpha2).m_5752_();
        bufBuilder.m_252986_(matrix4f, (float)endX, (float)endY, (float)depth).m_85950_(red2, green2, blue2, alpha2).m_5752_();
        tess.m_85914_();
        RenderSystem.disableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static void renderDragonEffect(PoseStack poseStack, MultiBufferSource buffer, float ticks, float partialTicks, float scale, float red, float green, float blue, float seedModifier) {
        float intensity = 0.5f;
        Random rng = new Random((long)(432.0f + seedModifier));
        VertexConsumer vertexConsumer = buffer.m_6299_(EtheriaClient.GLOW_EFFECT);
        poseStack.m_85836_();
        float rotationSpeed = (ticks + partialTicks) / 200.0f;
        float rootThreeDivTwo = (float)(Math.sqrt(3.0) / 2.0);
        int effectCount = (int)((intensity + intensity * intensity) / 2.0f * 60.0f);
        for (int j = 0; j < effectCount; ++j) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rng.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rng.nextFloat() * 360.0f + rotationSpeed * 90.0f));
            float lengthFactor = rng.nextFloat() * 20.0f + 5.0f;
            float widthFactor = rng.nextFloat() * 2.0f + 1.0f;
            Matrix4f transformation = poseStack.m_85850_().m_252922_();
            RenderUtils.drawVertices(vertexConsumer, transformation, red, green, blue, 1.0f, rootThreeDivTwo, widthFactor *= 0.05f * scale, lengthFactor *= 0.05f * scale);
        }
        poseStack.m_85849_();
    }

    private static void drawVertices(VertexConsumer vertexConsumer, Matrix4f matrix, float red, float green, float blue, float alpha, float rootThreeDivTwo, float widthFactor, float lengthFactor) {
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, -rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, lengthFactor, widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, 0.0f, lengthFactor, widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -rootThreeDivTwo * widthFactor, lengthFactor, -0.5f * widthFactor).m_85950_(red, green, blue, 0.0f).m_5752_();
    }

    public static void renderLightning(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 start, Vec3 end, float thickness, float density, double bendFactor, int segments, long seed, float r, float g, float b, float alpha) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(EtheriaClient.GLOW_EFFECT);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        List<Vec3> linePoints = RenderUtils.generateBentLine(start, end, density, bendFactor, segments, seed);
        for (int i = 0; i < linePoints.size() - 1; ++i) {
            Vec3 segmentStart = linePoints.get(i);
            Vec3 segmentEnd = linePoints.get(i + 1);
            RenderUtils.drawVolumeLightningSegment(pose, vertexConsumer, segmentStart, segmentEnd, thickness, r, g, b, alpha);
        }
        RenderUtils.drawEndCap(pose, vertexConsumer, linePoints.get(0), linePoints.get(1), thickness, r, g, b, alpha);
        RenderUtils.drawEndCap(pose, vertexConsumer, linePoints.get(linePoints.size() - 1), linePoints.get(linePoints.size() - 2), thickness, r, g, b, alpha);
    }

    private static List<Vec3> generateBentLine(Vec3 start, Vec3 end, double density, double bendFactor, int segments, long seed) {
        int i;
        Random random = new Random(seed);
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3 direction = end.m_82546_(start);
        double totalLength = direction.m_82553_();
        Vec3 normalizedDirection = direction.m_82541_();
        Vec3[] segmentStarts = new Vec3[segments + 1];
        segmentStarts[0] = start;
        segmentStarts[segments] = end;
        for (i = 1; i < segments; ++i) {
            double t = (double)i / (double)segments;
            Vec3 basePoint = start.m_82549_(normalizedDirection.m_82490_(t * totalLength));
            double offsetX = (random.nextDouble() - 0.5) * bendFactor;
            double offsetY = (random.nextDouble() - 0.5) * bendFactor;
            double offsetZ = (random.nextDouble() - 0.5) * bendFactor;
            segmentStarts[i] = basePoint.m_82549_(new Vec3(offsetX, offsetY, offsetZ));
        }
        for (i = 0; i < segments; ++i) {
            Vec3 segmentStart = segmentStarts[i];
            Vec3 segmentEnd = segmentStarts[i + 1];
            Vec3 segmentDirection = segmentEnd.m_82546_(segmentStart);
            double segmentLength = segmentDirection.m_82553_();
            Vec3 segmentNormalizedDirection = segmentDirection.m_82541_();
            int segmentPoints = (int)(segmentLength * density);
            for (int j = 0; j < segmentPoints; ++j) {
                double t = (double)j / (double)segmentPoints;
                Vec3 point = segmentStart.m_82549_(segmentNormalizedDirection.m_82490_(t * segmentLength));
                points.add(point);
            }
        }
        points.add(end);
        return points;
    }

    private static void drawVolumeLightningSegment(Matrix4f pose, VertexConsumer vertexConsumer, Vec3 start, Vec3 end, float thickness, float r, float g, float b, float alpha) {
        Vector3f dir = new Vector3f((float)(end.f_82479_ - start.f_82479_), (float)(end.f_82480_ - start.f_82480_), (float)(end.f_82481_ - start.f_82481_));
        dir.normalize();
        Vector3f perp1 = new Vector3f(-dir.z, 0.0f, dir.x);
        perp1.normalize();
        perp1.mul(thickness);
        Vector3f perp2 = new Vector3f(0.0f, 1.0f, 0.0f);
        perp2.normalize();
        perp2.mul(thickness);
        Vec3 top1 = start.m_82520_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82520_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 top2 = start.m_82492_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82520_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 bottom1 = start.m_82520_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82492_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 bottom2 = start.m_82492_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82492_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 topEnd1 = end.m_82520_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82520_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 topEnd2 = end.m_82492_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82520_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 bottomEnd1 = end.m_82520_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82492_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 bottomEnd2 = end.m_82492_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82492_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        RenderUtils.drawQuad(pose, vertexConsumer, top1, top2, topEnd2, topEnd1, r, g, b, alpha);
        RenderUtils.drawQuad(pose, vertexConsumer, bottom1, bottom2, bottomEnd2, bottomEnd1, r, g, b, alpha);
        RenderUtils.drawQuad(pose, vertexConsumer, top1, bottom1, bottomEnd1, topEnd1, r, g, b, alpha);
        RenderUtils.drawQuad(pose, vertexConsumer, top2, bottom2, bottomEnd2, topEnd2, r, g, b, alpha);
    }

    private static void drawEndCap(Matrix4f pose, VertexConsumer vertexConsumer, Vec3 center, Vec3 nextPoint, float thickness, float r, float g, float b, float alpha) {
        Vector3f dir = new Vector3f((float)(nextPoint.f_82479_ - center.f_82479_), (float)(nextPoint.f_82480_ - center.f_82480_), (float)(nextPoint.f_82481_ - center.f_82481_));
        dir.normalize();
        Vector3f perp1 = new Vector3f(-dir.z, 0.0f, dir.x);
        perp1.normalize();
        perp1.mul(thickness);
        Vector3f perp2 = new Vector3f(0.0f, 1.0f, 0.0f);
        perp2.normalize();
        perp2.mul(thickness);
        Vec3 top1 = center.m_82520_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82520_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 top2 = center.m_82492_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82520_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 bottom1 = center.m_82520_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82492_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        Vec3 bottom2 = center.m_82492_((double)perp1.x, (double)perp1.y, (double)perp1.z).m_82492_((double)perp2.x, (double)perp2.y, (double)perp2.z);
        RenderUtils.drawQuad(pose, vertexConsumer, top1, top2, bottom2, bottom1, r, g, b, alpha);
    }

    private static void drawQuad(Matrix4f pose, VertexConsumer vertexConsumer, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, float r, float g, float b, float alpha) {
        vertexConsumer.m_252986_(pose, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
        vertexConsumer.m_252986_(pose, (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(r, g, b, alpha).m_5752_();
    }
}

