/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.utils;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.RandomUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class ParticleUtils {
    public static void drawParticleLine(ParticleOptions options, Level level, Vec3 start, Vec3 end, int particleCount, float velocityCap) {
        ParticleUtils.drawParticleLine(options, level, start, end, particleCount, velocityCap, 1.0f);
    }

    public static void drawParticlesToCenterNoY(ParticleOptions options, Level level, Vec3 center, int particleCount, float spawnRadius, float velocityCap, float posCap) {
        for (int i = 0; i < particleCount; ++i) {
            double theta = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double phi = level.f_46441_.m_188500_() * Math.PI;
            double radius = level.f_46441_.m_188500_() * (double)spawnRadius;
            double posX = center.m_7096_() + radius * Math.sin(phi) * Math.cos(theta);
            double posZ = center.m_7094_() + radius * Math.cos(phi);
            double deltaX = center.m_7096_() - (posX += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double deltaY = center.m_7098_();
            double deltaZ = center.m_7094_() - (posZ += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            double motionX = deltaX / length * level.f_46441_.m_188500_() * (double)velocityCap;
            double motionZ = deltaZ / length * level.f_46441_.m_188500_() * (double)velocityCap;
            if (level.f_46443_) {
                level.m_7106_(options, posX, center.m_7098_(), posZ, motionX, 0.0, motionZ);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(options, posX, center.m_7098_(), posZ, motionX, 0.0, motionZ));
        }
    }

    public static void drawParticlesToCenterWithSpiral(ParticleOptions options, Level level, Vec3 center, double spawnY, int particleCount, float spawnRadius, float velocityCap, float posCap) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double radius = level.f_46441_.m_188500_() * (double)spawnRadius;
            double posX = center.m_7096_() + radius * Math.cos(angle);
            double posZ = center.m_7094_() + radius * Math.sin(angle);
            double posY = spawnY + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double deltaX = center.m_7096_() - (posX += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double deltaY = center.m_7098_() - posY;
            double deltaZ = center.m_7094_() - (posZ += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            double motionX = deltaX / distance * level.f_46441_.m_188500_() * (double)velocityCap;
            double motionY = deltaY / distance * level.f_46441_.m_188500_() * (double)velocityCap;
            double motionZ = deltaZ / distance * level.f_46441_.m_188500_() * (double)velocityCap;
            double spiralStrength = 0.02 + level.f_46441_.m_188500_() * 0.02;
            motionX += -Math.sin(angle) * spiralStrength;
            motionZ += Math.cos(angle) * spiralStrength;
            if (level.f_46443_) {
                level.m_7106_(options, posX, posY, posZ, motionX, motionY, motionZ);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(options, posX, posY, posZ, motionX, motionY, motionZ));
        }
    }

    public static void drawParticlesToCenter(ParticleOptions options, Level level, Vec3 center, int particleCount, float spawnRadius, float velocityCap, float posCap) {
        for (int i = 0; i < particleCount; ++i) {
            double theta = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double phi = level.f_46441_.m_188500_() * Math.PI;
            double radius = level.f_46441_.m_188500_() * (double)spawnRadius;
            double posX = center.m_7096_() + radius * Math.sin(phi) * Math.cos(theta);
            double posY = center.m_7098_() + radius * Math.sin(phi) * Math.sin(theta);
            double posZ = center.m_7094_() + radius * Math.cos(phi);
            double deltaX = center.m_7096_() - (posX += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double deltaY = center.m_7098_() - (posY += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double deltaZ = center.m_7094_() - (posZ += level.f_46441_.m_188583_() * 0.1 * (double)posCap);
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            double motionX = deltaX / length * level.f_46441_.m_188500_() * (double)velocityCap;
            double motionY = deltaY / length * level.f_46441_.m_188500_() * (double)velocityCap;
            double motionZ = deltaZ / length * level.f_46441_.m_188500_() * (double)velocityCap;
            if (level.m_5776_()) {
                level.m_7106_(options, posX, posY, posZ, motionX * (double)velocityCap, motionY * (double)velocityCap, motionZ * (double)velocityCap);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(options, posX, posY, posZ, motionX * (double)velocityCap, motionY * (double)velocityCap, motionZ * (double)velocityCap));
        }
    }

    public static void drawParticleLine(ParticleOptions options, Level level, Vec3 start, Vec3 end, int particleCount, float velocityCap, float posCap) {
        double deltaX = end.m_7096_() - start.m_7096_();
        double deltaY = end.m_7098_() - start.m_7098_();
        double deltaZ = end.m_7094_() - start.m_7094_();
        double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            double posX = start.m_7096_() + deltaX * progress + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double posY = start.m_7098_() + deltaY * progress + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double posZ = start.m_7094_() + deltaZ * progress + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double motionX = deltaX / length * level.f_46441_.m_188500_() * 0.1;
            double motionY = deltaY / length * level.f_46441_.m_188500_() * 0.1;
            double motionZ = deltaZ / length * level.f_46441_.m_188500_() * 0.1;
            if (level.m_5776_()) {
                level.m_7106_(options, posX, posY, posZ, motionX * (double)velocityCap, motionY * (double)velocityCap, motionZ * (double)velocityCap);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(options, posX, posY, posZ, motionX * (double)velocityCap, motionY * (double)velocityCap, motionZ * (double)velocityCap));
        }
    }

    public static void drawParticleLine(ParticleOptions options, Level level, Vec3 start, Vec3 end, int particleCount, float velocityCap, float posCap, float limit) {
        double deltaX = end.m_7096_() - start.m_7096_();
        double deltaY = end.m_7098_() - start.m_7098_();
        double deltaZ = end.m_7094_() - start.m_7094_();
        double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double maxLength = Math.min(length, (double)limit);
        double scale = maxLength / length;
        double limitedEndX = start.m_7096_() + deltaX * scale;
        double limitedEndY = start.m_7098_() + deltaY * scale;
        double limitedEndZ = start.m_7094_() + deltaZ * scale;
        double limitedDeltaX = limitedEndX - start.m_7096_();
        double limitedDeltaY = limitedEndY - start.m_7098_();
        double limitedDeltaZ = limitedEndZ - start.m_7094_();
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            double posX = start.m_7096_() + limitedDeltaX * progress + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double posY = start.m_7098_() + limitedDeltaY * progress + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double posZ = start.m_7094_() + limitedDeltaZ * progress + level.f_46441_.m_188583_() * 0.1 * (double)posCap;
            double motionX = limitedDeltaX / maxLength * level.f_46441_.m_188500_() * 0.1;
            double motionY = limitedDeltaY / maxLength * level.f_46441_.m_188500_() * 0.1;
            double motionZ = limitedDeltaZ / maxLength * level.f_46441_.m_188500_() * 0.1;
            Networking.sendToAll(new ParticleSpawnerPacket(options, posX, posY, posZ, motionX * (double)velocityCap, motionY * (double)velocityCap, motionZ * (double)velocityCap));
        }
    }

    public static void drawAnimatedCylNoUp(Level level, Vec3 pos, int tickCount, double radius, Color color) {
        if (level.m_5776_()) {
            return;
        }
        radius -= (double)tickCount * 0.01;
        for (int i = 0; i < 8; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(color, Math.max(0.1f, (float)radius / 8.0f), 6, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0));
        }
    }

    public static void drawAnimatedCylNoUp(ParticleOptions options, Level level, Vec3 pos, int tickCount, double radius) {
        if (level.m_5776_()) {
            return;
        }
        radius -= (double)tickCount * 0.01;
        for (int i = 0; i < 8; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            Networking.sendToAll(new ParticleSpawnerPacket(options, extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0));
        }
    }

    public static void createSwirlParticleEffect(Level level, ParticleOptions options, Vec3 center, double radius, double height, int particleCount, float spinSpeed, float upwardVelocity) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double currentRadius = radius * (0.5 + level.f_46441_.m_188500_() * 0.5);
            double yOffset = level.f_46441_.m_188500_() * height;
            double x = center.m_7096_() + Math.cos(angle) * currentRadius;
            double z = center.m_7094_() + Math.sin(angle) * currentRadius;
            double y = center.m_7098_() + yOffset;
            double spinX = -Math.sin(angle) * (double)spinSpeed;
            double spinZ = Math.cos(angle) * (double)spinSpeed;
            double pullX = -Math.cos(angle) * ((double)spinSpeed * 0.3);
            double pullZ = -Math.sin(angle) * ((double)spinSpeed * 0.3);
            double velX = spinX + pullX;
            double velY = (double)upwardVelocity + (double)level.f_46441_.m_188501_() * 0.05;
            double velZ = spinZ + pullZ;
            ParticleUtils.createParticle(level, options, x, y, z, 1, velX, velY, velZ);
        }
    }

    public static void createInwardParticleCircle(Level level, ParticleOptions particleOptions, Vec3 center, double radius, int particleCount, float upwardVelocity) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * level.f_46441_.m_188500_();
            double sourceX = center.m_7096_() + radius * Math.cos(angle);
            double sourceZ = center.m_7094_() + radius * Math.sin(angle);
            double sourceY = center.m_7098_();
            double dirX = center.m_7096_() - sourceX;
            double dirZ = center.m_7094_() - sourceZ;
            double dirY = upwardVelocity;
            double length = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
            ParticleUtils.createParticle(level, particleOptions, sourceX, sourceY, sourceZ, 1, (dirX /= length) * 0.1, (dirY /= length) * 0.15, (dirZ /= length) * 0.1);
        }
    }

    public static void drawAnimatedCyl(Level level, Vec3 pos, int tickCount, double radius, Color color) {
        for (int i = 0; i < 10; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            if (level.m_5776_()) {
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, Math.max(0.1f, (float)radius / 5.0f), 6, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(color, Math.max(0.1f, (float)radius / 5.0f), 6, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0));
        }
    }

    public static void drawAnimatedCyl(Level level, Vec3 pos, int tickCount, double radius, int lifeTime, int count, Color color) {
        for (int i = 0; i < count; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            if (level.m_5776_()) {
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, Math.max(0.1f, (float)radius / 5.0f), lifeTime, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(color, Math.max(0.1f, (float)radius / 5.0f), lifeTime, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0));
        }
    }

    public static void drawAnimatedCyl(Level level, ParticleOptions options, Vec3 pos, int tickCount, double radius, int count) {
        for (int i = 0; i < count; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            if (level.m_5776_()) {
                level.m_7106_(options, extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(options, extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0));
        }
    }

    public static void drawClientAnimatedCyl(Level level, Vec3 pos, int tickCount, double radius, Color color) {
        for (int i = 0; i < 10; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            level.m_6493_((ParticleOptions)new GlowingParticleData(color, Math.max(0.1f, (float)radius / 4.0f), 6, 0.02f), true, extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0);
        }
    }

    public static void drawAnimatedCylWithLines(Level level, Vec3 pos, int tickCount, double radius, Color color, Vec3 pos2) {
        if (level.m_5776_()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 8.0) + 0.01f * (float)(tickCount * 3);
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle))) + pos.f_82479_;
            double extraZ = radius * (double)Mth.m_14089_((float)angle) + pos.f_82481_;
            if (level.m_5776_()) {
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, Math.max(0.1f, (float)radius / 5.0f), 6, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0);
            } else {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(color, Math.max(0.1f, (float)radius / 5.0f), 6, 0.002f), extraX, pos.f_82480_, extraZ, 0.0, 0.0, 0.0));
            }
            ParticleUtils.drawParticleLine(new GlowingParticleData(color, 0.2f, 40, 0.025f), level, new Vec3(extraX, pos.f_82480_, extraZ), pos2, 1, 1.2f);
        }
    }

    public static void drawTriangleWings(Level level, ParticleOptions particleOptions, Entity entity, double wingSpan, double wingChord, int particleDensity, double maxSpeed) {
        Vec3 attachPoint = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.75, 0.0);
        float yaw = entity.m_146908_();
        double yawRad = Math.toRadians(-yaw);
        Vec3 baseForwardDir = new Vec3(Math.sin(yawRad), 0.0, Math.cos(yawRad)).m_82541_();
        Vec3 movement = entity.m_20184_();
        double speed = movement.m_82553_();
        Vec3 flowDirection = speed < 0.01 ? baseForwardDir : movement.m_82541_().m_82490_(-1.0);
        double blendFactor = Mth.m_14008_((double)(speed / maxSpeed), (double)0.0, (double)1.0);
        Vec3 finalForwardDir = baseForwardDir.m_165921_(flowDirection, blendFactor).m_82541_();
        Vec3 upVector = new Vec3(0.0, 1.0, 0.0);
        Vec3 finalRightDir = upVector.m_82537_(finalForwardDir).m_82541_();
        for (int side = -1; side <= 1; side += 2) {
            Vec3 wingDirection = finalRightDir.m_82490_((double)side);
            int stepsSpan = (int)((double)particleDensity * wingSpan);
            for (int i = 0; i < stepsSpan; ++i) {
                double spanProgress = (double)i / (double)stepsSpan;
                Vec3 spanOffset = wingDirection.m_82490_(spanProgress * wingSpan);
                double currentChord = wingChord * (1.0 - spanProgress);
                int stepsChord = (int)((double)particleDensity * currentChord / 2.0);
                for (int j = 0; j < stepsChord; ++j) {
                    if (level.f_46441_.m_188501_() > 0.65f) continue;
                    double chordProgress = level.f_46441_.m_188500_() - 0.5;
                    Vec3 chordOffset = finalForwardDir.m_82490_(chordProgress * currentChord);
                    Vec3 particlePos = attachPoint.m_82549_(spanOffset).m_82549_(chordOffset);
                    ParticleUtils.createParticle(level, particleOptions, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void createHollowAABB(Level level, ParticleOptions particleOptions, AABB box, int count, double maxSpeed) {
        double minX = box.f_82288_;
        double minY = box.f_82289_;
        double minZ = box.f_82290_;
        double maxX = box.f_82291_;
        double maxY = box.f_82292_;
        double maxZ = box.f_82293_;
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            int edge = random.nextInt(12);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            switch (edge) {
                case 0: {
                    x = minX;
                    y = minY + random.nextDouble() * (maxY - minY);
                    z = minZ;
                    break;
                }
                case 1: {
                    x = maxX;
                    y = minY + random.nextDouble() * (maxY - minY);
                    z = minZ;
                    break;
                }
                case 2: {
                    x = minX;
                    y = minY + random.nextDouble() * (maxY - minY);
                    z = maxZ;
                    break;
                }
                case 3: {
                    x = maxX;
                    y = minY + random.nextDouble() * (maxY - minY);
                    z = maxZ;
                    break;
                }
                case 4: {
                    x = minX + random.nextDouble() * (maxX - minX);
                    y = minY;
                    z = minZ;
                    break;
                }
                case 5: {
                    x = minX + random.nextDouble() * (maxX - minX);
                    y = maxY;
                    z = minZ;
                    break;
                }
                case 6: {
                    x = minX + random.nextDouble() * (maxX - minX);
                    y = minY;
                    z = maxZ;
                    break;
                }
                case 7: {
                    x = minX + random.nextDouble() * (maxX - minX);
                    y = maxY;
                    z = maxZ;
                    break;
                }
                case 8: {
                    x = minX;
                    y = minY;
                    z = minZ + random.nextDouble() * (maxZ - minZ);
                    break;
                }
                case 9: {
                    x = maxX;
                    y = minY;
                    z = minZ + random.nextDouble() * (maxZ - minZ);
                    break;
                }
                case 10: {
                    x = minX;
                    y = maxY;
                    z = minZ + random.nextDouble() * (maxZ - minZ);
                    break;
                }
                case 11: {
                    x = maxX;
                    y = maxY;
                    z = minZ + random.nextDouble() * (maxZ - minZ);
                }
            }
            double velX = (random.nextDouble() - 0.5) * maxSpeed;
            double velY = (random.nextDouble() - 0.5) * maxSpeed;
            double velZ = (random.nextDouble() - 0.5) * maxSpeed;
            ParticleUtils.createParticle(level, particleOptions, x, y, z, 1, velX, velY, velZ, maxSpeed);
        }
    }

    public static void createAABB(Level level, ParticleOptions particleOptions, AABB box, int count, double maxSpeed) {
        Vec3 center = box.m_82399_();
        double deltaX = box.m_82362_() / 2.0;
        double deltaY = box.m_82376_() / 2.2;
        double deltaZ = box.m_82385_() / 2.0;
        ParticleUtils.createParticle(level, particleOptions, center.f_82479_, center.f_82480_, center.f_82481_, count, deltaX, deltaY, deltaZ, maxSpeed);
    }

    public static void createParticle(Level world, ParticleOptions particle, Vec3 pos, int amount, double spreadX, double spreadY, double spreadZ, double velocityCap) {
        ParticleUtils.createParticle(world, particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, amount, spreadX, spreadY, spreadZ, velocityCap);
    }

    public static void createParticle(Level world, ParticleOptions particle, Vec3 pos, int amount, double spreadX, double spreadY, double spreadZ) {
        ParticleUtils.createParticle(world, particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, amount, spreadX, spreadY, spreadZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createParticle(Level world, ParticleOptions particle, double posX, double posY, double posZ, int amount, double spreadX, double spreadY, double spreadZ, double velocityCap) {
        Random random = new Random();
        if (world.f_46443_) {
            if (amount == 0) {
                double velocityX = spreadX * velocityCap;
                double velocityY = spreadY * velocityCap;
                double velocityZ = spreadZ * velocityCap;
                world.m_6493_(particle, true, posX, posY, posZ, velocityX, velocityY, velocityZ);
            } else {
                Random random2 = random;
                synchronized (random2) {
                    for (int j = 0; j < amount; ++j) {
                        double offsetX = random.nextGaussian() * spreadX;
                        double offsetY = random.nextGaussian() * spreadY;
                        double offsetZ = random.nextGaussian() * spreadZ;
                        double speedX = random.nextGaussian() * velocityCap;
                        double speedY = random.nextGaussian() * velocityCap;
                        double speedZ = random.nextGaussian() * velocityCap;
                        world.m_6493_(particle, true, posX + offsetX, posY + offsetY, posZ + offsetZ, speedX, speedY, speedZ);
                    }
                }
            }
        } else {
            Random random3 = random;
            synchronized (random3) {
                for (int j = 0; j < amount; ++j) {
                    double offsetX = random.nextGaussian() * spreadX;
                    double offsetY = random.nextGaussian() * spreadY;
                    double offsetZ = random.nextGaussian() * spreadZ;
                    double speedX = random.nextGaussian() * velocityCap;
                    double speedY = random.nextGaussian() * velocityCap;
                    double speedZ = random.nextGaussian() * velocityCap;
                    Networking.sendToAll(new ParticleSpawnerPacket(particle, posX + offsetX, posY + offsetY, posZ + offsetZ, speedX, speedY, speedZ));
                }
            }
        }
    }

    public static void createVelocityParticle(Level world, ParticleOptions particle, Vec3 pos, int amount, double spreadX, double spreadY, double spreadZ, double velocityCap) {
        Random random = new Random();
        if (world.f_46443_) {
            if (amount == 0) {
                double velocityX = spreadX > 0.0 ? spreadX * velocityCap : random.nextDouble() * spreadX * velocityCap;
                double velocityY = spreadY > 0.0 ? spreadY * velocityCap : random.nextDouble() * spreadY * velocityCap;
                double velocityZ = spreadZ > 0.0 ? spreadZ * velocityCap : random.nextDouble() * spreadZ * velocityCap;
                world.m_6493_(particle, true, pos.f_82479_, pos.f_82480_, pos.f_82481_, velocityX, velocityY, velocityZ);
            } else {
                for (int j = 0; j < amount; ++j) {
                    double offsetX = (spreadX > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadX);
                    double offsetY = (spreadY > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadY);
                    double offsetZ = (spreadZ > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadZ);
                    double speedX = (spreadX > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadX) * velocityCap;
                    double speedY = (spreadY > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadY) * velocityCap;
                    double speedZ = (spreadZ > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadZ) * velocityCap;
                    world.m_6493_(particle, true, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, speedX, speedY, speedZ);
                }
            }
        } else {
            for (int j = 0; j < amount; ++j) {
                double offsetX = (spreadX > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadX);
                double offsetY = (spreadY > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadY);
                double offsetZ = (spreadZ > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadZ);
                double speedX = (spreadX > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadX) * velocityCap;
                double speedY = (spreadY > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadY) * velocityCap;
                double speedZ = (spreadZ > 0.0 ? random.nextGaussian() : random.nextDouble() - 1.0) * Math.abs(spreadZ) * velocityCap;
                Networking.sendToAll(new ParticleSpawnerPacket(particle, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, speedX, speedY, speedZ));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createParticle(Level world, ParticleOptions particle, double posX, double posY, double posZ, int amount, double spreadX, double spreadY, double spreadZ) {
        Random random = new Random();
        if (world.f_46443_) {
            if (amount == 0) {
                world.m_6493_(particle, true, posX, posY, posZ, spreadX, spreadY, spreadZ);
            } else {
                Random random2 = random;
                synchronized (random2) {
                    for (int j = 0; j < amount; ++j) {
                        world.m_6493_(particle, true, posX, posY, posZ, spreadX, spreadY, spreadZ);
                    }
                }
            }
        } else {
            Random random3 = random;
            synchronized (random3) {
                for (int j = 0; j < amount; ++j) {
                    Networking.sendToAll(new ParticleSpawnerPacket(particle, posX, posY, posZ, spreadX, spreadY, spreadZ));
                }
            }
        }
    }

    public static void createWavyLine(Level level, ParticleOptions particle, Vec3 start, Vec3 end, int tickCount, int maxTime, double density, double amplitude, long seed, boolean finish) {
        double progress = Math.min(1.0, (double)tickCount / (double)maxTime);
        List<Vec3> linePoints = ParticleUtils.generateSmoothSpiralLine(start, end, density, amplitude, seed);
        int pointsToDisplay = (int)((double)linePoints.size() * progress);
        for (int i = 0; i < pointsToDisplay; ++i) {
            Vec3 point = linePoints.get(i);
            if (level.m_5776_()) {
                level.m_6493_(particle, true, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(particle, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0));
        }
    }

    public static void createWavyLine(Level level, ParticleOptions particle, Vec3 start, Vec3 end, int tickCount, int maxTime, double density, double amplitude, long seed) {
        double progress = (double)tickCount / (double)maxTime;
        List<Vec3> linePoints = ParticleUtils.generateSmoothSpiralLine(start, end, density, amplitude, seed);
        int totalPoints = linePoints.size();
        int startIndex = 0;
        int endIndex = (int)((double)totalPoints * progress);
        if (progress > 0.5) {
            double adjustedProgress = (progress - 0.5) * 2.0;
            startIndex = (int)((double)totalPoints * adjustedProgress);
        }
        startIndex = Math.min(startIndex, totalPoints - 1);
        endIndex = Math.min(endIndex, totalPoints);
        for (int i = startIndex; i < endIndex; ++i) {
            Vec3 point = linePoints.get(i);
            if (level.m_5776_()) {
                level.m_6493_(particle, true, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(particle, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, 0.0, 0.0));
        }
    }

    private static List<Vec3> generateSmoothSpiralLine(Vec3 start, Vec3 end, double density, double amplitude, long seed) {
        Random random = new Random(seed);
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3 direction = end.m_82546_(start);
        double totalLength = direction.m_82553_();
        Vec3 normalizedDirection = direction.m_82541_();
        double amplitudeVariation = 0.5 + (double)random.nextFloat() * 1.5;
        double adjustedAmplitude = amplitude * amplitudeVariation;
        int totalPoints = (int)(totalLength * density);
        points.add(start);
        for (int i = 1; i < totalPoints; ++i) {
            double t = (double)i / (double)totalPoints;
            double scaledAmplitude = adjustedAmplitude * ParticleUtils.smoothStep(t);
            Vec3 pointOnLine = start.m_82549_(normalizedDirection.m_82490_(t * totalLength));
            Vec3 offset = ParticleUtils.generateSpiralOffset(t, scaledAmplitude);
            Vec3 finalPoint = pointOnLine.m_82549_(offset);
            points.add(finalPoint);
        }
        points.add(end);
        return points;
    }

    private static Vec3 generateSpiralOffset(double t, double amplitude) {
        double angle = t * Math.PI * 2.0;
        double offsetX = Math.sin(angle) * amplitude;
        double offsetY = Math.cos(angle) * amplitude;
        return new Vec3(offsetX, offsetY, 0.0);
    }

    private static double smoothStep(double t) {
        return t * (1.0 - t) * 4.0;
    }

    public static void createSpringSpiral(Level level, ParticleOptions particle, Vec3 start, Vec3 end, int tickCount, int maxTime, double density, double amplitude, double twistFrequency, long seed, boolean finish) {
        double progress = Math.min(1.0, (double)tickCount / (double)maxTime);
        List<Vec3> spiralPoints1 = ParticleUtils.generateSpringSpiral(start, end, density, amplitude, twistFrequency, seed, 0.0);
        List<Vec3> spiralPoints2 = ParticleUtils.generateSpringSpiral(start, end, density, amplitude, twistFrequency, seed, Math.PI);
        int pointsToDisplay = (int)((double)spiralPoints1.size() * progress);
        for (int i = 0; i < pointsToDisplay; ++i) {
            Vec3 point1 = spiralPoints1.get(i);
            Vec3 point2 = spiralPoints2.get(i);
            if (level.m_5776_()) {
                level.m_6493_(particle, true, point1.f_82479_, point1.f_82480_, point1.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0);
                level.m_6493_(particle, true, point2.f_82479_, point2.f_82480_, point2.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(particle, point1.f_82479_, point1.f_82480_, point1.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0));
            Networking.sendToAll(new ParticleSpawnerPacket(particle, point2.f_82479_, point2.f_82480_, point2.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0));
        }
    }

    public static void createLines(Level level, Vec3 posCenter, Vec3 posRes, List<LineData> lines, @Nullable Runnable runnable, float radius, int maxTime) {
        ParticleUtils.createLines(level, posCenter, posRes, lines, runnable, radius, 0.2f, maxTime, 20, true);
    }

    public static void createLines(Level level, Vec3 posCenter, Vec3 posRes, List<LineData> lines, @Nullable Runnable runnable, float radius, float amplitude, int maxTime, int density, boolean isRandom) {
        ParticleUtils.createLines(level, ElementsUtils.getRandomColorByElement(Element.ETHER), posCenter, posRes, lines, runnable, radius, amplitude, maxTime, density, isRandom);
    }

    public static void createLines(Level level, Color color, Vec3 posCenter, Vec3 posRes, List<LineData> lines, @Nullable Runnable runnable, float radius, float amplitude, int maxTime, int density, boolean isRandom) {
        int i;
        for (i = 0; i < lines.size(); ++i) {
            LineData line = lines.get(i);
            ++line.tickCount;
            if (line.tickCount >= maxTime) {
                line.tickCount = 0;
                line.seed = RandomUtils.randomSeeds.get(new Random().nextInt(RandomUtils.randomSeeds.size()));
                if (isRandom) {
                    line.randomOffsetX = RandomUtils.random().nextFloat(-radius, radius);
                    line.randomOffsetY = RandomUtils.random().nextFloat(-1.0f, 1.0f);
                    line.randomOffsetZ = RandomUtils.random().nextFloat(-radius, radius);
                } else {
                    line.randomOffsetX = 0.0f;
                    line.randomOffsetY = 0.0f;
                    line.randomOffsetZ = 0.0f;
                }
                if (runnable != null) {
                    runnable.run();
                }
                ParticleUtils.createParticle(level, new GlowingParticleData(color, 0.4f, 30 + level.f_46441_.m_216339_(5, 10), 0.002f), posRes.f_82479_ + (double)line.randomOffsetX, posRes.f_82480_ + (double)line.randomOffsetY, posRes.f_82481_ + (double)line.randomOffsetZ, 5, 0.02, 0.02, 0.02, 0.005f);
            }
            if (line.tickCount >= maxTime - 5) {
                ParticleUtils.createParticle(level, new GlowingParticleData(color, 0.3f, 10 + level.f_46441_.m_216339_(5, 10), 0.002f), posCenter.f_82479_, posCenter.f_82480_, posCenter.f_82481_, 2, 0.02, 0.02, 0.02, 0.005f);
            }
            float offset = i % 2 == 0 ? amplitude - (float)line.seed * 0.01f : -amplitude + (float)line.seed * 0.01f;
            ParticleUtils.createWavyLine(level, new GlowingParticleData(color, 0.2f + (float)(maxTime - line.tickCount) * 0.003f, 3, 0.1f), posRes.m_82520_((double)line.randomOffsetX, (double)line.randomOffsetY, (double)line.randomOffsetZ), posCenter, line.tickCount, maxTime - 5, density, offset, line.seed);
        }
        for (i = 1; i < lines.size(); ++i) {
            LineData current = lines.get(i);
            LineData previous = lines.get(i - 1);
            if (current.tickCount != previous.tickCount) continue;
            current.tickCount += 16;
        }
    }

    private static List<Vec3> generateSpringSpiral(Vec3 start, Vec3 end, double density, double amplitude, double twistFrequency, long seed, double phaseOffset) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3 direction = end.m_82546_(start);
        double totalLength = direction.m_82553_();
        Vec3 normalizedDirection = direction.m_82541_();
        int totalPoints = (int)(totalLength * density);
        points.add(start);
        for (int i = 1; i < totalPoints; ++i) {
            double t = (double)i / (double)totalPoints;
            double angle = t * Math.PI * 2.0 * twistFrequency + phaseOffset;
            double offsetX = Math.cos(angle) * amplitude;
            double offsetY = Math.sin(angle) * amplitude;
            double offsetZ = Math.sin(angle * 2.0) * amplitude * 0.5;
            Vec3 pointOnLine = start.m_82549_(normalizedDirection.m_82490_(t * totalLength));
            Vec3 finalPoint = pointOnLine.m_82549_(new Vec3(offsetX, offsetY, offsetZ));
            points.add(finalPoint);
        }
        points.add(end);
        return points;
    }

    public static void createSiphonLines(Level level, Color color, Vec3 posCenter, List<LineData> lines, float radius, int maxTime, int density, boolean upper) {
        for (LineData line : lines) {
            ++line.tickCount;
            if (line.tickCount >= maxTime) {
                line.tickCount = 0;
                line.seed = RandomUtils.randomSeeds.get(new Random().nextInt(RandomUtils.randomSeeds.size()));
                double theta = RandomUtils.random().nextDouble() * 2.0 * Math.PI;
                double phi = Math.acos(2.0 * RandomUtils.random().nextDouble() - 1.0);
                line.randomOffsetX = (float)((double)radius * Math.sin(phi) * Math.cos(theta));
                float rawY = (float)((double)radius * Math.sin(phi) * Math.sin(theta));
                line.randomOffsetZ = (float)((double)radius * Math.cos(phi));
                line.randomOffsetY = upper ? Math.abs(rawY) : rawY;
            }
            Vec3 startPos = posCenter.m_82520_((double)line.randomOffsetX, (double)line.randomOffsetY, (double)line.randomOffsetZ);
            float intensity = (float)line.tickCount / (float)maxTime;
            ParticleUtils.generateVortexPath(level, color, startPos, posCenter, density, line.seed, intensity);
        }
        for (int i = 1; i < lines.size(); ++i) {
            LineData current = lines.get(i);
            LineData previous = lines.get(i - 1);
            if (current.tickCount != previous.tickCount) continue;
            current.tickCount += maxTime / lines.size();
        }
    }

    private static void generateVortexPath(Level level, Color color, Vec3 start, Vec3 center, int density, long seed, float progress) {
        Vec3 directionVector = start.m_82546_(center);
        double totalDistance = directionVector.m_82553_();
        int points = (int)(totalDistance * (double)density);
        double rotationDir = seed % 2L == 0L ? 1.0 : -1.0;
        Vec3 baseDir = directionVector.m_82541_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(baseDir.f_82480_) > 0.95) {
            up = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 right = baseDir.m_82537_(up).m_82541_();
        Vec3 forward = baseDir.m_82537_(right).m_82541_();
        for (int i = 0; i < points; ++i) {
            double t = (double)i / (double)points;
            double currentRadius = totalDistance * (1.0 - t);
            double angle = t * 3.0 * Math.PI * rotationDir + (double)(progress * 2.0f);
            double offsetX = Math.cos(angle) * currentRadius * 0.2;
            double offsetY = Math.sin(angle) * currentRadius * 0.2;
            Vec3 positionOnAxis = center.m_82549_(directionVector.m_82490_(1.0 - t));
            Vec3 spiralOffset = right.m_82490_(offsetX).m_82549_(forward.m_82490_(offsetY));
            Vec3 finalPos = positionOnAxis.m_82549_(spiralOffset);
            float particleSize = 0.25f * (1.0f - (float)t) + 0.05f;
            ParticleUtils.createParticle(level, new GlowingParticleData(color.getRGB(), particleSize, 5, 0.2f, 1.0f, true, true, false), finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<CrackPoint> generateSmartFractureSystem(Vec3 center, float maxRadius, int maxTime, float particleDensity, int bonusBranches) {
        ArrayList<CrackPoint> allPoints = new ArrayList<CrackPoint>();
        ArrayList<FractureTip> activeTips = new ArrayList<FractureTip>();
        Random random = RandomUtils.random();
        int startBranches = 7 + random.nextInt(4) + bonusBranches;
        float collisionRadius = 1.5f;
        float startLength = 2.8f;
        float lengthDecay = 0.85f;
        allPoints.add(new CrackPoint(center, 0, 1.2f));
        for (int i = 0; i < startBranches; ++i) {
            double angle = Math.PI * 2 / (double)startBranches * (double)i;
            activeTips.add(new FractureTip(center, angle += (random.nextDouble() - 0.5) * 0.6, 0));
        }
        boolean growing = true;
        int safetyLoop = 0;
        while (growing && !activeTips.isEmpty() && safetyLoop < 100) {
            ++safetyLoop;
            ArrayList<FractureTip> nextGenTips = new ArrayList<FractureTip>();
            for (FractureTip tip : activeTips) {
                float rndR;
                float lenRight;
                float rndL;
                float baseLength = (float)((double)startLength * Math.pow(lengthDecay, tip.generation));
                float lenLeft = baseLength * (rndL = 0.5f + random.nextFloat() * 1.0f);
                if (lenLeft < 0.8f) {
                    lenLeft = 0.8f;
                }
                if ((lenRight = baseLength * (rndR = 0.5f + random.nextFloat() * 1.0f)) < 0.8f) {
                    lenRight = 0.8f;
                }
                double spreadAngle = Math.toRadians(25.0);
                double chaosL = (random.nextDouble() - 0.5) * Math.toRadians(20.0);
                double chaosR = (random.nextDouble() - 0.5) * Math.toRadians(20.0);
                double leftAngle = tip.angle - spreadAngle + chaosL;
                double rightAngle = tip.angle + spreadAngle + chaosR;
                ParticleUtils.tryGrowBranch(center, tip.pos, leftAngle, lenLeft, tip.generation, allPoints, nextGenTips, maxRadius, maxTime, particleDensity, collisionRadius);
                ParticleUtils.tryGrowBranch(center, tip.pos, rightAngle, lenRight, tip.generation, allPoints, nextGenTips, maxRadius, maxTime, particleDensity, collisionRadius);
            }
            activeTips = nextGenTips;
            if (!activeTips.isEmpty()) continue;
            growing = false;
        }
        return allPoints;
    }

    private static void tryGrowBranch(Vec3 center, Vec3 startPos, double angle, float length, int generation, List<CrackPoint> listPoints, List<FractureTip> nextGenTips, float maxRadius, int maxTime, float particleDensity, float radius) {
        double endZ;
        double endX = startPos.f_82479_ + Math.cos(angle) * (double)length;
        Vec3 endPos = new Vec3(endX, startPos.f_82480_, endZ = startPos.f_82481_ + Math.sin(angle) * (double)length);
        if (endPos.m_82557_(center) > (double)(maxRadius * maxRadius)) {
            return;
        }
        double ignoreParentRadiusSq = length * 0.5f * (length * 0.5f);
        for (CrackPoint p : listPoints) {
            if (p.pos.m_82557_(startPos) < ignoreParentRadiusSq || !(p.pos.m_82557_(endPos) < (double)(radius * radius))) continue;
            return;
        }
        int pCount = (int)(length * particleDensity);
        if (pCount < 1) {
            pCount = 1;
        }
        for (int i = 1; i <= pCount; ++i) {
            float t = (float)i / (float)pCount;
            double pX = startPos.f_82479_ + (endPos.f_82479_ - startPos.f_82479_) * (double)t;
            double pZ = startPos.f_82481_ + (endPos.f_82481_ - startPos.f_82481_) * (double)t;
            int spawnTime = (int)(((float)generation + t) * ((float)maxTime / 6.0f));
            float width = Math.max(0.15f, 1.2f - (float)generation * 0.2f);
            listPoints.add(new CrackPoint(new Vec3(pX, startPos.f_82480_, pZ), spawnTime, width));
        }
        nextGenTips.add(new FractureTip(endPos, angle, generation + 1));
    }

    public static void renderCrackSystem(Level level, List<CrackPoint> points, Color color, int currentTick, int liftOffTick) {
        Random random = RandomUtils.random();
        if (currentTick < liftOffTick) {
            for (CrackPoint p : points) {
                boolean isNew;
                if (currentTick < p.spawnTime) continue;
                float baseSize = 0.12f * p.width;
                if (baseSize < 0.15f) {
                    baseSize = 0.15f;
                }
                ParticleUtils.createParticle(level, new GlowingParticleData(color, baseSize, 4, 0.0f), p.pos.f_82479_, p.pos.f_82480_ + 0.07, p.pos.f_82481_, 0, 0.0, 0.0, 0.0);
                if (p.width > 0.5f && random.nextFloat() < 0.15f) {
                    ParticleUtils.createParticle(level, new GlowingParticleData(color, baseSize * 1.2f, 2, 0.0f), p.pos.f_82479_, p.pos.f_82480_ + 0.07, p.pos.f_82481_, 0, 0.0, 0.0, 0.0);
                }
                if (!(isNew = currentTick == p.spawnTime) || !(p.width > 0.3f) || !(random.nextFloat() < 0.5f)) continue;
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(BlockPos.m_274446_((Position)p.pos).m_7495_())), p.pos.f_82479_, p.pos.f_82480_ + 0.1, p.pos.f_82481_, (random.nextDouble() - 0.5) * 0.1, 0.1, (random.nextDouble() - 0.5) * 0.1);
            }
        }
    }

    public static void createBentLine(Level level, ParticleOptions particle, Vec3 start, Vec3 end, int tickCount, int maxTime, double density, double bendFactor, int segments, long seed, boolean finish) {
        double progress = Math.min(1.0, (double)tickCount / (double)maxTime);
        List<Vec3> linePoints = ParticleUtils.generateBentLine(start, end, density, bendFactor, segments, seed);
        int pointsToDisplay = (int)((double)linePoints.size() * progress);
        for (int i = 0; i < pointsToDisplay; ++i) {
            Vec3 point = linePoints.get(i);
            if (level.f_46443_) {
                level.m_6493_(particle, true, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0);
                continue;
            }
            Networking.sendToAll(new ParticleSpawnerPacket(particle, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, finish ? -0.2 : 0.0, 0.0));
        }
    }

    private static List<Vec3> generateBentLine(Vec3 start, Vec3 end, double density, double bendFactor, int segments, long seed) {
        int i;
        Random random = new Random(seed);
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3 direction = end.m_82546_(start);
        double totalLength = direction.m_82553_();
        Vec3 normalizedDirection = direction.m_82541_();
        Vec3[] segmentStarts = new Vec3[segments + 1];
        segmentStarts[0] = start;
        segmentStarts[segments] = end;
        for (i = 1; i < segments; ++i) {
            double t = (double)i / (double)segments;
            Vec3 basePoint = start.m_82549_(normalizedDirection.m_82490_(t * totalLength));
            double offsetX = (random.nextDouble() - 0.5) * bendFactor;
            double offsetY = (random.nextDouble() - 0.5) * bendFactor;
            double offsetZ = (random.nextDouble() - 0.5) * bendFactor;
            segmentStarts[i] = basePoint.m_82549_(new Vec3(offsetX, offsetY, offsetZ));
        }
        for (i = 0; i < segments; ++i) {
            Vec3 segmentStart = segmentStarts[i];
            Vec3 segmentEnd = segmentStarts[i + 1];
            Vec3 segmentDirection = segmentEnd.m_82546_(segmentStart);
            double segmentLength = segmentDirection.m_82553_();
            Vec3 segmentNormalizedDirection = segmentDirection.m_82541_();
            int segmentPoints = (int)(segmentLength * density);
            for (int j = 0; j < segmentPoints; ++j) {
                double t = (double)j / (double)segmentPoints;
                Vec3 point = segmentStart.m_82549_(segmentNormalizedDirection.m_82490_(t * segmentLength));
                points.add(point);
            }
        }
        points.add(end);
        return points;
    }

    public static void drawChargingRing(Level level, LivingEntity entity, float progress, int tickCount, Color color) {
        if (!level.f_46443_) {
            return;
        }
        Vec3 center = entity.m_20182_().m_82520_(0.0, 0.6, 0.0);
        double radius = 1.8 - (double)progress * 0.8;
        double rotationSpeed = (float)tickCount * (5.0f + progress * 10.0f);
        int points = 12;
        for (int i = 0; i < points; ++i) {
            double angle = Math.toRadians(rotationSpeed + 360.0 / (double)points * (double)i);
            double x = center.f_82479_ + Math.cos(angle) * radius;
            double z = center.f_82481_ + Math.sin(angle) * radius;
            double y = center.f_82480_ + Math.sin(Math.toRadians(tickCount * 5 + i * 10)) * 0.1;
            float scale = 0.3f + progress * 0.3f;
            level.m_7106_((ParticleOptions)new GlowingParticleData(color, scale, 4, 0.0f), x, y, z, 0.0, 0.0, 0.0);
            if (!(progress > 0.5f) || i % 2 != 0) continue;
            level.m_7106_((ParticleOptions)new GlowingParticleData(color, scale * 0.5f, 5, 0.0f), x, y + 0.1, z, 0.0, 0.05, 0.0);
        }
    }

    public static void drawHandFocusEnergy(Level level, Player player, float progress, int tickCount, Color color) {
        if (!level.f_46443_) {
            return;
        }
        Vec3 eyePos = player.m_146892_();
        Vec3 lookDir = player.m_20154_();
        Vec3 rightDir = lookDir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 upDir = rightDir.m_82537_(lookDir).m_82541_();
        Vec3 focusPos = eyePos.m_82549_(lookDir.m_82490_(0.8)).m_82549_(rightDir.m_82490_(0.25)).m_82520_(0.0, -0.1, 0.0);
        if (tickCount % 2 == 0) {
            Vec3 diag1 = rightDir.m_82549_(upDir).m_82541_();
            Vec3 diag2 = rightDir.m_82546_(upDir).m_82541_();
            float particleSize = 0.15f + progress * 0.1f;
            level.m_7106_((ParticleOptions)new GlowingParticleData(color, particleSize + 0.05f, 2, 0.0f, false), focusPos.f_82479_, focusPos.f_82480_, focusPos.f_82481_, 0.0, 0.0, 0.0);
            int stage = 0;
            if (progress > 0.3f) {
                stage = 1;
            }
            if (progress > 0.6f) {
                stage = 2;
            }
            for (int i = 1; i <= stage; ++i) {
                double dist = i == 1 ? (double)i * 0.1 : (double)i * 0.08;
                float size = i == 1 ? particleSize * 0.75f : particleSize * 0.55f;
                Vec3 p1 = focusPos.m_82549_(diag1.m_82490_(dist));
                Vec3 p2 = focusPos.m_82549_(diag1.m_82490_(-dist));
                Vec3 p3 = focusPos.m_82549_(diag2.m_82490_(dist));
                Vec3 p4 = focusPos.m_82549_(diag2.m_82490_(-dist));
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, size, 2, 0.0f, false), p1.f_82479_, p1.f_82480_, p1.f_82481_, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, size, 2, 0.0f, false), p2.f_82479_, p2.f_82480_, p2.f_82481_, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, size, 2, 0.0f, false), p3.f_82479_, p3.f_82480_, p3.f_82481_, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, size, 2, 0.0f, false), p4.f_82479_, p4.f_82480_, p4.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        int suckParticles = 2 + (int)(progress * 4.0f);
        for (int i = 0; i < suckParticles; ++i) {
            double r = 0.5 + level.f_46441_.m_188500_() * 0.5;
            double theta = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double phi = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double x = focusPos.f_82479_ + r * Math.sin(phi) * Math.cos(theta);
            double y = focusPos.f_82480_ + r * Math.sin(phi) * Math.sin(theta);
            double z = focusPos.f_82481_ + r * Math.cos(phi);
            Vec3 motion = focusPos.m_82492_(x, y, z).m_82541_().m_82490_(0.15);
            level.m_7106_((ParticleOptions)new GlowingParticleData(color, 0.25f, 2, 0.0f), x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
        if (progress > 0.8f) {
            double circleRadius = 0.4;
            int circlePoints = 6;
            double rot = (double)tickCount * 0.2;
            for (int i = 0; i < circlePoints; ++i) {
                double angle = rot + Math.PI * 2 * (double)i / (double)circlePoints;
                double cx = focusPos.f_82479_ + Math.cos(angle) * circleRadius;
                double cz = focusPos.f_82481_ + Math.sin(angle) * circleRadius;
                level.m_7106_((ParticleOptions)new GlowingParticleData(color, 0.2f, 2, 0.0f), cx, focusPos.f_82480_, cz, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class LineData
    implements INBTSerializable<CompoundTag> {
        @AutoSerialize
        public int tickCount;
        @AutoSerialize
        public int seed;
        @AutoSerialize
        public float randomOffsetX;
        @AutoSerialize
        public float randomOffsetY;
        @AutoSerialize
        public float randomOffsetZ;

        public LineData(int initialTickOffset) {
            this.tickCount = initialTickOffset;
            this.seed = 0;
        }

        public CompoundTag serializeNBT() {
            return NbtUtils.serialize(this);
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            NbtUtils.deserialize(this, compoundTag);
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public int getSeed() {
            return this.seed;
        }

        public float getRandomOffsetX() {
            return this.randomOffsetX;
        }

        public float getRandomOffsetY() {
            return this.randomOffsetY;
        }

        public float getRandomOffsetZ() {
            return this.randomOffsetZ;
        }

        public void setTickCount(int tickCount) {
            this.tickCount = tickCount;
        }

        public void setSeed(int seed) {
            this.seed = seed;
        }

        public void setRandomOffsetX(float randomOffsetX) {
            this.randomOffsetX = randomOffsetX;
        }

        public void setRandomOffsetY(float randomOffsetY) {
            this.randomOffsetY = randomOffsetY;
        }

        public void setRandomOffsetZ(float randomOffsetZ) {
            this.randomOffsetZ = randomOffsetZ;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineData)) {
                return false;
            }
            LineData other = (LineData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTickCount() != other.getTickCount()) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            if (Float.compare(this.getRandomOffsetX(), other.getRandomOffsetX()) != 0) {
                return false;
            }
            if (Float.compare(this.getRandomOffsetY(), other.getRandomOffsetY()) != 0) {
                return false;
            }
            return Float.compare(this.getRandomOffsetZ(), other.getRandomOffsetZ()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof LineData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTickCount();
            result = result * 59 + this.getSeed();
            result = result * 59 + Float.floatToIntBits(this.getRandomOffsetX());
            result = result * 59 + Float.floatToIntBits(this.getRandomOffsetY());
            result = result * 59 + Float.floatToIntBits(this.getRandomOffsetZ());
            return result;
        }

        public String toString() {
            return "ParticleUtils.LineData(tickCount=" + this.getTickCount() + ", seed=" + this.getSeed() + ", randomOffsetX=" + this.getRandomOffsetX() + ", randomOffsetY=" + this.getRandomOffsetY() + ", randomOffsetZ=" + this.getRandomOffsetZ() + ")";
        }
    }

    public static class CrackPoint {
        public Vec3 pos;
        public int spawnTime;
        public float width;

        public CrackPoint(Vec3 pos, int spawnTime, float width) {
            this.pos = pos;
            this.spawnTime = spawnTime;
            this.width = width;
        }

        public Vec3 getPos() {
            return this.pos;
        }

        public int getSpawnTime() {
            return this.spawnTime;
        }

        public float getWidth() {
            return this.width;
        }

        public void setPos(Vec3 pos) {
            this.pos = pos;
        }

        public void setSpawnTime(int spawnTime) {
            this.spawnTime = spawnTime;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CrackPoint)) {
                return false;
            }
            CrackPoint other = (CrackPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSpawnTime() != other.getSpawnTime()) {
                return false;
            }
            if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
                return false;
            }
            Vec3 this$pos = this.getPos();
            Vec3 other$pos = other.getPos();
            return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CrackPoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSpawnTime();
            result = result * 59 + Float.floatToIntBits(this.getWidth());
            Vec3 $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            return result;
        }

        public String toString() {
            return "ParticleUtils.CrackPoint(pos=" + String.valueOf(this.getPos()) + ", spawnTime=" + this.getSpawnTime() + ", width=" + this.getWidth() + ")";
        }
    }

    private static class FractureTip {
        Vec3 pos;
        double angle;
        int generation;

        public FractureTip(Vec3 pos, double angle, int generation) {
            this.pos = pos;
            this.angle = angle;
            this.generation = generation;
        }

        public Vec3 getPos() {
            return this.pos;
        }

        public double getAngle() {
            return this.angle;
        }

        public int getGeneration() {
            return this.generation;
        }

        public void setPos(Vec3 pos) {
            this.pos = pos;
        }

        public void setAngle(double angle) {
            this.angle = angle;
        }

        public void setGeneration(int generation) {
            this.generation = generation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FractureTip)) {
                return false;
            }
            FractureTip other = (FractureTip)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getAngle(), other.getAngle()) != 0) {
                return false;
            }
            if (this.getGeneration() != other.getGeneration()) {
                return false;
            }
            Vec3 this$pos = this.getPos();
            Vec3 other$pos = other.getPos();
            return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FractureTip;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $angle = Double.doubleToLongBits(this.getAngle());
            result = result * 59 + (int)($angle >>> 32 ^ $angle);
            result = result * 59 + this.getGeneration();
            Vec3 $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            return result;
        }

        public String toString() {
            return "ParticleUtils.FractureTip(pos=" + String.valueOf(this.getPos()) + ", angle=" + this.getAngle() + ", generation=" + this.getGeneration() + ")";
        }
    }
}

