/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static boolean onHand(Player player, Item item) {
        return player.m_21205_().m_41720_().m_5456_().equals(item) || player.m_21206_().m_41720_().equals(item);
    }

    public static boolean onHand(Player player, Predicate<Item> condition) {
        Item mainHand = player.m_21205_().m_41720_();
        Item offHand = player.m_21206_().m_41720_();
        return condition.test(mainHand) || condition.test(offHand);
    }

    @Nullable
    public static InteractionHand getHandWithItem(ServerPlayer player, Item item) {
        if (player.m_21205_().m_41720_().equals(item)) {
            return InteractionHand.MAIN_HAND;
        }
        if (player.m_21206_().m_41720_().equals(item)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static String getItemIdFromStack(ItemStack stack) {
        Item item = stack.m_41720_();
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        if (registryName != null) {
            return registryName.toString();
        }
        return "minecraft:grass_block";
    }

    public static void replaceItemInInventory(Inventory inventory, ItemStack original, ItemStack replacement) {
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)original)) continue;
            inventory.m_6836_(i, replacement);
            break;
        }
    }

    public static void replaceItemInInventory(Inventory inventory, int slot, ItemStack replacement) {
        inventory.m_6836_(slot, replacement);
    }

    public static void removeItemsFromInventory(Inventory inventory, ItemStack targetItemStack, int amount) {
        int remainingAmount = amount;
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            ItemStack stackInSlot = (ItemStack)inventory.f_35974_.get(i);
            if (!ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)targetItemStack)) continue;
            int stackCount = stackInSlot.m_41613_();
            if (stackCount <= remainingAmount) {
                inventory.f_35974_.set(i, (Object)ItemStack.f_41583_);
                remainingAmount -= stackCount;
            } else {
                stackInSlot.m_41774_(remainingAmount);
                remainingAmount = 0;
            }
            if (remainingAmount <= 0) break;
        }
    }

    public static void removeItemsFromInventory(Inventory inventory, ItemStack targetItemStack) {
        int remainingAmount = targetItemStack.m_41613_();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            ItemStack stackInSlot = (ItemStack)inventory.f_35974_.get(i);
            if (!ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)targetItemStack)) continue;
            int stackCount = stackInSlot.m_41613_();
            if (stackCount <= remainingAmount) {
                inventory.f_35974_.set(i, (Object)ItemStack.f_41583_);
                remainingAmount -= stackCount;
            } else {
                stackInSlot.m_41774_(remainingAmount);
                remainingAmount = 0;
            }
            if (remainingAmount <= 0) break;
        }
    }

    public static String convertItemString(String itemString) {
        String[] parts = itemString.split("\\.");
        if (parts.length != 3) {
            return "";
        }
        String modId = parts[1];
        String itemId = parts[2];
        return modId + ":" + itemId;
    }

    public static ItemStack findItemInInventory(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack findItemByClass(Player player, Class<?> itemClass) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !itemClass.isInstance(stack.m_41720_())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static String serialize(Ingredient ingredient) {
        if (ingredient == null || ingredient.m_43947_()) {
            return "";
        }
        JsonElement json = ingredient.m_43942_();
        return json.toString();
    }

    public static Ingredient deserialize(String json) {
        if (json == null || json.isEmpty()) {
            return Ingredient.f_43901_;
        }
        try {
            JsonElement element = JsonParser.parseString((String)json);
            return Ingredient.m_43917_((JsonElement)element);
        }
        catch (JsonSyntaxException e) {
            return Ingredient.f_43901_;
        }
    }

    @NotNull
    public static Item byIdString(String id) {
        if (id == null || id.isEmpty()) {
            return ItemStack.f_41583_.m_41720_();
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        return item == null ? Items.f_41852_ : item;
    }

    public static String getIdString(Item stack) {
        if (stack == null) {
            return "minecraft:air";
        }
        ResourceLocation item = ForgeRegistries.ITEMS.getKey((Object)stack);
        return item == null ? "minecraft:air" : item.toString();
    }
}

