/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.utils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityUtils {
    public static <T extends Entity> List<T> findEntitiesByClass(Level world, Class<T> entityClass, Vec3 center, double radius) {
        AABB boundingBox = new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius);
        return world.m_45976_(entityClass, boundingBox);
    }

    public static void resetAttribute(LivingEntity entity, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22120_(uuid);
        if (value != 0.0) {
            instance.m_22118_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    public static void removeAttribute(LivingEntity entity, Attribute attribute, String name) {
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22120_(uuid);
    }
}

