/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import com.mojang.datafixers.util.Pair;
import it.mralxart.etheria.blocks.BeamEmitter;
import it.mralxart.etheria.blocks.BeamRefractor;
import it.mralxart.etheria.blocks.TrialBlock;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.events.TrialGiveRewardEvent;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.trial.TrialInfo;
import it.mralxart.etheria.magic.trial.TrialState;
import it.mralxart.etheria.magic.trial.TrialType;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.SyncTilePacket;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.BeamEmitterTile;
import it.mralxart.etheria.tiles.BeamRefractorTile;
import it.mralxart.etheria.utils.BlockUtils;
import it.mralxart.etheria.utils.ItemUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrialTile
extends BlockEntity
implements IAnimatedTile,
TrialBlock.StateAccessor {
    public final AnimationController controller = new AnimationController(this);
    public EntityType<?> entityType;
    private int difficultyLevel = 0;
    private boolean gived = false;
    private boolean pressed = false;
    public long cooldownEndTime;
    public int allSpawnedMobs = 0;
    public final List<UUID> spawnedEntities = Collections.synchronizedList(new ArrayList());
    public final List<UUID> detectedPlayers = Collections.synchronizedList(new ArrayList());
    public TrialInfo config;
    public long nextMobSpawnsAt = 0L;
    public long cooldownToEjection = 0L;
    public String currentWaveId = "";
    public List<String> spawnData = new ArrayList<String>();
    public List<String> nextSpawnData = new ArrayList<String>();
    public int radius = 4;
    private List<BlockPos> refractorCache = new ArrayList<BlockPos>();
    private List<BlockPos> emitterCache = new ArrayList<BlockPos>();
    private Pair<BlockPos, Integer> beamTargetCache = null;
    private int cacheRefreshCooldown = 0;
    private int tickCount = 0;
    private String id = "tests";
    private Direction direction = Direction.NORTH;
    public TrialType trialType = TrialType.MOBS;

    public TrialTile(BlockEntityType<TrialTile> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrialTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.TRIAL.get(), pos, state);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        this.id = tag.m_128461_("id_trial");
        this.currentWaveId = tag.m_128461_("currentWaveId");
        this.gived = tag.m_128471_("gived");
        this.pressed = tag.m_128471_("pressed");
        this.difficultyLevel = tag.m_128451_("DifficultyLevel");
        this.tickCount = tag.m_128451_("tickCount");
        this.radius = tag.m_128451_("radius");
        this.allSpawnedMobs = tag.m_128451_("allSpawnedMobs");
        this.cooldownEndTime = tag.m_128454_("CooldownEndTime");
        this.entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(tag.m_128461_("entity")));
        if (!tag.m_128461_("direction").isEmpty()) {
            this.direction = Direction.valueOf((String)tag.m_128461_("direction").toUpperCase());
        }
        if (!tag.m_128461_("trialType").isEmpty()) {
            this.trialType = TrialType.valueOf(tag.m_128461_("trialType").toUpperCase());
        }
        ListTag spawnData = tag.m_128437_("spawnData", 11);
        this.spawnData.clear();
        for (int i2 = 0; i2 < spawnData.size(); ++i2) {
            this.spawnData.add(String.valueOf(spawnData.get(i2)));
        }
        ListTag uuidList = tag.m_128437_("SpawnedEntities", 11);
        this.spawnedEntities.clear();
        for (i = 0; i < uuidList.size(); ++i) {
            this.spawnedEntities.add(UUID.fromString(uuidList.m_128778_(i)));
        }
        uuidList = tag.m_128437_("detectedPlayers", 11);
        this.detectedPlayers.clear();
        for (i = 0; i < uuidList.size(); ++i) {
            this.detectedPlayers.add(UUID.fromString(uuidList.m_128778_(i)));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("id_trial", this.id);
        tag.m_128359_("currentWaveId", this.currentWaveId);
        tag.m_128379_("gived", this.gived);
        tag.m_128379_("pressed", this.pressed);
        tag.m_128405_("DifficultyLevel", this.difficultyLevel);
        tag.m_128405_("tickCount", this.tickCount);
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("allSpawnedMobs", this.allSpawnedMobs);
        tag.m_128356_("CooldownEndTime", this.cooldownEndTime);
        tag.m_128359_("entity", BuiltInRegistries.f_256780_.m_7981_(this.entityType).toString());
        tag.m_128359_("direction", this.direction.name().toLowerCase());
        tag.m_128359_("trialType", this.trialType.name().toLowerCase());
        ListTag uuidList = new ListTag();
        for (UUID uuid : this.spawnedEntities) {
            uuidList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        tag.m_128365_("SpawnedEntities", (Tag)uuidList);
        uuidList = new ListTag();
        for (UUID uuid : this.detectedPlayers) {
            uuidList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        tag.m_128365_("detectedPlayers", (Tag)uuidList);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public void setEntityType(EntityType<?> entityType) {
        this.entityType = entityType;
        this.m_6596_();
    }

    public void resetCooldown(ServerLevel level, int cooldown) {
        this.cooldownEndTime = level.m_46467_() + (long)cooldown;
        this.m_6596_();
    }

    public boolean isCooldownFinished(ServerLevel level) {
        return level.m_46467_() >= this.cooldownEndTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<UUID> spawnMobs(ServerLevel level, List<String> spawnData, BlockPos pos, int iPlayer) {
        ArrayList<Vec3> spawnPoints = new ArrayList<Vec3>();
        spawnPoints.add(new Vec3((double)(pos.m_123341_() + 2), (double)pos.m_123342_(), (double)pos.m_123343_()));
        spawnPoints.add(new Vec3((double)(pos.m_123341_() - 2), (double)pos.m_123342_(), (double)pos.m_123343_()));
        spawnPoints.add(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)(pos.m_123343_() + 2)));
        spawnPoints.add(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)(pos.m_123343_() - 2)));
        if (spawnData.isEmpty()) {
            return Optional.empty();
        }
        Random random = new Random();
        for (String mobId : spawnData) {
            Entity entity;
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobId));
            if (entityType == null || !((entity = entityType.m_20615_((Level)level)) instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            Vec3 center = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            Vec3 offset = this.getRandomOffset(1.0);
            Vec3 spawnPoint = center.m_82549_(offset);
            double x = spawnPoint.f_82479_;
            double y = spawnPoint.f_82480_ + 0.2;
            double z = spawnPoint.f_82481_;
            ItemStack helmet = ItemStack.f_41583_;
            ItemStack chestplate = ItemStack.f_41583_;
            ItemStack leggings = ItemStack.f_41583_;
            ItemStack boots = ItemStack.f_41583_;
            if (iPlayer > 2) {
                helmet = new ItemStack((ItemLike)Items.f_42472_);
                chestplate = new ItemStack((ItemLike)Items.f_42473_);
                leggings = new ItemStack((ItemLike)Items.f_42474_);
                boots = new ItemStack((ItemLike)Items.f_42475_);
            } else if (iPlayer > 0) {
                helmet = new ItemStack((ItemLike)Items.f_42468_);
                chestplate = new ItemStack((ItemLike)Items.f_42469_);
                leggings = new ItemStack((ItemLike)Items.f_42470_);
                boots = new ItemStack((ItemLike)Items.f_42471_);
            } else {
                helmet = new ItemStack((ItemLike)Items.f_42464_);
                chestplate = new ItemStack((ItemLike)Items.f_42465_);
                leggings = new ItemStack((ItemLike)Items.f_42466_);
                boots = new ItemStack((ItemLike)Items.f_42467_);
            }
            if (random.nextDouble() < 0.3 + (double)iPlayer * 0.1) {
                switch (random.nextInt(4)) {
                    case 0: {
                        this.applyArmorTrim(level.m_9598_(), helmet, random);
                        mob.m_8061_(EquipmentSlot.HEAD, helmet);
                        break;
                    }
                    case 1: {
                        this.applyArmorTrim(level.m_9598_(), chestplate, random);
                        mob.m_8061_(EquipmentSlot.CHEST, chestplate);
                        break;
                    }
                    case 2: {
                        this.applyArmorTrim(level.m_9598_(), leggings, random);
                        mob.m_8061_(EquipmentSlot.LEGS, leggings);
                        break;
                    }
                    case 3: {
                        this.applyArmorTrim(level.m_9598_(), boots, random);
                        mob.m_8061_(EquipmentSlot.FEET, boots);
                    }
                }
            }
            if (mob instanceof Skeleton && random.nextDouble() < 0.5) {
                mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            }
            if (random.nextDouble() < 0.15 + (double)iPlayer * 0.1) {
                ItemStack weapon = ItemStack.f_41583_;
                weapon = iPlayer >= 3 ? new ItemStack((ItemLike)Items.f_42388_) : (iPlayer == 2 ? new ItemStack((ItemLike)Items.f_42383_) : (iPlayer == 1 ? new ItemStack((ItemLike)Items.f_42425_) : new ItemStack((ItemLike)Items.f_42420_)));
                mob.m_8061_(EquipmentSlot.MAINHAND, weapon);
            }
            for (ItemStack slot : EquipmentSlot.values()) {
                ItemStack item = mob.m_6844_((EquipmentSlot)slot);
                if (item.m_41619_()) continue;
                mob.m_21409_((EquipmentSlot)slot, 0.0f);
            }
            if (random.nextDouble() < 0.3) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600));
            }
            if (random.nextDouble() < 0.2) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600));
            }
            if (random.nextDouble() < 0.1 + (double)iPlayer * 0.1) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 1, false, true));
            } else if (random.nextDouble() < 0.1) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 1, false, true));
            }
            AttributeInstance maxHealthAttr = mob.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr != null) {
                double baseHealth = maxHealthAttr.m_22115_();
                int difficultyLevel = this.getDifficultyLevel();
                double totalHealth = baseHealth + 10.0 * (double)(difficultyLevel - 1);
                maxHealthAttr.m_22100_(totalHealth);
                mob.m_21153_((float)totalHealth);
            }
            if (iPlayer <= 3) {
                if (random.nextDouble() < 0.3) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600));
                }
                if (random.nextDouble() < 0.2) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600));
                }
                if (random.nextDouble() < 0.1) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300));
                }
            }
            if (iPlayer >= 4) {
                if (random.nextDouble() < 0.4) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600));
                }
                if (random.nextDouble() < 0.2) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600));
                }
            }
            if (iPlayer >= 7) {
                if (random.nextDouble() < 0.2) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400));
                }
                if (random.nextDouble() < 0.2) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400));
                }
            }
            if (iPlayer >= 10) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200));
                if (random.nextDouble() < 0.4) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
                }
                if (random.nextDouble() < 0.3) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 1));
                }
            }
            if (iPlayer >= 13) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 600, 1));
                mob.getPersistentData().m_128379_("ignoreArmorChance", true);
            }
            if (iPlayer >= 15 && random.nextDouble() < 0.4) {
                mob.getPersistentData().m_128379_("hasPiercingDamage", true);
            }
            mob.m_7678_(x, y, z, level.f_46441_.m_188501_() * 360.0f, 0.0f);
            List<UUID> list = this.spawnedEntities;
            synchronized (list) {
                level.m_7967_((Entity)mob);
                this.spawnedEntities.add(mob.m_20148_());
            }
            ParticleUtils.createParticle((Level)level, (ParticleOptions)ParticleTypes.f_123777_, x, y, z, 50, 0.0, 0.0, 0.0, 0.02);
            ParticleUtils.createParticle((Level)level, (ParticleOptions)ParticleTypes.f_123744_, x, y, z, 50, 0.0, 0.0, 0.0, 0.02);
            for (UUID player : this.detectedPlayers) {
                Entity entity2;
                if (level.m_8791_(player) == null || !((entity2 = level.m_8791_(player)) instanceof Player)) continue;
                Player player1 = (Player)entity2;
                ParticleUtils.createParticle((Level)level, new GlowingParticleData(ElementsUtils.getColorByElement(ElementsUtils.getElement(player1)), 0.3f, 30, 0.01f), x, y, z, 15, 0.0, 0.0, 0.0, 0.02);
            }
            this.pressed = true;
            spawnData.remove(mobId);
            this.setEntityType(mob.m_6095_());
            return Optional.of(mob.m_20148_());
        }
        return Optional.empty();
    }

    private void applyArmorTrim(RegistryAccess registryAccess, ItemStack armor, Random random) {
        List<Holder<TrimMaterial>> trimMaterials = this.getTrimMaterials(registryAccess);
        List<Holder<TrimPattern>> trimPatterns = this.getTrimPatterns(registryAccess);
        Holder<TrimMaterial> material = trimMaterials.get(random.nextInt(trimMaterials.size()));
        Holder<TrimPattern> pattern = trimPatterns.get(random.nextInt(trimPatterns.size()));
        ArmorTrim trim = new ArmorTrim(material, pattern);
        ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)armor, (ArmorTrim)trim);
    }

    private List<Holder<TrimMaterial>> getTrimMaterials(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registries.f_266076_).m_203611_().collect(Collectors.toList());
    }

    private List<Holder<TrimPattern>> getTrimPatterns(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registries.f_266063_).m_203611_().collect(Collectors.toList());
    }

    private Vec3 getRandomOffset(double radius) {
        double angle = new Random().nextDouble() * 2.0 * Math.PI;
        double x = radius * Math.cos(angle);
        double z = radius * Math.sin(angle);
        return new Vec3(x, 0.0, z);
    }

    public void giveReward(ServerLevel serverLevel, TrialInfo trialInfo, BlockPos pos) {
        String reward;
        String[] parts;
        RandomSource random = serverLevel.m_213780_();
        if (trialInfo == null) {
            return;
        }
        if (trialInfo.getRewards() == null) {
            return;
        }
        TrialGiveRewardEvent event = new TrialGiveRewardEvent(serverLevel, trialInfo, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        Item item = null;
        int itemCount = 1;
        ArrayList<TrialInfo.TrialInfoBuilder.LootData> rewardsList = new ArrayList<TrialInfo.TrialInfoBuilder.LootData>(trialInfo.getRewards().values());
        BlockState block = serverLevel.m_8055_(pos.m_7495_());
        if (block.m_60734_().equals(Blocks.f_50354_)) {
            id = ItemUtils.convertItemString(((Item)ItemRegistry.FROSTBOUND_WISH.get()).m_5524_()) + ":2";
            rewardsList.add(TrialInfo.TrialInfoBuilder.LootData.builder().chance(0.5f).rewards(List.of(id)).build());
        } else if (block.m_60734_().equals(Blocks.f_50062_)) {
            id = ItemUtils.convertItemString(((Item)ItemRegistry.BLAZING_WISH.get()).m_5524_()) + ":2";
            rewardsList.add(TrialInfo.TrialInfoBuilder.LootData.builder().chance(0.5f).rewards(List.of(id)).build());
        }
        ArrayList<String> possibleRewards = new ArrayList<String>();
        for (TrialInfo.TrialInfoBuilder.LootData rewards : rewardsList) {
            for (String reward2 : rewards.getRewards()) {
                if (!(random.m_188501_() <= rewards.getChance())) continue;
                possibleRewards.add(reward2);
            }
        }
        if (!possibleRewards.isEmpty() && (parts = (reward = (String)possibleRewards.get(random.m_188503_(possibleRewards.size()))).split(":")).length >= 2) {
            String itemResource = parts[0] + ":" + parts[1];
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemResource));
            if (parts.length == 3) {
                try {
                    itemCount = Math.max(1, Integer.parseInt(parts[2]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (item != null) {
            int finalCount = itemCount;
            DefaultDispenseItemBehavior.m_123378_((Level)serverLevel, (ItemStack)new ItemStack(item, finalCount), (int)2, (Direction)Direction.UP, (Position)pos.m_252807_().m_82520_(0.0, 0.7, 0.0));
            ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.ETHER), 0.3f, 30, 0.025f), (Level)serverLevel, pos.m_252807_().m_82520_(0.0, 0.5, 0.0), pos.m_252807_().m_82520_(0.0, 0.5, 0.0).m_231075_(Direction.UP, 1.2), 40, 0.05f);
        }
    }

    public void reset() {
        this.allSpawnedMobs = 0;
        this.pressed = false;
    }

    public void updateAnimations(ServerLevel serverLevel, TrialState state) {
        boolean bl;
        boolean bl2 = bl = (this.m_58899_().m_121878_() + serverLevel.m_46467_()) % 20L != 0L;
        if (bl) {
            if (state == null) {
                return;
            }
            AnimationSet animationSet = AnimationStorage.getAnimationSet(new ResourceLocation("etheria", "animations/trial.animation.json"));
            if (animationSet == null) {
                return;
            }
            switch (state) {
                case INACTIVE: {
                    this.getController().stopAnimation("cooldown");
                    this.getController().startAnimation("inactive", animationSet.get("animation.trial.inactive"), LoopMode.LOOP);
                    break;
                }
                case WAITING_FOR_PLAYERS: {
                    this.getController().stopAnimation("cooldown");
                    this.getController().stopAnimation("inactive");
                    this.getController().startAnimation("waiting", animationSet.get("animation.trial.waiting_player"), LoopMode.LOOP);
                    break;
                }
                case ACTIVE: {
                    this.getController().stopAnimation("waiting");
                    this.getController().stopAnimation("inactive");
                    this.getController().startAnimation("active", animationSet.get("animation.trial.active"), LoopMode.LOOP);
                    break;
                }
                case WAITING_FOR_REWARD_EJECTION: {
                    this.getController().stopAnimation("waiting");
                    this.getController().stopAnimation("active");
                    this.getController().startAnimation("waiting_reward", animationSet.get("animation.trial.waiting_reward"), LoopMode.LOOP);
                    break;
                }
                case EJECTING_REWARD: {
                    this.getController().stopAnimation("waiting_reward");
                    this.getController().stopAnimation("waiting");
                    this.getController().startAnimation("reward", animationSet.get("animation.trial.reward"), LoopMode.LOOP);
                    break;
                }
                case COOLDOWN: {
                    this.getController().stopAnimation("waiting");
                    this.getController().stopAnimation("reward");
                    this.getController().startAnimation("cooldown", animationSet.get("animation.trial.inactive"), LoopMode.LOOP);
                }
            }
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T block) {
        if (block instanceof TrialTile) {
            TrialTile blockEntity = (TrialTile)block;
            blockEntity.getController().tick();
            ++blockEntity.tickCount;
            if (blockEntity.trialType.equals((Object)TrialType.MOBS)) {
                if (!level.m_5776_()) {
                    TrialState trialSpawnerState = blockEntity.getState();
                    if (blockEntity.spawnedEntities.removeIf(uUID -> TrialTile.shouldMobBeUntracked((ServerLevel)level, pos, uUID))) {
                        blockEntity.nextMobSpawnsAt = level.m_46467_() + 40L;
                    }
                    TrialState trialSpawnerState2 = trialSpawnerState.tickAndGetNext((ServerLevel)level, pos, blockEntity);
                    blockEntity.updateAnimations((ServerLevel)level, trialSpawnerState2);
                    if (trialSpawnerState2 != trialSpawnerState) {
                        blockEntity.setState(level, trialSpawnerState2);
                        Networking.sendToAll(new SyncTilePacket(blockEntity, true));
                    }
                }
            } else if (blockEntity.trialType.equals((Object)TrialType.BEAM)) {
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                if (blockEntity.cacheRefreshCooldown > 0) {
                    --blockEntity.cacheRefreshCooldown;
                }
                if (blockEntity.cacheRefreshCooldown <= 0) {
                    blockEntity.refractorCache = BlockUtils.findBlocks(level, pos, blockEntity.radius + 6, BeamRefractor.class);
                    blockEntity.emitterCache = BlockUtils.findBlocks(level, pos, 16, BeamEmitter.class);
                    Direction direction = blockEntity.getDirection();
                    blockEntity.beamTargetCache = TrialTile.findRefractor(level, pos, direction);
                    blockEntity.cacheRefreshCooldown = 100;
                }
                if (!blockEntity.isCooldownFinished(serverLevel)) {
                    return;
                }
                boolean isFinish = false;
                if (blockEntity.tickCount % 10 == 0 && level.m_46749_(pos)) {
                    BlockEntity tile;
                    if (!blockEntity.refractorCache.isEmpty()) {
                        for (BlockPos posBlock : blockEntity.refractorCache) {
                            BlockEntity be;
                            if (!level.m_46749_(posBlock) || !((be = level.m_7702_(posBlock)) instanceof BeamRefractorTile) || (tile = (BeamRefractorTile)be).getEther() <= 0) continue;
                            BlockState blockState = serverLevel.m_8055_(pos.m_7495_());
                            Item item = null;
                            if (blockState.m_60734_().equals(Blocks.f_50354_)) {
                                item = (Item)ItemRegistry.FROSTBOUND_WISH.get();
                            } else if (blockState.m_60734_().equals(Blocks.f_50062_)) {
                                item = (Item)ItemRegistry.BLAZING_WISH.get();
                            } else if (blockState.m_60734_().equals(Blocks.f_50334_)) {
                                item = (Item)ItemRegistry.GALE_WISH.get();
                            }
                            if (item == null) continue;
                            DefaultDispenseItemBehavior.m_123378_((Level)serverLevel, (ItemStack)new ItemStack((ItemLike)item, 2), (int)2, (Direction)Direction.UP, (Position)pos.m_252807_().m_82520_(0.0, 0.7, 0.0));
                            ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.ETHER), 0.3f, 30, 0.025f), (Level)serverLevel, pos.m_252807_().m_82520_(0.0, 0.5, 0.0), pos.m_252807_().m_82520_(0.0, 0.5, 0.0).m_231075_(Direction.UP, 1.2), 40, 0.05f);
                            blockEntity.resetCooldown(serverLevel, 36000);
                            Networking.sendToAll(new SyncTilePacket(blockEntity, true));
                            isFinish = true;
                            break;
                        }
                    }
                    if (isFinish) {
                        if (!blockEntity.emitterCache.isEmpty()) {
                            for (BlockPos posBlock : blockEntity.emitterCache) {
                                tile = level.m_7702_(posBlock);
                                if (!(tile instanceof BeamEmitterTile)) continue;
                                BeamEmitterTile tile2 = (BeamEmitterTile)tile;
                                Direction[] directions = new Direction[]{Direction.NORTH, Direction.WEST, Direction.EAST, Direction.SOUTH};
                                tile2.setDirection(directions[new Random().nextInt(directions.length)]);
                            }
                        }
                        return;
                    }
                    if (!level.f_46443_) {
                        Networking.sendToAll(new SyncTilePacket(blockEntity, true));
                    }
                    Direction direction = blockEntity.getDirection();
                    Pair<BlockPos, Integer> refractorPos = blockEntity.beamTargetCache;
                    Vec3 startPos = pos.m_252807_().m_82520_(0.0, 0.5, 0.0);
                    if (refractorPos != null) {
                        Vec3 endPos = Vec3.m_82512_((Vec3i)((Vec3i)refractorPos.getFirst())).m_82520_(0.0, 0.5, 0.0);
                        BlockEntity blockEntity2 = level.m_7702_((BlockPos)refractorPos.getFirst());
                        if (blockEntity2 instanceof BeamEmitterTile) {
                            BeamEmitterTile tile3 = (BeamEmitterTile)blockEntity2;
                            tile3.setEther(3);
                        }
                        ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 21 * (Integer)refractorPos.getSecond(), 0.25f), level, startPos, endPos, 1, 1.0f);
                    } else {
                        BlockPos checkPos = pos.m_5484_(direction, 3);
                        ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 21, 0.25f), level, startPos, checkPos.m_252807_(), 1, 1.0f);
                    }
                }
            }
        }
    }

    @Nullable
    private static Pair<BlockPos, Integer> findRefractor(Level level, BlockPos startPos, Direction direction) {
        for (int i = 1; i <= 16; ++i) {
            BlockPos checkPos = startPos.m_5484_(direction, i);
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60734_() instanceof BeamRefractor) {
                return Pair.of((Object)checkPos, (Object)i);
            }
            if (!(state.m_60734_() instanceof BeamEmitter)) continue;
            return Pair.of((Object)checkPos, (Object)i);
        }
        return null;
    }

    public static List<Player> getPlayerAround(Level level, BlockPos blockPos, int radius) {
        AABB boundingBox = new AABB(blockPos).m_82400_((double)radius);
        List entitiesClose = level.m_45976_(Entity.class, boundingBox);
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : entitiesClose) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            players.add(player);
        }
        return players;
    }

    public boolean hasMobToSpawn(RandomSource randomSource) {
        return true;
    }

    public void tryDetectPlayers(ServerLevel serverLevel, BlockPos blockPos) {
        List<Player> players = TrialTile.getPlayerAround((Level)serverLevel, blockPos, 12);
        if (!players.isEmpty()) {
            for (Player player : players) {
                if (player.m_7500_() || this.detectedPlayers.contains(player.m_20148_())) continue;
                this.detectedPlayers.add(player.m_20148_());
            }
        }
    }

    public boolean tryDetectPlayers(ServerLevel serverLevel, BlockPos blockPos, int radius) {
        List<Player> players = TrialTile.getPlayerAround((Level)serverLevel, blockPos, radius);
        if (!players.isEmpty()) {
            for (Player player : players) {
                if (player.m_7500_() || this.detectedPlayers.contains(player.m_20148_())) continue;
                this.detectedPlayers.add(player.m_20148_());
            }
        }
        return !this.detectedPlayers.isEmpty();
    }

    public int getDetectPlayers(ServerLevel serverLevel, BlockPos blockPos, int radius) {
        List<Player> players = TrialTile.getPlayerAround((Level)serverLevel, blockPos, radius);
        if (!players.isEmpty()) {
            for (Player player : players) {
                if (this.detectedPlayers.contains(player.m_20148_())) continue;
                this.detectedPlayers.add(player.m_20148_());
            }
        }
        return this.detectedPlayers.size();
    }

    public int countAdditionalPlayers(ServerLevel level, BlockPos blockPos) {
        if (this.detectedPlayers.isEmpty()) {
            // empty if block
        }
        int additional = 0;
        for (UUID uuid : this.detectedPlayers) {
            Player player = level.m_46003_(uuid);
            if (!(player instanceof ServerPlayer) || SkillsUtils.getLvl(player, Branches.COMBAT) <= 25) continue;
            ++additional;
        }
        int count = Math.max(0, this.detectedPlayers.size() - 1) + additional + this.difficultyLevel;
        return count;
    }

    public boolean hasFinishedSpawningAllMobs(TrialInfo info, int i) {
        int totalMobs = this.getAllMobs(info);
        int reqMobs = (int)((double)(totalMobs + 3 * i));
        return this.allSpawnedMobs >= reqMobs;
    }

    public int getAllMobs(TrialInfo info) {
        if (info.getMobs().isEmpty()) {
            return 0;
        }
        int result = 0;
        for (List<String> list : info.getMobs().values()) {
            result += list.size();
        }
        return result;
    }

    public boolean haveAllCurrentMobsDied(ServerLevel level) {
        return this.spawnedEntities.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(ServerLevel serverLevel, int i) {
        return serverLevel.m_46467_() >= this.nextMobSpawnsAt && this.spawnedEntities.size() < this.calculateTargetSimultaneousMobs(i);
    }

    public int calculateTargetSimultaneousMobs(int i) {
        return (int)Math.floor(4.0f + 2.0f * (float)i);
    }

    public boolean canSpawnInLevel(Level level) {
        return level.m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    @Override
    public void setState(Level level, TrialState trialSpawnerState) {
        if (trialSpawnerState == null) {
            return;
        }
        BlockState currentState = level.m_8055_(this.f_58858_);
        level.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_(TrialBlock.TRIAL_SPAWNER_STATE, (Comparable)((Object)trialSpawnerState)), 3);
        this.markUpdated();
    }

    @Override
    public TrialState getState() {
        return !this.m_58900_().m_61138_(TrialBlock.TRIAL_SPAWNER_STATE) ? TrialState.INACTIVE : (TrialState)((Object)this.m_58900_().m_61143_(TrialBlock.TRIAL_SPAWNER_STATE));
    }

    @Override
    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel serverLevel, BlockPos blockPos, UUID uUID) {
        Entity entity = serverLevel.m_8791_(uUID);
        return entity == null || !entity.m_6084_() || !entity.m_9236_().m_46472_().equals((Object)serverLevel.m_46472_()) || entity.m_20183_().m_123331_((Vec3i)blockPos) > (double)Mth.m_144944_((int)47);
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public int getDifficultyLevel() {
        return this.difficultyLevel;
    }

    public boolean isGived() {
        return this.gived;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public long getCooldownEndTime() {
        return this.cooldownEndTime;
    }

    public int getAllSpawnedMobs() {
        return this.allSpawnedMobs;
    }

    public List<UUID> getSpawnedEntities() {
        return this.spawnedEntities;
    }

    public List<UUID> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public TrialInfo getConfig() {
        return this.config;
    }

    public long getNextMobSpawnsAt() {
        return this.nextMobSpawnsAt;
    }

    public long getCooldownToEjection() {
        return this.cooldownToEjection;
    }

    public String getCurrentWaveId() {
        return this.currentWaveId;
    }

    public List<String> getSpawnData() {
        return this.spawnData;
    }

    public List<String> getNextSpawnData() {
        return this.nextSpawnData;
    }

    public int getRadius() {
        return this.radius;
    }

    public List<BlockPos> getRefractorCache() {
        return this.refractorCache;
    }

    public List<BlockPos> getEmitterCache() {
        return this.emitterCache;
    }

    public Pair<BlockPos, Integer> getBeamTargetCache() {
        return this.beamTargetCache;
    }

    public int getCacheRefreshCooldown() {
        return this.cacheRefreshCooldown;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public TrialType getTrialType() {
        return this.trialType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }
}

