/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.blocks.base.IEnigmaBlock;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.data.IEnigmaTile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class EtherPrismTile
extends BlockEntity
implements IEnigmaTile {
    public List<ItemStack> itemStacks = new ArrayList<ItemStack>();
    private float progress = 0.0f;
    private boolean isBlocked = false;
    private boolean isGenerated = false;
    private boolean isEnigma = false;
    public float randomId = new Random().nextInt(1, 60);

    public EtherPrismTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ETHER_PRISM.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherPrismTile) {
            EtherPrismTile tile = (EtherPrismTile)t;
            boolean isEnigma = (Boolean)blockState.m_61143_((Property)IEnigmaBlock.ENIGMA);
            if (level.m_46467_() % 5L == 0L && isEnigma) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(EnigmaUtils.getEnigmaStartColor((int)level.m_46467_()).getRGB(), Math.max(0.1f, level.f_46441_.m_188501_() / 4.0f), 20 + level.f_46441_.m_216339_(3, 30), 0.1f, 1.0f), (float)tile.m_58899_().m_123341_() + level.f_46441_.m_188501_(), (double)tile.m_58899_().m_123342_() + 0.7, (float)tile.m_58899_().m_123343_() + level.f_46441_.m_188501_(), 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.7) / 2.0, 0.0));
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.itemStacks.clear();
        ListTag itemsList = compound.m_128437_("itemStacks", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            this.itemStacks.add(ItemStack.m_41712_((CompoundTag)itemsList.m_128728_(i)));
        }
        this.progress = compound.m_128457_("progress");
        this.isBlocked = compound.m_128471_("isBlocked");
        this.isGenerated = compound.m_128471_("isGenerated");
        this.setEnigma(compound.m_128471_("isEnigma"));
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        ListTag itemsList = new ListTag();
        for (ItemStack itemStack : this.itemStacks) {
            CompoundTag stackTag = new CompoundTag();
            itemStack.m_41739_(stackTag);
            itemsList.add((Object)stackTag);
        }
        compound.m_128365_("itemStacks", (Tag)itemsList);
        compound.m_128350_("progress", this.progress);
        compound.m_128379_("isBlocked", this.isBlocked);
        compound.m_128379_("isGenerated", this.isGenerated);
        compound.m_128379_("isEnigma", this.isEnigma);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(Objects.requireNonNull(pkt.m_131708_()));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void setEnigma(boolean isEnigma) {
        this.isEnigma = isEnigma;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)IEnigmaBlock.ENIGMA, (Comparable)Boolean.valueOf(isEnigma)), 3);
        }
    }

    public List<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void setItemStacks(List<ItemStack> itemStacks) {
        this.itemStacks = itemStacks;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    @Override
    public boolean isEnigma() {
        return this.isEnigma;
    }
}

