/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.blocks.EtherDistributor;
import it.mralxart.etheria.blocks.EtherPedestal;
import it.mralxart.etheria.blocks.base.IEnigmaBlock;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.EtherDistributorTile;
import it.mralxart.etheria.tiles.EtherPedestalTile;
import it.mralxart.etheria.tiles.data.IEnigmaTile;
import it.mralxart.etheria.utils.BlockUtils;
import it.mralxart.etheria.utils.ColorUtils;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EtherCollectorTile
extends BlockEntity
implements IAnimatedTile,
IEnigmaTile {
    private final AnimationController controller = new AnimationController(this);
    public int ether = 0;
    public int maxEther = 400;
    public int tickCount = 0;
    public boolean isEnigma = false;
    private List<ParticleUtils.LineData> lines = new ArrayList<ParticleUtils.LineData>(4);

    @Override
    public void setEnigma(boolean enigma) {
        this.isEnigma = enigma;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)IEnigmaBlock.ENIGMA, (Comparable)Boolean.valueOf(enigma)), 3);
        }
    }

    public EtherCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ETHER_COLLECTOR.get(), pos, state);
        this.lines.add(new ParticleUtils.LineData(0));
        this.lines.add(new ParticleUtils.LineData(16));
        this.lines.add(new ParticleUtils.LineData(8));
        this.lines.add(new ParticleUtils.LineData(24));
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof EtherCollectorTile) {
            EtherCollectorTile tile = (EtherCollectorTile)t;
            tile.controller.tick();
            tile.setTickCount(tile.getTickCount() + 1);
            double angle = Math.PI * 2 * (double)level.f_46441_.m_188501_();
            double radius = 0.5;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            boolean isEnigma = (Boolean)blockState.m_61143_((Property)IEnigmaBlock.ENIGMA);
            if (tile.getTickCount() % 5 == 0 && isEnigma) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(EnigmaUtils.getEnigmaStartColor(tile.tickCount).getRGB(), Math.max(0.1f, level.f_46441_.m_188501_() / 4.0f), 20 + level.f_46441_.m_216339_(3, 30), 0.1f, 1.0f), (float)tile.m_58899_().m_123341_() + level.f_46441_.m_188501_(), (double)tile.m_58899_().m_123342_() + 0.7, (float)tile.m_58899_().m_123343_() + level.f_46441_.m_188501_(), 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.7) / 2.0, 0.0));
            }
            if (tile.getEther() > 0) {
                Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER).getRGB(), Math.max(0.05f, level.f_46441_.m_188501_() / 2.0f), tile.getEther() / 4 + level.f_46441_.m_216339_(3, 10), 0.1f, 1.0f), (double)tile.m_58899_().m_123341_() + 0.5 + offsetX, (double)tile.m_58899_().m_123342_() + 0.3, (double)tile.m_58899_().m_123343_() + 0.5 + offsetZ, 0.0, (double)0.02f * ((double)tile.m_58899_().m_123342_() + 0.9 - (double)tile.m_58899_().m_123342_() + 0.7) / 2.0, 0.0));
            }
            if (level.m_46462_()) {
                boolean isOnlyOneBlockInRadius = true;
                block0: for (int cx = pos.m_123341_() - 20 >> 4; cx <= pos.m_123341_() + 20 >> 4; ++cx) {
                    for (int cz = pos.m_123343_() - 20 >> 4; cz <= pos.m_123343_() + 20 >> 4; ++cz) {
                        LevelChunk chunk = level.m_6325_(cx, cz);
                        for (BlockEntity be : chunk.m_62954_().values()) {
                            if (be.equals(t) || !(be instanceof EtherCollectorTile) || !(be.m_58899_().m_123331_((Vec3i)pos) <= 400.0)) continue;
                            isOnlyOneBlockInRadius = false;
                            break;
                        }
                        if (!isOnlyOneBlockInRadius) continue block0;
                    }
                }
                if (isOnlyOneBlockInRadius && tile.ether <= tile.maxEther) {
                    Vec3 posCenter = pos.m_252807_().m_82520_(0.0, 0.5, 0.0);
                    Vec3 posRes = tile.m_58899_().m_252807_().m_82520_(0.0, 2.0, 0.0);
                    Runnable runnable = () -> ++tile.ether;
                    ParticleUtils.createLines(level, posCenter, posRes, tile.lines, runnable, 3.0f, 80);
                }
            }
            List<BlockPos> distributorPositions = BlockUtils.findBlocks(level, pos, 4, EtherDistributor.class);
            List<BlockPos> pedestalPositions = BlockUtils.findBlocks(level, pos, 4, EtherPedestal.class);
            pedestalPositions.addAll(distributorPositions);
            if (tile.getTickCount() % 20 == 0) {
                for (BlockPos pedestalPos : pedestalPositions) {
                    Item etherAmount2;
                    EtherDistributorTile pedestalTile;
                    int transferAmount;
                    int maxItemEther;
                    int itemEther;
                    IEtherEntryItem item;
                    ItemStack itemStack;
                    BlockEntity blockEntity = level.m_7702_(pedestalPos);
                    if (blockEntity instanceof EtherPedestalTile) {
                        Item item2;
                        EtherPedestalTile pedestalTile2 = (EtherPedestalTile)blockEntity;
                        itemStack = pedestalTile2.getItemStack();
                        if (itemStack.m_41619_() || !((item2 = itemStack.m_41720_()) instanceof IEtherEntryItem)) continue;
                        item = (IEtherEntryItem)item2;
                        int etherAmount2 = tile.getEther();
                        itemEther = EtherUtils.getEther(itemStack);
                        if (itemEther >= (maxItemEther = item.getMaxEther()) || etherAmount2 <= 0) continue;
                        transferAmount = Math.min(5, etherAmount2);
                        EtherUtils.setEther(itemStack, itemEther + transferAmount);
                        tile.setEther(etherAmount2 - transferAmount);
                        ParticleUtils.drawParticleLine(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249)), Math.max(0.2f, level.f_46441_.m_188501_() / 2.0f), 10 + level.f_46441_.m_216339_(3, 10), 0.1f, 1.0f), level, new Vec3((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5), new Vec3((double)pedestalPos.m_123341_() + 0.5, (double)pedestalPos.m_123342_() + 0.5, (double)pedestalPos.m_123343_() + 0.5), 20, 0.01f);
                        continue;
                    }
                    if (!(blockEntity instanceof EtherDistributorTile) || (itemStack = (pedestalTile = (EtherDistributorTile)blockEntity).getItemStack()).m_41619_() || !((etherAmount2 = itemStack.m_41720_()) instanceof IEtherEntryItem)) continue;
                    item = (IEtherEntryItem)etherAmount2;
                    int etherAmount2 = tile.getEther();
                    itemEther = EtherUtils.getEther(itemStack);
                    if (itemEther >= (maxItemEther = item.getMaxEther()) || etherAmount2 <= 0) continue;
                    transferAmount = Math.min(5, etherAmount2);
                    EtherUtils.setEther(itemStack, itemEther + transferAmount);
                    tile.setEther(etherAmount2 - transferAmount);
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ColorUtils.getRandomColorRGB(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249)), Math.max(0.2f, level.f_46441_.m_188501_() / 2.0f), 10 + level.f_46441_.m_216339_(3, 10), 0.1f, 1.0f), level, new Vec3((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5), new Vec3((double)pedestalPos.m_123341_() + 0.5, (double)pedestalPos.m_123342_() + 0.5, (double)pedestalPos.m_123343_() + 0.5), 20, 0.01f);
                }
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.ether = compound.m_128451_("ether");
        this.maxEther = compound.m_128451_("maxEther");
        this.setEnigma(compound.m_128471_("isEnigma"));
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ether", this.ether);
        compound.m_128405_("maxEther", this.maxEther);
        compound.m_128379_("isEnigma", this.isEnigma);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(Objects.requireNonNull(pkt.m_131708_()));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public int getEther() {
        return this.ether;
    }

    public void setEther(int ether) {
        this.ether = ether;
    }

    public int getMaxEther() {
        return this.maxEther;
    }

    public void setMaxEther(int maxEther) {
        this.maxEther = maxEther;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    @Override
    public boolean isEnigma() {
        return this.isEnigma;
    }
}

