/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BossTile
extends BlockEntity
implements IAnimatedTile {
    AnimationController controller = new AnimationController(this);
    public String id = "";
    public int difficulty = 0;
    public int tickCount = 0;
    public int idBoss = -1;
    private List<ParticleUtils.LineData> lines = new ArrayList<ParticleUtils.LineData>(6);
    private List<ParticleUtils.CrackPoint> cracks = new ArrayList<ParticleUtils.CrackPoint>();
    private List<ParticleUtils.CrackPoint> cracks2 = new ArrayList<ParticleUtils.CrackPoint>();

    public BossTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BOSS_BLOCK.get(), pos, state);
        this.lines.add(new ParticleUtils.LineData(0));
        this.lines.add(new ParticleUtils.LineData(4));
        this.lines.add(new ParticleUtils.LineData(16));
        this.lines.add(new ParticleUtils.LineData(8));
        this.cracks = ParticleUtils.generateSmartFractureSystem(this.m_58899_().m_252807_().m_82520_(0.0, -0.5, 0.0), 18.0f, 50, 20.0f, -2);
        this.cracks2 = ParticleUtils.generateSmartFractureSystem(this.m_58899_().m_252807_().m_82520_(0.0, -0.49, 0.0), 12.0f, 45, 20.0f, 6);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (!(t instanceof BossTile)) {
            return;
        }
        BossTile tile = (BossTile)t;
        tile.controller.tick();
        if (tile.idBoss != -1 && level.m_6815_(tile.idBoss + 1) != null && level.m_6815_(tile.idBoss + 1).m_6084_()) {
            tile.idBoss = -1;
            return;
        }
        if (tile.tickCount >= 1) {
            ++tile.tickCount;
            Vec3 posCenter = pos.m_252807_().m_82520_(0.0, -0.5, 0.0);
            Vec3 posRes = tile.m_58899_().m_252807_().m_82520_(0.0, 2.0, 0.0);
            ParticleUtils.createLines(level, ElementsUtils.getRandomColorByElement(Element.AERO), posCenter, posRes, tile.lines, () -> {}, 17.0f, 1.3f, 40, 20, true);
            ParticleUtils.drawParticlesToCenterWithSpiral(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), RandomUtils.random().nextFloat(0.2f, 0.6f), 30, 0.025f), level, pos.m_252807_().m_82520_(0.0, 1.0, 0.0), pos.m_252807_().f_82480_ - 0.5, 20, 11.0f, 0.65f, 0.5f);
            if (tile.tickCount >= 60) {
                ParticleUtils.renderCrackSystem(level, tile.cracks, new Color(123, 126, 100), tile.tickCount - 60, 180);
                ParticleUtils.drawParticlesToCenterWithSpiral((ParticleOptions)ParticleTypes.f_123796_, level, pos.m_252807_().m_82520_(0.0, 1.0, 0.0), pos.m_252807_().f_82480_ - 0.5, 10, 15.0f, 0.5f, 0.5f);
            }
            if (tile.tickCount >= 180) {
                ParticleUtils.renderCrackSystem(level, tile.cracks2, new Color(123, 126, 100), tile.tickCount - 180, 70);
            }
            if (tile.tickCount >= 220) {
                tile.tickCount = 0;
                Aerolith aerolith = new Aerolith((EntityType)EntityRegistry.AEROLITH.get(), level);
                aerolith.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                aerolith.setCenterPos(pos);
                aerolith.setDifficulty(tile.difficulty);
                AnimationSet animations = AnimationStorage.getAnimations("aerolith");
                aerolith.getController().startAnimation("spawn", animations.get("animation.model.spawn"), LoopMode.ONCE);
                level.m_7967_((Entity)aerolith);
                tile.idBoss = aerolith.m_19879_();
                tile.m_187480_();
            }
        } else {
            if (level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 20.0, false) == null) {
                return;
            }
            Vec3 posCenter = pos.m_252807_().m_82520_(0.0, -0.5, 0.0);
            Vec3 posRes = tile.m_58899_().m_252807_().m_82520_(0.0, 2.0, 0.0);
            Runnable runnable = () -> {};
            ParticleUtils.createSiphonLines(level, ElementsUtils.getRandomColorByElement(Element.AERO), posCenter, tile.lines, 13.0f, 100, 17, true);
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.id = compound.m_128461_("id_boss");
        this.tickCount = compound.m_128451_("tickCount");
        this.difficulty = compound.m_128451_("difficulty");
        this.idBoss = compound.m_128451_("idBoss");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("id_boss", this.id);
        compound.m_128405_("tickCount", this.tickCount);
        compound.m_128405_("difficulty", this.difficulty);
        compound.m_128405_("idBoss", this.idBoss);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }
}

