/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.tiles;

import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BeamRefractorTile
extends BlockEntity
implements IAnimatedTile {
    AnimationController controller = new AnimationController(this);
    private int ether = 0;

    public BeamRefractorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BEAM_REFRACTOR.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (!(t instanceof BeamRefractorTile)) {
            return;
        }
        BeamRefractorTile tile = (BeamRefractorTile)t;
        tile.controller.tick();
        if (level == null || level.f_46443_) {
            return;
        }
        if (!level.isAreaLoaded(pos, 6)) {
            return;
        }
        if (tile.ether > 0) {
            --tile.ether;
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.ether = compound.m_128451_("ether");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ether", this.ether);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public BlockEntity getAnimatedTile() {
        return this;
    }

    public int getEther() {
        return this.ether;
    }

    public void setEther(int ether) {
        this.ether = ether;
    }
}

