/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.registry;

import it.mralxart.etheria.blocks.BossBlock;
import it.mralxart.etheria.items.SpellScrollItem;
import it.mralxart.etheria.items.base.IEtherTabEntry;
import it.mralxart.etheria.magic.spells.SpellsRegistry;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class CreativeTabRegistry {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"etheria");
    public static final RegistryObject<CreativeModeTab> ETHERIA_TAB = TABS.register("etheria_items", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"tab.etheria")).m_257737_(() -> new ItemStack((ItemLike)BlockRegistry.MAGEMICON.get())).m_257501_((features, output) -> {
        BlockRegistry.ITEMS.getEntries().forEach(item -> {
            Item currentItem = (Item)item.get();
            if (currentItem == ((BossBlock)((Object)((Object)((Object)((Object)BlockRegistry.BOSS_BLOCK.get()))))).m_5456_()) {
                return;
            }
            output.m_246326_((ItemLike)currentItem);
        });
        ItemRegistry.ITEMS.getEntries().forEach(item -> {
            Item currentItem = (Item)item.get();
            if (currentItem instanceof IEtherTabEntry) {
                IEtherTabEntry entry = (IEtherTabEntry)currentItem;
                output.m_246601_(entry.etherTab());
            } else if (currentItem instanceof SpellScrollItem) {
                Map<String, SpellData> spells = SpellsRegistry.createSpellsList().getSpells().getSpells();
                spells.forEach((spellId, spellData) -> {
                    ItemStack stack = new ItemStack((ItemLike)currentItem);
                    CompoundTag nbt = stack.m_41784_();
                    nbt.m_128359_("spell_id", spellData.getId());
                    nbt.m_128359_("etheria$element", SpellsUtils.getSpellElement(spellData.getId()));
                    output.m_246342_(stack);
                });
            } else {
                output.m_246326_((ItemLike)currentItem);
            }
        });
    }).m_257652_());

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TABS.register(modEventBus);
        modEventBus.addListener(CreativeTabRegistry::fillCreativeTab);
    }

    public static void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.m_246326_((ItemLike)BlockRegistry.SANDSTONE_BRICKS.get());
            event.m_246326_((ItemLike)BlockRegistry.CRACKED_SANDSTONE_BRICKS.get());
            event.m_246326_((ItemLike)BlockRegistry.POLISHED_ICE_BRICKS.get());
            event.m_246326_((ItemLike)BlockRegistry.CRACKED_ICE_BRICKS.get());
            event.m_246326_((ItemLike)BlockRegistry.POLISHED_DIORITE_BRICKS.get());
            event.m_246326_((ItemLike)BlockRegistry.CRACKED_DIORITE_BRICKS.get());
        }
    }
}

