/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.client.gui.SpellsHud;
import it.mralxart.etheria.magic.spells.SpellsCooldown;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSpellsCooldownPacket {
    private final String spell;
    private final int cooldown;

    public UpdateSpellsCooldownPacket(FriendlyByteBuf buf) {
        this.spell = buf.m_130277_();
        this.cooldown = buf.readInt();
    }

    public UpdateSpellsCooldownPacket(String spell, int cooldown) {
        this.spell = spell;
        this.cooldown = cooldown;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.spell);
        buf.writeInt(this.cooldown);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        SpellsCooldown spellsCooldown = SpellsHud.spellsCooldown.get(this.spell);
        SpellsHud.setSpellCooldownWithCap(this.spell, spellsCooldown.getCooldown() + this.cooldown);
    }
}

