/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncTilePacket {
    private final CompoundTag data;
    private final BlockPos pos;
    private final boolean updateTag;

    public SyncTilePacket(FriendlyByteBuf buf) {
        this.data = buf.m_130260_();
        this.pos = buf.m_130135_();
        this.updateTag = buf.readBoolean();
    }

    public SyncTilePacket(BlockEntity tile, boolean updateTag) {
        this.data = updateTag ? tile.m_5995_() : tile.serializeNBT();
        this.pos = tile.m_58899_();
        this.updateTag = updateTag;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.data);
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.updateTag);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        BlockEntity tile;
        Level world;
        if (Minecraft.m_91087_().f_91074_ != null && (world = Minecraft.m_91087_().f_91074_.m_9236_()) != null && (tile = world.m_7702_(this.pos)) != null) {
            if (this.updateTag) {
                tile.handleUpdateTag(this.data);
            } else {
                tile.m_142466_(this.data);
            }
        }
    }
}

