/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.handlers.SoundsHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PacketDungeonResponse {
    private final ResourceLocation location;
    private final boolean inDungeon;

    public PacketDungeonResponse(ResourceLocation location, boolean inDungeon) {
        this.inDungeon = inDungeon;
        this.location = location;
    }

    public PacketDungeonResponse(FriendlyByteBuf buf) {
        this.inDungeon = buf.readBoolean();
        this.location = buf.m_130281_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.inDungeon);
        buf.m_130085_(this.location);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        SoundsHandler.updateIsActive(this.location, this.inDungeon);
    }
}

