/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.magic.korlunar.KorLunarLevels;
import it.mralxart.etheria.magic.korlunar.data.KorLunarLevel;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ItemUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class KorLunarUpPacket {
    private final int level;

    public KorLunarUpPacket(FriendlyByteBuf buf) {
        this.level = buf.readInt();
    }

    public KorLunarUpPacket(int level) {
        this.level = level;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.level);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            return false;
        }
        EtheriaCapability cap = CapabilityRegistry.getCap((Player)player);
        int korLunarLevel = cap.getKorLunar();
        KorLunarLevel lunarLevel = KorLunarLevels.getLevel(korLunarLevel);
        List<ItemStack> itemStacks = lunarLevel.getIngredients();
        for (ItemStack itemStack : itemStacks) {
            ItemUtils.removeItemsFromInventory(player.m_150109_(), itemStack);
        }
        cap.setKorLunar(korLunarLevel + this.level);
        SyncCapabilityManager.sync((Player)player);
        return true;
    }
}

