/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class EntityVelocityPacket {
    private final double velocityX;
    private final double velocityY;
    private final double velocityZ;

    public EntityVelocityPacket(FriendlyByteBuf buf) {
        this.velocityX = buf.readDouble();
        this.velocityY = buf.readDouble();
        this.velocityZ = buf.readDouble();
    }

    public EntityVelocityPacket(double velocityX, double velocityY, double velocityZ) {
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.velocityX);
        buf.writeDouble(this.velocityY);
        buf.writeDouble(this.velocityZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Vec3 velocity = new Vec3(this.velocityX, this.velocityY, this.velocityZ);
            Minecraft.m_91087_().f_91074_.m_20256_(velocity);
        }
    }
}

