/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class C2SSkillButtonPacket {
    private String id = "";
    private String type = "";
    private int points = 0;
    private UUID uuid = UUID.randomUUID();

    public void read(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.m_130070_(this.type);
        buf.writeInt(this.points);
        buf.m_130077_(this.uuid);
    }

    public C2SSkillButtonPacket(String id, String type, int points, UUID uuid) {
        this.id = id;
        this.type = type;
        this.points = points;
        this.uuid = uuid;
    }

    public C2SSkillButtonPacket(FriendlyByteBuf buf) {
        this.id = buf.m_130277_();
        this.type = buf.m_130277_();
        this.points = buf.readInt();
        this.uuid = buf.m_130259_();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = null;
        if (ctx.get().getSender() != null) {
            player = ctx.get().getSender();
        } else {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129880_(Level.f_46428_);
            if ((level != null ? level.m_8791_(this.uuid) : null) != null && level.m_8791_(this.uuid) instanceof Player) {
                player = (Player)level.m_8791_(this.uuid);
            }
        }
        if (player instanceof ServerPlayer) {
            if (SkillsUtils.getSkillById((Player)player, this.id).isPresent()) {
                switch (this.type) {
                    case "upgrade": {
                        if (!SkillsUtils.isSkillUnlockd((Player)player, this.id)) break;
                        SkillsUtils.getSkillById((Player)player, this.id).get().setLvl(SkillsUtils.getSkillById((Player)player, this.id).get().getLvl() + 1);
                        CapabilityRegistry.getCap((Player)player).setSkillPoints(CapabilityRegistry.getCap((Player)player).getSkillPoints() - this.points);
                        if (CapabilityRegistry.getCap((Player)player).getSkillPoints() < 0) {
                            CapabilityRegistry.getCap((Player)player).setSkillPoints(0);
                        }
                        SyncCapabilityManager.sync((Player)player);
                        break;
                    }
                    case "buy": {
                        SkillsUtils.unlockSkillById((Player)player, this.id, true);
                        SkillsUtils.getSkillById((Player)player, this.id).get().setLvl(1);
                        SkillsUtils.getSkillById((Player)player, this.id).get().setActive(true);
                        CapabilityRegistry.getCap((Player)player).setSkillPoints(CapabilityRegistry.getCap((Player)player).getSkillPoints() - this.points);
                        if (CapabilityRegistry.getCap((Player)player).getSkillPoints() < 0) {
                            CapabilityRegistry.getCap((Player)player).setSkillPoints(0);
                        }
                        SyncCapabilityManager.sync((Player)player);
                        break;
                    }
                    case "active": {
                        if (!SkillsUtils.isSkillUnlockd((Player)player, this.id)) break;
                        SkillsUtils.getSkillById((Player)player, this.id).get().setActive(!SkillsUtils.getSkillById((Player)player, this.id).get().isActive());
                        SyncCapabilityManager.sync((Player)player);
                    }
                }
            } else {
                SyncCapabilityManager.sync((Player)player);
            }
        }
    }
}

