/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.network.packets;

import it.mralxart.etheria.client.gui.toast.MageMiconToast;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class AddToastPacket {
    private final ItemStack item;
    private final String icon;
    private final String text;

    public AddToastPacket(FriendlyByteBuf buf) {
        this.item = buf.m_130267_();
        this.icon = buf.m_130277_();
        this.text = buf.m_130277_();
    }

    public AddToastPacket(ItemStack item, String text) {
        this.item = item;
        this.icon = "";
        this.text = text;
    }

    public AddToastPacket(String icon, String text) {
        this.icon = icon;
        this.item = ItemStack.f_41583_;
        this.text = text;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.item);
        buf.m_130070_(this.icon);
        buf.m_130070_(this.text);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new MageMiconToast(this.item, this.icon, this.text));
    }
}

