/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.mixin;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.utils.WeaponUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/nbt/CompoundTag;)V"})
    protected void etheria$init(ItemLike slug, int count, CompoundTag tag, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        if (!(stack.m_41720_() instanceof ArtifactItem)) {
            return;
        }
        ArtifactStatsManager.init(stack);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetTooltipLines(@Nullable Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        ItemStack stack = (ItemStack)this;
        Item item = stack.m_41720_();
        if (!(item instanceof WeaponItem)) {
            return;
        }
        WeaponItem weapon = (WeaponItem)item;
        List original = (List)cir.getReturnValue();
        ArrayList tooltip = new ArrayList();
        if (original.size() > 1) {
            if (((Component)original.get(0)).getString().isEmpty()) {
                original.remove(0);
            }
            if (((Component)original.get(1)).getString().isEmpty()) {
                original.remove(1);
            }
        }
        int cutoffIndex = -1;
        for (int i = 0; i < original.size(); ++i) {
            String s = ((Component)original.get(i)).getString();
            if (!s.contains("When in Main Hand") && !s.contains("\u041a\u043e\u0433\u0434\u0430 \u0432 \u0432\u0435\u0434\u0443\u0449\u0435\u0439 \u0440\u0443\u043a\u0435")) continue;
            cutoffIndex = i;
            break;
        }
        if (cutoffIndex != -1) {
            tooltip.addAll(original.subList(0, cutoffIndex));
        } else {
            tooltip.addAll(original);
        }
        tooltip.addAll(WeaponUtils.getTooltip(stack));
        cir.setReturnValue(tooltip);
    }
}

