/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.weapon.base;

import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.utils.RandomUtils;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.entity.LivingEntity;

public class DamageContext {
    private final LivingEntity attacker;
    private final Element spellElement;
    private final float skillBaseDamage;
    private final float totalWeaponDamage;
    private final float globalDamageBonus;
    private final float critRate;
    private final float critDamage;
    private final float elementaryAmplification;
    private final float aeroBonus;
    private final float pyroBonus;
    private final float cryoBonus;
    private static final Random random = RandomUtils.random();

    public DamageContext(LivingEntity attacker, Element spellElement, float skillBaseDamage, float totalWeaponDamage, float globalDamageBonus, float elementaryAmplification, float critRate, float critDamage, Map<Element, Float> elementMap) {
        this.attacker = attacker;
        this.spellElement = spellElement;
        this.skillBaseDamage = skillBaseDamage;
        this.totalWeaponDamage = totalWeaponDamage;
        this.globalDamageBonus = globalDamageBonus;
        this.critRate = critRate;
        this.critDamage = critDamage;
        this.elementaryAmplification = elementaryAmplification;
        this.aeroBonus = elementMap.getOrDefault((Object)Element.AERO, Float.valueOf(0.0f)).floatValue();
        this.pyroBonus = elementMap.getOrDefault((Object)Element.PYRO, Float.valueOf(0.0f)).floatValue();
        this.cryoBonus = elementMap.getOrDefault((Object)Element.CRYO, Float.valueOf(0.0f)).floatValue();
    }

    private float getBonusForCurrentElement() {
        if (this.spellElement == null) {
            return 0.0f;
        }
        return switch (this.spellElement) {
            case Element.AERO -> this.aeroBonus;
            case Element.PYRO -> this.pyroBonus;
            case Element.CRYO -> this.cryoBonus;
            default -> 0.0f;
        };
    }

    public DamageResult resolve() {
        float baseTotal = this.skillBaseDamage + this.totalWeaponDamage;
        float elementalBonus = this.getBonusForCurrentElement();
        float bonusMultiplier = 1.0f + (this.globalDamageBonus + elementalBonus) / 100.0f;
        float calculatedDamage = baseTotal * bonusMultiplier;
        boolean isCrit = this.isCrit();
        if (isCrit) {
            calculatedDamage *= 1.0f + this.critDamage / 100.0f;
        }
        return new DamageResult(calculatedDamage, isCrit);
    }

    public Element getElement() {
        return this.spellElement;
    }

    public boolean isCrit() {
        return random.nextFloat() * 100.0f < this.critRate;
    }

    public LivingEntity getAttacker() {
        return this.attacker;
    }

    public Element getSpellElement() {
        return this.spellElement;
    }

    public float getSkillBaseDamage() {
        return this.skillBaseDamage;
    }

    public float getTotalWeaponDamage() {
        return this.totalWeaponDamage;
    }

    public float getGlobalDamageBonus() {
        return this.globalDamageBonus;
    }

    public float getCritRate() {
        return this.critRate;
    }

    public float getCritDamage() {
        return this.critDamage;
    }

    public float getElementaryAmplification() {
        return this.elementaryAmplification;
    }

    public float getAeroBonus() {
        return this.aeroBonus;
    }

    public float getPyroBonus() {
        return this.pyroBonus;
    }

    public float getCryoBonus() {
        return this.cryoBonus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DamageContext)) {
            return false;
        }
        DamageContext other = (DamageContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getSkillBaseDamage(), other.getSkillBaseDamage()) != 0) {
            return false;
        }
        if (Float.compare(this.getTotalWeaponDamage(), other.getTotalWeaponDamage()) != 0) {
            return false;
        }
        if (Float.compare(this.getGlobalDamageBonus(), other.getGlobalDamageBonus()) != 0) {
            return false;
        }
        if (Float.compare(this.getCritRate(), other.getCritRate()) != 0) {
            return false;
        }
        if (Float.compare(this.getCritDamage(), other.getCritDamage()) != 0) {
            return false;
        }
        if (Float.compare(this.getElementaryAmplification(), other.getElementaryAmplification()) != 0) {
            return false;
        }
        if (Float.compare(this.getAeroBonus(), other.getAeroBonus()) != 0) {
            return false;
        }
        if (Float.compare(this.getPyroBonus(), other.getPyroBonus()) != 0) {
            return false;
        }
        if (Float.compare(this.getCryoBonus(), other.getCryoBonus()) != 0) {
            return false;
        }
        LivingEntity this$attacker = this.getAttacker();
        LivingEntity other$attacker = other.getAttacker();
        if (this$attacker == null ? other$attacker != null : !this$attacker.equals(other$attacker)) {
            return false;
        }
        Element this$spellElement = this.getSpellElement();
        Element other$spellElement = other.getSpellElement();
        return !(this$spellElement == null ? other$spellElement != null : !((Object)((Object)this$spellElement)).equals((Object)other$spellElement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DamageContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getSkillBaseDamage());
        result = result * 59 + Float.floatToIntBits(this.getTotalWeaponDamage());
        result = result * 59 + Float.floatToIntBits(this.getGlobalDamageBonus());
        result = result * 59 + Float.floatToIntBits(this.getCritRate());
        result = result * 59 + Float.floatToIntBits(this.getCritDamage());
        result = result * 59 + Float.floatToIntBits(this.getElementaryAmplification());
        result = result * 59 + Float.floatToIntBits(this.getAeroBonus());
        result = result * 59 + Float.floatToIntBits(this.getPyroBonus());
        result = result * 59 + Float.floatToIntBits(this.getCryoBonus());
        LivingEntity $attacker = this.getAttacker();
        result = result * 59 + ($attacker == null ? 43 : $attacker.hashCode());
        Element $spellElement = this.getSpellElement();
        result = result * 59 + ($spellElement == null ? 43 : ((Object)((Object)$spellElement)).hashCode());
        return result;
    }

    public String toString() {
        return "DamageContext(attacker=" + String.valueOf(this.getAttacker()) + ", spellElement=" + String.valueOf((Object)this.getSpellElement()) + ", skillBaseDamage=" + this.getSkillBaseDamage() + ", totalWeaponDamage=" + this.getTotalWeaponDamage() + ", globalDamageBonus=" + this.getGlobalDamageBonus() + ", critRate=" + this.getCritRate() + ", critDamage=" + this.getCritDamage() + ", elementaryAmplification=" + this.getElementaryAmplification() + ", aeroBonus=" + this.getAeroBonus() + ", pyroBonus=" + this.getPyroBonus() + ", cryoBonus=" + this.getCryoBonus() + ")";
    }

    public record DamageResult(float damage, boolean isCrit) {
    }
}

