/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.weapon.base;

import com.mojang.datafixers.util.Pair;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.magic.weapon.WeaponAbility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;

public class AttributeEffectBuilder {
    private Pair<StatType, double[]> mainStat;
    private final Map<StatType, double[]> attributes = new LinkedHashMap<StatType, double[]>();
    private final Map<StatType, double[]> passiveAttributes = new LinkedHashMap<StatType, double[]>();
    private final List<WeaponAbility> abilities = new ArrayList<WeaponAbility>();

    public static AttributeEffectBuilder create() {
        return new AttributeEffectBuilder();
    }

    public AttributeEffectBuilder mainStat(StatType key, double ... values) {
        this.mainStat = Pair.of((Object)((Object)key), (Object)values);
        return this;
    }

    public AttributeEffectBuilder attribute(StatType key, double ... values) {
        this.attributes.put(key, values);
        return this;
    }

    public AttributeEffectBuilder attributeP(StatType key, double ... values) {
        this.passiveAttributes.put(key, values);
        return this;
    }

    public AttributeEffectBuilder addAbility(WeaponAbility ability) {
        this.abilities.add(ability);
        return this;
    }

    public void buildPassiveTooltip(Item item, List<Component> tooltip, int starLevel, int numColor) {
        tooltip.add((Component)Component.m_237115_((String)(item.m_5524_() + ".passive.name")).m_130948_(Style.f_131099_.m_178520_(numColor).m_131136_(Boolean.valueOf(true))));
        LinkedHashMap<StatType, double[]> map = new LinkedHashMap<StatType, double[]>(this.attributes);
        map.putAll(this.passiveAttributes);
        int i = 0;
        Object[] args = new Object[map.size()];
        for (Map.Entry<StatType, double[]> set : map.entrySet()) {
            StatType stat = set.getKey();
            double[] values = map.get((Object)stat);
            double val = values != null && values.length > 0 ? values[Math.min(starLevel, values.length - 1)] : 0.0;
            String chance = "%";
            if (stat.equals((Object)StatType.COOLDOWN) || stat.equals((Object)StatType.ELEMENTAL_AMPLIFICATION) || stat.equals((Object)StatType.DURATION)) {
                chance = "";
            }
            MutableComponent component = Component.m_237113_((String)(this.format(val) + chance)).m_130948_(Style.f_131099_.m_178520_(numColor));
            args[i] = component;
            ++i;
        }
        tooltip.add((Component)Component.m_237110_((String)(item.m_5524_() + ".passive.description"), (Object[])args).m_130940_(ChatFormatting.GRAY));
    }

    private String format(double value) {
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format("%s", value);
    }

    public Map<StatType, double[]> getAttributes() {
        return this.attributes;
    }

    public Map<StatType, double[]> getPassiveAttributes() {
        return this.passiveAttributes;
    }

    public List<WeaponAbility> getAbilities() {
        return this.abilities;
    }

    public void setMainStat(Pair<StatType, double[]> mainStat) {
        this.mainStat = mainStat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeEffectBuilder)) {
            return false;
        }
        AttributeEffectBuilder other = (AttributeEffectBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pair<StatType, double[]> this$mainStat = this.getMainStat();
        Pair<StatType, double[]> other$mainStat = other.getMainStat();
        if (this$mainStat == null ? other$mainStat != null : !this$mainStat.equals(other$mainStat)) {
            return false;
        }
        Map<StatType, double[]> this$attributes = this.getAttributes();
        Map<StatType, double[]> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<StatType, double[]> this$passiveAttributes = this.getPassiveAttributes();
        Map<StatType, double[]> other$passiveAttributes = other.getPassiveAttributes();
        if (this$passiveAttributes == null ? other$passiveAttributes != null : !((Object)this$passiveAttributes).equals(other$passiveAttributes)) {
            return false;
        }
        List<WeaponAbility> this$abilities = this.getAbilities();
        List<WeaponAbility> other$abilities = other.getAbilities();
        return !(this$abilities == null ? other$abilities != null : !((Object)this$abilities).equals(other$abilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeEffectBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pair<StatType, double[]> $mainStat = this.getMainStat();
        result = result * 59 + ($mainStat == null ? 43 : $mainStat.hashCode());
        Map<StatType, double[]> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<StatType, double[]> $passiveAttributes = this.getPassiveAttributes();
        result = result * 59 + ($passiveAttributes == null ? 43 : ((Object)$passiveAttributes).hashCode());
        List<WeaponAbility> $abilities = this.getAbilities();
        result = result * 59 + ($abilities == null ? 43 : ((Object)$abilities).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeEffectBuilder(mainStat=" + String.valueOf(this.getMainStat()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", passiveAttributes=" + String.valueOf(this.getPassiveAttributes()) + ", abilities=" + String.valueOf(this.getAbilities()) + ")";
    }

    public Pair<StatType, double[]> getMainStat() {
        return this.mainStat;
    }
}

