/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.weapon.ability;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.weapon.WeaponAbility;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.AttributeEffectBuilder;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GaleDanceAbility
extends WeaponAbility {
    private static final String ACTIVE_TICKS_KEY = "GaleDance_ActiveTicks";
    private static final float CHANCE = 0.65f;
    private static final float COOLDOWN = 30.0f;
    private static final int DURATION_TICKS = 200;
    private static final float DAMAGE_PERCENT = 0.06f;
    private static final double RADIUS = 4.0;
    private static final Color STRIKE_COLOR = new Color(205, 246, 255);
    private static final Color CLOUD_PARTICLE_COLOR = new Color(200, 200, 220);

    @Override
    public String getId() {
        return "gale_dance";
    }

    @Override
    public void onAttack(ItemStack stack, LivingEntity target, LivingEntity attacker, int starLevel, AttributeEffectBuilder stats) {
        if (attacker.m_9236_().f_46443_) {
            return;
        }
        if (!this.isOnCooldown(stack, attacker, 30.0f) && attacker.m_217043_().m_188501_() <= 0.65f) {
            stack.m_41784_().m_128405_(ACTIVE_TICKS_KEY, 200);
            this.setCooldown(stack, attacker);
        }
    }

    @Override
    public void onTick(ItemStack stack, LivingEntity player, boolean isSelected, boolean isOffHand) {
        if (!isSelected || player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int activeTicks = tag.m_128451_(ACTIVE_TICKS_KEY);
        if (activeTicks <= 0) {
            return;
        }
        tag.m_128405_(ACTIVE_TICKS_KEY, --activeTicks);
        AABB area = player.m_20191_().m_82400_(4.0);
        List enemies = player.m_9236_().m_6443_(LivingEntity.class, area, e -> e != player && e.m_6084_() && !e.m_7307_((Entity)player));
        for (LivingEntity target : enemies) {
            float f;
            this.renderStormCloud(target);
            if (activeTicks % 30 != 0) continue;
            Level level = player.m_9236_();
            Item item = stack.m_41720_();
            if (item instanceof WeaponItem) {
                WeaponItem weapon = (WeaponItem)item;
                f = weapon.getBaseDamage();
            } else {
                f = 2.0f;
            }
            float baseDamage = f;
            float damageToDeal = baseDamage * 0.06f;
            Vec3 startPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() + 1.0f), 0.0);
            Vec3 endPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            ParticleUtils.drawParticleLine(new GlowingParticleData(STRIKE_COLOR, 0.4f, 10, 0.02f), level, startPos, endPos, 8, 0.5f, 0.2f);
            ParticleUtils.createParticle(level, (ParticleOptions)ParticleTypes.f_175830_, endPos.f_82479_, endPos.f_82480_, endPos.f_82481_, 5, 0.1, 0.1, 0.1, 0.2);
            target.m_6469_(player.m_269291_().m_269104_((Entity)player, (Entity)player), damageToDeal);
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12089_, SoundSource.PLAYERS, 0.5f, 2.0f);
        }
    }

    private void renderStormCloud(LivingEntity target) {
        Level level = target.m_9236_();
        double width = (double)target.m_20205_() * 1.2;
        Vec3 cloudCenter = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() + 1.0f), 0.0);
        AABB cloudBox = new AABB(cloudCenter.f_82479_ - width / 2.0, cloudCenter.f_82480_ - 0.1, cloudCenter.f_82481_ - width / 2.0, cloudCenter.f_82479_ + width / 2.0, cloudCenter.f_82480_ + 0.3, cloudCenter.f_82481_ + width / 2.0);
        ParticleUtils.createAABB(level, (ParticleOptions)ParticleTypes.f_123796_, cloudBox, 2, 0.01);
        if (level.f_46441_.m_188501_() < 0.3f) {
            ParticleUtils.createParticle(level, new GlowingParticleData(CLOUD_PARTICLE_COLOR, 0.3f, 10, 0.01f), cloudCenter.f_82479_, cloudCenter.f_82480_, cloudCenter.f_82481_, 1, width / 2.0, 0.1, width / 2.0, 0.02);
        }
    }
}

