/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.items.base.ElementItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.SpellEntity;
import it.mralxart.etheria.magic.weapon.WeaponAbility;
import it.mralxart.etheria.magic.weapon.base.AttributeEffectBuilder;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.magic.weapon.base.WeaponRarity;
import it.mralxart.etheria.magic.weapon.base.WeaponType;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.WeaponUtils;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WeaponItem
extends Item {
    protected static final UUID MOVEMENT_SPEED_MODIFIER = UUID.fromString("16295ED8-B092-4A75-9A94-BCD8D56668BB");
    private final float baseDamage;
    private final float baseAttackSpeed;
    private final WeaponType type;
    private final WeaponRarity weaponRarity;
    private final AttributeEffectBuilder additionalAttributes;

    public WeaponItem(float baseDamage, float baseAttackSpeed, WeaponType type, WeaponRarity rarity, Item.Properties properties) {
        super(properties);
        this.baseDamage = baseDamage;
        this.baseAttackSpeed = baseAttackSpeed;
        this.type = type;
        this.weaponRarity = rarity;
        this.additionalAttributes = AttributeEffectBuilder.create();
    }

    public WeaponItem(float baseDamage, float baseAttackSpeed, WeaponType type, WeaponRarity rarity, Item.Properties properties, AttributeEffectBuilder builder) {
        super(properties);
        this.baseDamage = baseDamage;
        this.baseAttackSpeed = baseAttackSpeed;
        this.type = type;
        this.weaponRarity = rarity;
        this.additionalAttributes = builder;
    }

    public float getLevelBonus(ItemStack stack) {
        int level = WeaponUtils.getLevel(stack);
        return (float)(Math.pow(level, 1.2) / 100.0);
    }

    public float getStarMultiplier(ItemStack stack) {
        int stars = WeaponUtils.getStars(stack);
        return 1.0f + (float)stars * 0.7f;
    }

    public float calculateDamage(ItemStack stack) {
        float raw = this.baseDamage + this.weaponRarity.getDamageBonus() + this.getLevelBonus(stack);
        return raw * this.getStarMultiplier(stack);
    }

    public float calculateAttackSpeed(ItemStack stack) {
        float penalty = switch (this.type) {
            case WeaponType.TWO_HANDED -> 0.4f;
            case WeaponType.SPEAR -> 0.2f;
            case WeaponType.BLADE -> 0.1f;
            default -> 0.0f;
        };
        return this.baseAttackSpeed + this.weaponRarity.getSpeedBonus() - penalty + (float)WeaponUtils.getLevel(stack) * 0.015f;
    }

    public double getMovementPenalty() {
        return switch (this.type) {
            case WeaponType.TWO_HANDED -> -0.02;
            default -> 0.0;
        };
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack p_41458_) {
        Component component = super.m_7626_(p_41458_);
        int stars = p_41458_.m_41784_().m_128441_("etheria$stars") ? (p_41458_.m_41783_() != null ? p_41458_.m_41783_().m_128451_("etheria$stars") : 0) : 1;
        String starsText = "[" + "\u2605".repeat(Math.max(0, stars)) + "\u2606".repeat(Math.max(0, 5 - stars)) + "]";
        MutableComponent starsComponent = Component.m_237113_((String)starsText).m_130948_(component.m_7383_());
        Item item = p_41458_.m_41720_();
        if (item instanceof ElementItem) {
            ElementItem item2 = (ElementItem)item;
            return Component.m_237113_((String)(component.getString() + " " + starsComponent.getString())).m_130948_(component.m_7383_().m_178520_(ElementsUtils.getColorByElement(item2.getElement()).getRGB()));
        }
        return Component.m_237113_((String)(component.getString() + " " + starsComponent.getString())).m_130948_(component.m_7383_().m_178520_(this.weaponRarity.getStartColor()));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.type == WeaponType.CATALYST ? UseAnim.NONE : UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int stars = WeaponUtils.getStars(stack);
        if (this.type != WeaponType.CATALYST) {
            for (WeaponAbility ability : this.additionalAttributes.getAbilities()) {
                ability.onAttack(stack, target, attacker, stars, this.additionalAttributes);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level p_41405_, Entity entity, int p_41407_, boolean p_41408_) {
        super.m_6883_(stack, p_41405_, entity, p_41407_, p_41408_);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (stack.m_41784_().m_128461_("etheria$uuid").isEmpty()) {
                stack.m_41784_().m_128359_("etheria$uuid", UUID.randomUUID().toString());
            }
            WeaponUtils.writeStatsToNbt(stack, this.getAdditionalAttribute(), WeaponUtils.getStars(stack));
            for (WeaponAbility ability : this.additionalAttributes.getAbilities()) {
                ability.onTick(stack, living, p_41408_, living.m_21206_() == stack);
            }
        }
    }

    public UUID getUUID(ItemStack stack) {
        return UUID.fromString(stack.m_41784_().m_128461_("etheria$uuid"));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.calculateDamage(stack), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.calculateAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            if (this.getMovementPenalty() != 0.0) {
                builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "Weapon movement penalty", this.getMovementPenalty(), AttributeModifier.Operation.ADDITION));
            }
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int duration = this.m_8105_(stack) - timeLeft;
        float chargeProgress = WeaponItem.getPowerForTime(duration);
        double attackSpeed = player.m_21133_(Attributes.f_22283_);
        if (attackSpeed == 0.0) {
            attackSpeed = 4.0;
        }
        int attackCooldownTicks = (int)(20.0 / attackSpeed);
        if (chargeProgress < 0.2f) {
            if (this.type == WeaponType.CATALYST) {
                this.normalAttack(stack, level, player);
                player.m_36335_().m_41524_((Item)this, attackCooldownTicks);
            }
        } else if (chargeProgress >= 1.0f) {
            this.chargedAttack(stack, level, player);
            player.m_36335_().m_41524_((Item)this, attackCooldownTicks * 4);
        }
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int count) {
        if (living.m_9236_().f_46443_ && living instanceof Player) {
            Player player = (Player)living;
            if (this.type == WeaponType.CATALYST) {
                int duration = this.m_8105_(stack) - count;
                float progress = WeaponItem.getPowerForTime(duration);
                Color color = Color.WHITE;
                Item item = stack.m_41720_();
                if (item instanceof IElementItem) {
                    IElementItem elementItem = (IElementItem)item;
                    color = ElementsUtils.getColorByElement(elementItem.getElement());
                }
                ParticleUtils.drawChargingRing(player.m_9236_(), (LivingEntity)player, progress, duration, color);
                ParticleUtils.drawHandFocusEnergy(player.m_9236_(), player, progress, duration, color);
            }
        }
    }

    public static float getPowerForTime(int ticks) {
        float f = (float)ticks / 20.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    protected void normalAttack(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        float damage = this.calculateDamage(stack);
        Vec3 look = player.m_20154_();
        DamageContext context = ArtifactStatCalculator.createContext((LivingEntity)player, damage, Element.ETHER);
        SpellEntity spell = new SpellEntity(level, damage, "NONE");
        spell.m_5602_((Entity)player);
        spell.setContext(context);
        spell.m_6034_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
        spell.m_20256_(look.m_82490_(1.5));
        spell.m_20242_(true);
        level.m_7967_((Entity)spell);
    }

    protected void chargedAttack(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        float damage = this.calculateDamage(stack) * 2.5f;
        if (this.type == WeaponType.CATALYST) {
            this.normalAttack(stack, level, player);
        } else {
            AABB area = player.m_20191_().m_82400_(3.0);
            level.m_6443_(LivingEntity.class, area, e -> e != player).forEach(target -> {
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                target.m_147240_(1.0, player.m_20185_() - target.m_20185_(), player.m_20189_() - target.m_20189_());
            });
        }
    }

    public AttributeEffectBuilder getAdditionalAttribute() {
        return this.additionalAttributes;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public WeaponType getType() {
        return this.type;
    }

    public WeaponRarity getWeaponRarity() {
        return this.weaponRarity;
    }

    public AttributeEffectBuilder getAdditionalAttributes() {
        return this.additionalAttributes;
    }
}

