/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.trial;

import it.mralxart.etheria.magic.trial.TrialStorage;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.SyncTilePacket;
import it.mralxart.etheria.tiles.TrialTile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public enum TrialState implements StringRepresentable
{
    INACTIVE("inactive"),
    WAITING_FOR_PLAYERS("waiting_for_players"),
    ACTIVE("active"),
    WAITING_FOR_REWARD_EJECTION("waiting_for_reward_ejection"),
    EJECTING_REWARD("ejecting_reward"),
    COOLDOWN("cooldown");

    private final String name;

    private TrialState(String string2) {
        this.name = string2;
    }

    public TrialState tickAndGetNext(ServerLevel serverLevel, BlockPos blockPos, TrialTile trialSpawner) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case INACTIVE -> {
                if (trialSpawner.isCooldownFinished(serverLevel) && TrialStorage.getTrialInfoById(trialSpawner.getId()) == null) {
                    yield this;
                }
                yield WAITING_FOR_PLAYERS;
            }
            case WAITING_FOR_PLAYERS -> {
                if (trialSpawner.getId().isEmpty()) {
                    yield INACTIVE;
                }
                if (!trialSpawner.canSpawnInLevel((Level)serverLevel)) {
                    yield this;
                }
                if (TrialStorage.getTrialInfoById(trialSpawner.getId()) == null) {
                    yield this;
                }
                if (!trialSpawner.hasMobToSpawn(serverLevel.f_46441_)) {
                    yield INACTIVE;
                }
                if (!trialSpawner.tryDetectPlayers(serverLevel, blockPos, trialSpawner.radius + 6)) {
                    yield this;
                }
                trialSpawner.tryDetectPlayers(serverLevel, blockPos);
                trialSpawner.config = TrialStorage.getTrialInfoById(trialSpawner.getId());
                if (trialSpawner.config != null) {
                    trialSpawner.spawnData = trialSpawner.config.copy().getMobs().get(trialSpawner.config.copy().getCurrentMobId(trialSpawner.currentWaveId));
                }
                if (trialSpawner.detectedPlayers.isEmpty()) {
                    yield this;
                }
                yield ACTIVE;
            }
            case ACTIVE -> {
                if (trialSpawner.getId().isEmpty()) {
                    yield INACTIVE;
                }
                if (!trialSpawner.canSpawnInLevel((Level)serverLevel)) {
                    trialSpawner.reset();
                    yield WAITING_FOR_PLAYERS;
                }
                if (!trialSpawner.hasMobToSpawn(serverLevel.f_46441_)) {
                    yield INACTIVE;
                }
                if (TrialStorage.getTrialInfoById(trialSpawner.getId()) == null) {
                    yield WAITING_FOR_PLAYERS;
                }
                trialSpawner.config = TrialStorage.getTrialInfoById(trialSpawner.getId());
                int i = trialSpawner.countAdditionalPlayers(serverLevel, blockPos);
                if (trialSpawner.hasFinishedSpawningAllMobs(trialSpawner.config.copy(), i)) {
                    if (trialSpawner.haveAllCurrentMobsDied(serverLevel)) {
                        trialSpawner.resetCooldown(serverLevel, trialSpawner.config.copy().getCooldown());
                        trialSpawner.nextMobSpawnsAt = -1L;
                        trialSpawner.cooldownToEjection = serverLevel.m_46467_() + 40L;
                        yield WAITING_FOR_REWARD_EJECTION;
                    }
                    yield this;
                }
                if (trialSpawner.isReadyToSpawnNextMob(serverLevel, i)) {
                    if (trialSpawner.nextSpawnData.isEmpty() && trialSpawner.spawnData.isEmpty()) {
                        trialSpawner.spawnData = trialSpawner.config.getMobs().get(trialSpawner.config.getCurrentMobId(trialSpawner.currentWaveId));
                        trialSpawner.currentWaveId = trialSpawner.config.getNextMobId(trialSpawner.currentWaveId);
                    }
                    trialSpawner.spawnMobs(serverLevel, trialSpawner.spawnData, blockPos, i).ifPresent(uUID -> {
                        trialSpawner.spawnedEntities.add((UUID)uUID);
                        ++trialSpawner.allSpawnedMobs;
                        trialSpawner.nextMobSpawnsAt = serverLevel.m_46467_() + 10L;
                        trialSpawner.nextSpawnData = trialSpawner.config.getMobs().get(trialSpawner.config.copy().getNextMobId(trialSpawner.currentWaveId));
                    });
                    if (!trialSpawner.nextSpawnData.isEmpty() && trialSpawner.spawnData.isEmpty()) {
                        trialSpawner.spawnData = trialSpawner.nextSpawnData;
                        trialSpawner.currentWaveId = trialSpawner.config.copy().getNextMobId(trialSpawner.currentWaveId);
                    }
                    Networking.sendToClients(PacketDistributor.ALL.noArg(), new SyncTilePacket(trialSpawner, true));
                }
                yield this;
            }
            case WAITING_FOR_REWARD_EJECTION -> {
                if (serverLevel.m_46467_() >= trialSpawner.cooldownToEjection && trialSpawner.tryDetectPlayers(serverLevel, blockPos, 6)) {
                    yield EJECTING_REWARD;
                }
                yield this;
            }
            case EJECTING_REWARD -> {
                if (trialSpawner.detectedPlayers.isEmpty()) {
                    yield COOLDOWN;
                }
                trialSpawner.giveReward(serverLevel, trialSpawner.config, blockPos);
                trialSpawner.detectedPlayers.remove(trialSpawner.detectedPlayers.iterator().next());
                yield this;
            }
            case COOLDOWN -> {
                if (trialSpawner.isCooldownFinished(serverLevel)) {
                    trialSpawner.reset();
                    yield INACTIVE;
                }
                yield this;
            }
        };
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }
}

