/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.trial;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class TrialInfo {
    private String id;
    private int cooldown;
    private Map<String, List<String>> mobs;
    private Map<String, TrialInfoBuilder.LootData> rewards;

    public TrialInfo() {
    }

    public TrialInfo copy() {
        TrialInfo copy = new TrialInfo();
        copy.setId(this.id);
        copy.setCooldown(this.cooldown);
        HashMap<String, List<String>> mobsCopy = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.mobs.entrySet()) {
            mobsCopy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        copy.setMobs(mobsCopy);
        HashMap<String, TrialInfoBuilder.LootData> rewardsCopy = new HashMap<String, TrialInfoBuilder.LootData>();
        for (Map.Entry<String, TrialInfoBuilder.LootData> entry : this.rewards.entrySet()) {
            rewardsCopy.put(entry.getKey(), TrialInfoBuilder.LootData.builder().rewards(new ArrayList<String>(entry.getValue().rewards)).chance(entry.getValue().chance).build());
        }
        copy.setRewards(rewardsCopy);
        return copy;
    }

    @Nullable
    public EntityType<?> getEntity(String id) {
        ResourceLocation resourceLocation = new ResourceLocation(id);
        if (ForgeRegistries.ENTITY_TYPES.containsKey(resourceLocation)) {
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
        }
        return null;
    }

    @Nullable
    public Item getItem(String id) {
        ResourceLocation resourceLocation = new ResourceLocation(id);
        if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        }
        return null;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id);
        tag.m_128405_("cooldown", this.cooldown);
        ListTag mobsTag = new ListTag();
        for (Map.Entry<String, List<String>> entry : this.mobs.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("key", entry.getKey());
            ListTag valueTag = new ListTag();
            for (String mob : entry.getValue()) {
                valueTag.add((Object)StringTag.m_129297_((String)mob));
            }
            entryTag.m_128365_("value", (Tag)valueTag);
            mobsTag.add((Object)entryTag);
        }
        tag.m_128365_("mobs", (Tag)mobsTag);
        ListTag rewardsTag = new ListTag();
        for (Map.Entry<String, TrialInfoBuilder.LootData> entry : this.rewards.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("key", entry.getKey());
            entryTag.m_128350_("chance", entry.getValue().chance);
            ListTag valueTag = entry.getValue().getRewards().stream().map(StringTag::m_129297_).collect(Collectors.toCollection(ListTag::new));
            entryTag.m_128365_("value", (Tag)valueTag);
            rewardsTag.add((Object)entryTag);
        }
        tag.m_128365_("rewards", (Tag)rewardsTag);
        return tag;
    }

    public static TrialInfo deserializeNBT(CompoundTag tag) {
        String id = tag.m_128461_("id");
        int cooldown1 = tag.m_128451_("cooldown");
        ListTag mobsTag = tag.m_128437_("mobs", 10);
        HashMap<String, List<String>> mobs = new HashMap<String, List<String>>();
        for (int i = 0; i < mobsTag.size(); ++i) {
            CompoundTag entryTag = mobsTag.m_128728_(i);
            String key = entryTag.m_128461_("key");
            ListTag valueTag = entryTag.m_128437_("value", 8);
            ArrayList<String> values = new ArrayList<String>();
            for (int j = 0; j < valueTag.size(); ++j) {
                values.add(valueTag.m_128778_(j));
            }
            mobs.put(key, values);
        }
        ListTag rewardsTag = tag.m_128437_("rewards", 10);
        HashMap<String, TrialInfoBuilder.LootData> rewards = new HashMap<String, TrialInfoBuilder.LootData>();
        for (int i = 0; i < rewardsTag.size(); ++i) {
            CompoundTag entryTag = rewardsTag.m_128728_(i);
            String key = entryTag.m_128461_("key");
            float chance = entryTag.m_128457_("chance");
            List<String> values = entryTag.m_128437_("value", 8).stream().map(tagElement -> ((StringTag)tagElement).m_7916_()).collect(Collectors.toList());
            rewards.put(key, new TrialInfoBuilder.LootData(chance, values));
        }
        return new TrialInfo(id, cooldown1, mobs, rewards);
    }

    public String getNextMobId(String currentId) {
        ArrayList<String> keys = new ArrayList<String>(this.mobs.keySet());
        int currentIndex = keys.indexOf(currentId);
        if (currentIndex == -1 || currentIndex == keys.size() - 1) {
            return (String)keys.get(0);
        }
        return (String)keys.get(currentIndex + 1);
    }

    public String getCurrentMobId(String currentId) {
        ArrayList<String> keys = new ArrayList<String>(this.mobs.keySet());
        int currentIndex = keys.indexOf(currentId);
        if (currentIndex == -1 || currentIndex == keys.size() - 1) {
            return (String)keys.get(0);
        }
        return (String)keys.get(currentIndex);
    }

    public static TrialInfoBuilder builder() {
        return new TrialInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public Map<String, List<String>> getMobs() {
        return this.mobs;
    }

    public Map<String, TrialInfoBuilder.LootData> getRewards() {
        return this.rewards;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void setMobs(Map<String, List<String>> mobs) {
        this.mobs = mobs;
    }

    public void setRewards(Map<String, TrialInfoBuilder.LootData> rewards) {
        this.rewards = rewards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrialInfo)) {
            return false;
        }
        TrialInfo other = (TrialInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCooldown() != other.getCooldown()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, List<String>> this$mobs = this.getMobs();
        Map<String, List<String>> other$mobs = other.getMobs();
        if (this$mobs == null ? other$mobs != null : !((Object)this$mobs).equals(other$mobs)) {
            return false;
        }
        Map<String, TrialInfoBuilder.LootData> this$rewards = this.getRewards();
        Map<String, TrialInfoBuilder.LootData> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrialInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCooldown();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, List<String>> $mobs = this.getMobs();
        result = result * 59 + ($mobs == null ? 43 : ((Object)$mobs).hashCode());
        Map<String, TrialInfoBuilder.LootData> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        return result;
    }

    public String toString() {
        return "TrialInfo(id=" + this.getId() + ", cooldown=" + this.getCooldown() + ", mobs=" + String.valueOf(this.getMobs()) + ", rewards=" + String.valueOf(this.getRewards()) + ")";
    }

    public TrialInfo(String id, int cooldown, Map<String, List<String>> mobs, Map<String, TrialInfoBuilder.LootData> rewards) {
        this.id = id;
        this.cooldown = cooldown;
        this.mobs = mobs;
        this.rewards = rewards;
    }

    public static class TrialInfoBuilder {
        private int cooldown;
        private String id;
        private Map<String, List<String>> mobs = new HashMap<String, List<String>>();
        private Map<String, LootData> rewards = new HashMap<String, LootData>();

        public TrialInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TrialInfoBuilder addMobs(String category, String ... mobList) {
            this.mobs.put(category, Arrays.stream(mobList).toList());
            return this;
        }

        public TrialInfoBuilder addRewards(String category, float chance, String ... rewardList) {
            this.rewards.put(category, LootData.builder().rewards(Arrays.stream(rewardList).toList()).chance(chance).build());
            return this;
        }

        TrialInfoBuilder() {
        }

        public TrialInfoBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public TrialInfoBuilder mobs(Map<String, List<String>> mobs) {
            this.mobs = mobs;
            return this;
        }

        public TrialInfoBuilder rewards(Map<String, LootData> rewards) {
            this.rewards = rewards;
            return this;
        }

        public TrialInfo build() {
            return new TrialInfo(this.id, this.cooldown, this.mobs, this.rewards);
        }

        public String toString() {
            return "TrialInfo.TrialInfoBuilder(id=" + this.id + ", cooldown=" + this.cooldown + ", mobs=" + String.valueOf(this.mobs) + ", rewards=" + String.valueOf(this.rewards) + ")";
        }

        public static class LootData {
            float chance;
            List<String> rewards;

            LootData(float chance, List<String> rewards) {
                this.chance = chance;
                this.rewards = rewards;
            }

            public static LootDataBuilder builder() {
                return new LootDataBuilder();
            }

            public float getChance() {
                return this.chance;
            }

            public List<String> getRewards() {
                return this.rewards;
            }

            public void setChance(float chance) {
                this.chance = chance;
            }

            public void setRewards(List<String> rewards) {
                this.rewards = rewards;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LootData)) {
                    return false;
                }
                LootData other = (LootData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (Float.compare(this.getChance(), other.getChance()) != 0) {
                    return false;
                }
                List<String> this$rewards = this.getRewards();
                List<String> other$rewards = other.getRewards();
                return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
            }

            protected boolean canEqual(Object other) {
                return other instanceof LootData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Float.floatToIntBits(this.getChance());
                List<String> $rewards = this.getRewards();
                result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
                return result;
            }

            public String toString() {
                return "TrialInfo.TrialInfoBuilder.LootData(chance=" + this.getChance() + ", rewards=" + String.valueOf(this.getRewards()) + ")";
            }

            public static class LootDataBuilder {
                private float chance;
                private List<String> rewards;

                LootDataBuilder() {
                }

                public LootDataBuilder chance(float chance) {
                    this.chance = chance;
                    return this;
                }

                public LootDataBuilder rewards(List<String> rewards) {
                    this.rewards = rewards;
                    return this;
                }

                public LootData build() {
                    return new LootData(this.chance, this.rewards);
                }

                public String toString() {
                    return "TrialInfo.TrialInfoBuilder.LootData.LootDataBuilder(chance=" + this.chance + ", rewards=" + String.valueOf(this.rewards) + ")";
                }
            }
        }
    }
}

