/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.utils;

import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.SpellsCooldown;
import it.mralxart.etheria.magic.spells.SpellsRegistry;
import it.mralxart.etheria.magic.spells.data.EtheriaSpellsData;
import it.mralxart.etheria.magic.spells.data.SpellData;
import it.mralxart.etheria.magic.spells.data.SpellModifier;
import it.mralxart.etheria.magic.spells.data.SpellsData;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.UpdateSpellsCooldownPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SpellsUtils {
    public static List<Spell> getUnlockedSpells(Player player) {
        return CapabilityRegistry.getCap(player).getSpells().values().stream().filter(spell -> spell != null && spell.isUnlock()).collect(Collectors.toList());
    }

    public static List<Spell> getSpells(Player player) {
        return new ArrayList<Spell>(CapabilityRegistry.getCap(player).getSpells().values());
    }

    public static List<Spell> getUnlockedSpellsWithElement(Player player) {
        String playerElement = ElementsUtils.getStringElement(player).toLowerCase();
        return CapabilityRegistry.getCap(player).getSpells().values().stream().filter(spell -> spell != null && spell.isUnlock() && spell.getElement().equals(playerElement)).collect(Collectors.toList());
    }

    public static List<String> getStringSpells(List<Spell> spells) {
        ArrayList<String> list = new ArrayList<String>();
        for (Spell data : spells) {
            list.add(data.getId());
        }
        return list;
    }

    public static List<String> getStringSpells() {
        ArrayList<String> list = new ArrayList<String>();
        for (SpellData data : SpellsRegistry.createSpellsList().getSpells().getSpells().values()) {
            list.add(data.getId());
        }
        return list;
    }

    public static List<SpellData> getDataSpells() {
        EtheriaSpellsData etheriaSpellsData = SpellsRegistry.createSpellsList();
        SpellsData spellsData = etheriaSpellsData.getSpells();
        return new ArrayList<SpellData>(spellsData.getSpells().values());
    }

    public static Map<String, SpellData> getDataSpellsMap() {
        EtheriaSpellsData etheriaSpellsData = SpellsRegistry.createSpellsList();
        SpellsData spellsData = etheriaSpellsData.getSpells();
        HashMap<String, SpellData> data = new HashMap<String, SpellData>();
        for (SpellData i : spellsData.getSpells().values()) {
            data.put(i.getId(), i);
        }
        return data;
    }

    public static String getSpellElement(String spellId) {
        for (SpellData spellData : SpellsUtils.getDataSpells()) {
            if (!spellData.getId().equals(spellId)) continue;
            return spellData.getElement();
        }
        return "";
    }

    public static Spell getSpell(Player player, String spell) {
        return CapabilityRegistry.getCap(player).getSpells().values().stream().filter(spellCooldown -> spellCooldown.getId().equals(spell)).findFirst().orElse(new Spell(spell, 0, false, false, "ether"));
    }

    public static void putSpell(Player player, Spell spell) {
        CapabilityRegistry.getCapability(player).ifPresent(cap -> {
            cap.getSpells().put(spell.getId(), spell);
            SyncCapabilityManager.sync(player);
        });
    }

    public static void unlockSpell(Player player, String spell) {
        Spell spell1 = SpellsUtils.getSpell(player, spell);
        spell1.setUnlock(true);
        SpellsUtils.putSpell(player, spell1);
    }

    public static int getSpellCooldown(Player player, String spell) {
        return CapabilityRegistry.getCap(player).getSpellsCooldown().values().stream().filter(spellCooldown -> spellCooldown.getId().equals(spell)).map(SpellsCooldown::getCooldown).findFirst().orElse(0);
    }

    public static int getSpellCooldownCap(Player player, String spell) {
        return CapabilityRegistry.getCap(player).getSpellsCooldown().values().stream().filter(spellCooldown -> spellCooldown.getId().equals(spell)).map(SpellsCooldown::getCap).findFirst().orElse(0);
    }

    public static int getSpellLevel(Player player, String spell) {
        return CapabilityRegistry.getCap(player).getSpells().values().stream().filter(s -> s.getId().equals(spell)).map(Spell::getLevel).findFirst().orElse(0);
    }

    public static int getRequiredEther(String spell) {
        return SpellsRegistry.createSpellsList().getSpells().getSpells().get(spell).getRequiredEther();
    }

    public static Element getElement(String spell) {
        return Element.valueOf(SpellsUtils.getStringElement(spell).toUpperCase());
    }

    public static String getStringElement(String spell) {
        return SpellsRegistry.createSpellsList().getSpells().getSpells().get(spell).getElement();
    }

    public static float getUpgradeValue(Player player, String spell, String modif) {
        return SpellsUtils.getUpgradeValue(spell, modif, SpellsUtils.getSpellLevel(player, spell));
    }

    public static List<SpellData> getSortedSpells() {
        return SpellsRegistry.createSpellsList().getSpells().getSpells().values().stream().sorted(Comparator.comparing(SpellData::getId)).toList();
    }

    public static int getIntIdSpell(String spell) {
        List<SpellData> sortedSpells = SpellsUtils.getSortedSpells();
        for (int i = 0; i < sortedSpells.size(); ++i) {
            if (!sortedSpells.get(i).getId().equals(spell)) continue;
            return i;
        }
        return -1;
    }

    public static float getUpgradeValue(String spell, String modif, int level) {
        SpellData spellData = SpellsRegistry.createSpellsList().getSpells().getSpells().get(spell);
        if (spellData == null) {
            return 0.0f;
        }
        SpellModifier modifier = spellData.getModifiers().get(modif);
        if (modifier == null) {
            return 0.0f;
        }
        float minValue = ((Float)modifier.getUpgradeValue().getFirst()).floatValue();
        float maxValue = ((Float)modifier.getUpgradeValue().getSecond()).floatValue();
        int maxLevel = spellData.getMaxLevel();
        float progress = (float)level / (float)maxLevel;
        return minValue + progress * (maxValue - minValue);
    }

    public static List<SpellModifier> getModifiers(String spell) {
        if (spell == null || spell.isEmpty()) {
            return new ArrayList<SpellModifier>();
        }
        Map<String, SpellModifier> spellData = SpellsRegistry.createSpellsList().getSpells().getSpells().get(spell).getModifiers();
        ArrayList<SpellModifier> list = new ArrayList<SpellModifier>();
        for (Map.Entry<String, SpellModifier> entry : spellData.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public static List<String> filterByElement(List<String> spellIds, List<Spell> spells, Element element) {
        List<Spell> elementSpells = spells.stream().filter(spell -> spell.getElement().equals(element.name().toLowerCase())).toList();
        ArrayList<String> filteredIds = new ArrayList<String>();
        for (Spell spell2 : elementSpells) {
            if (!spellIds.contains(spell2.getId())) continue;
            filteredIds.add(spell2.getId());
        }
        return filteredIds;
    }

    public static void addSpellCooldown(Player player, String spell, int amount) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.sendToClient(serverPlayer, new UpdateSpellsCooldownPacket(spell, amount));
        }
    }

    public static double getRequiredLvl(String spell) {
        return SpellsRegistry.createSpellsList().getSpells().getSpells().get(spell).getRequiredLevel();
    }

    public static boolean isUnlock(Player player, String index) {
        return SpellsUtils.getSpell(player, index).isUnlock();
    }

    public static boolean isActive(Player player, String index) {
        return SpellsUtils.getSpell(player, index).isActive();
    }

    public static double getMaxLvl(String spell) {
        return SpellsRegistry.createSpellsList().getSpells().getSpells().get(spell).getMaxLevel();
    }

    public static boolean isMaxLevel(Player player, String spell) {
        return (double)SpellsUtils.getSpellLevel(player, spell) >= SpellsUtils.getMaxLvl(spell);
    }

    public static float getArtifactValue(Player player, String spell, String stat) {
        float artifactValue = 0.0f;
        try {
            StatType statType = StatType.valueOf(stat.toUpperCase());
            artifactValue = ArtifactStatCalculator.getStatValue(ArtifactStatsManager.getAllStats(SpellsUtils.getSpell(player, spell).serializeNBT()), statType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return artifactValue;
    }

    public static float getSpellValue(Player player, String spell, String modif) {
        float modifValue = SpellsUtils.getUpgradeValue(player, spell, modif);
        float artifactValue = SpellsUtils.getArtifactValue(player, spell, modif);
        return modifValue + modifValue * artifactValue / 100.0f;
    }
}

