/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.weapon.WeaponAbility;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.WeaponUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SpellWhirlEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(SpellWhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(SpellWhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    public DamageContext context;

    public SpellWhirlEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SpellWhirlEntity(Level level, float damage, String element) {
        super((EntityType)EntityRegistry.SPELL_WHIRL.get(), level);
        this.setDamage(damage);
        this.setElement(element);
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 100) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            AABB box = this.m_20191_().m_82400_(0.2);
            this.m_9236_().m_6443_(LivingEntity.class, box, entity -> !this.hitEntities.contains(entity.m_20148_()) && (this.m_19749_() == null || !this.m_19749_().m_20148_().equals(entity.m_20148_()))).forEach(this::applyDamage);
        }
        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(ElementsUtils.getElement(this.getElement())), 0.3f, 40, 0.9f), this.f_19854_, this.f_19855_, this.f_19856_, 5, 0.025, 0.025, 0.025, 0.05);
        ParticleUtils.drawTriangleWings(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(ElementsUtils.getElement(this.getElement())), 0.3f, 40, 0.025f), (Entity)this, 1.5, 2.0, 10, 0.8f);
    }

    private void applyDamage(LivingEntity target) {
        Entity entity;
        Player player;
        Vec3 projectileMotion;
        Entity playerLook;
        if (target instanceof Player) {
            boolean isBlocking;
            Player player2 = (Player)target;
            boolean bl = isBlocking = player2.m_6117_() && player2.m_21211_().m_150930_(Items.f_42740_);
            if (isBlocking && (playerLook = player2.m_20154_()).m_82526_(projectileMotion = this.m_20184_().m_82541_()) < -0.3) {
                this.m_9236_().m_6263_(null, player2.m_20185_(), player2.m_20186_(), player2.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.1);
                }
                this.m_5602_((Entity)player2);
                this.m_20256_(this.m_20184_().m_82490_(-1.1));
                this.setDamage(this.getDamage() * 1.5f);
                return;
            }
        }
        DamageContext.DamageResult damageResult = this.context != null ? this.context.resolve() : new DamageContext.DamageResult(this.getDamage(), false);
        playerLook = this.m_19749_();
        if (playerLook instanceof Player && (projectileMotion = (player = (Player)playerLook).m_21205_().m_41720_()) instanceof WeaponItem) {
            WeaponItem item = (WeaponItem)projectileMotion;
            int stars = WeaponUtils.getStars(player.m_21205_());
            for (WeaponAbility ability : item.getAdditionalAttribute().getAbilities()) {
                ability.onAttack(player.m_21205_(), target, (LivingEntity)player, stars, item.getAdditionalAttribute());
            }
        }
        if ((entity = this.m_19749_()) instanceof Player) {
            Player player3 = (Player)entity;
            ElementHandler.addElement((LivingEntity)player3, target, Element.ofString(this.getElement()), damageResult.damage(), 200, true, damageResult.isCrit());
            SkillsUtils.addXp(player3, Branches.MAGIC, 2);
        } else {
            ElementHandler.addElement(null, target, Element.ofString(this.getElement()), damageResult.damage(), 200, true, damageResult.isCrit());
        }
        if (target instanceof Aerolith) {
            Aerolith aerolith = (Aerolith)target;
            this.hitEntities.add(target.m_20148_());
            if (aerolith.getShield() > 0) {
                aerolith.setShield(aerolith.getShield() - 2);
                target.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
            } else {
                target.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
            }
        } else if (target.m_6469_(this.m_269291_().m_269425_(), this.getDamage())) {
            this.hitEntities.add(target.m_20148_());
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_280555_()) {
            return;
        }
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_276532_, SoundSource.MASTER, 0.75f, 3.0f);
        this.m_146870_();
    }

    /*
     * Unable to fully structure code
     */
    protected void m_5790_(EntityHitResult result) {
        block10: {
            block9: {
                if (this.m_9236_().m_5776_() || !((var3_2 = result.m_82443_()) instanceof LivingEntity)) break block9;
                entity = (LivingEntity)var3_2;
                if (this.m_19749_() == null || !entity.m_20149_().equals(this.m_19749_().m_20149_())) break block10;
            }
            return;
        }
        mayContinue = false;
        var5_5 = this.m_19749_();
        if (!(var5_5 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var5_5;
        if (result.m_82443_() instanceof Player) {
            if (entity.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)player), this.getDamage())) {
                mayContinue = true;
            }
        } else if (entity.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.getDamage())) {
            mayContinue = true;
        }
        if (mayContinue) {
            ElementHandler.addElement(entity, Element.ofString(this.getElement()), this.getDamage(), 500, true);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ELEMENT, (Object)"CRYO");
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(8.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setElement(tag.m_128461_("element"));
        this.setDamage(tag.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("element", this.getElement());
        tag.m_128350_("damage", this.getDamage());
    }

    public void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public void setElement(String value) {
        this.m_20088_().m_135381_(ELEMENT, (Object)value);
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public String getElement() {
        return (String)this.m_20088_().m_135370_(ELEMENT);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setContext(DamageContext context) {
        this.context = context;
    }
}

