/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.BlockParticleData;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.weapon.WeaponAbility;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.WeaponUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public class SpellEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public DamageContext context;
    public float scale = 1.0f;

    public SpellEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SpellEntity(Level level, float damage, String element) {
        super((EntityType)EntityRegistry.SPELL.get(), level);
        this.setDamage(damage);
        this.setElement(element);
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 100) {
            this.m_146870_();
        }
        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(ElementsUtils.getElement(this.getElement())), 0.45f * this.scale, (int)(40.0f * this.scale), 0.25f), this.f_19854_, this.f_19855_, this.f_19856_, (int)(5.0f * this.scale), 0.025, 0.025, 0.025, 0.02);
        ParticleUtils.createParticle(this.m_9236_(), new BlockParticleData(ElementsUtils.getRandomColorByElement(ElementsUtils.getElement(this.getElement())), 0.1f * this.scale, (int)(25.0f * this.scale), 0.25f), this.f_19854_, this.f_19855_, this.f_19856_, (int)(3.0f * this.scale), 0.025, 0.025, 0.025, 0.03);
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_280555_()) {
            return;
        }
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_276532_, SoundSource.MASTER, 0.75f, 3.0f);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult result) {
        Player player;
        Item item;
        LivingEntity entity;
        block8: {
            block7: {
                Entity entity2;
                if (this.m_9236_().m_5776_() || !((entity2 = result.m_82443_()) instanceof LivingEntity)) break block7;
                entity = (LivingEntity)entity2;
                if (this.m_19749_() == null || !entity.m_20149_().equals(this.m_19749_().m_20149_())) break block8;
            }
            return;
        }
        DamageContext.DamageResult damageResult = this.context != null ? this.context.resolve() : new DamageContext.DamageResult(this.getDamage(), false);
        Entity entity3 = this.m_19749_();
        if (entity3 instanceof Player && (item = (player = (Player)entity3).m_21205_().m_41720_()) instanceof WeaponItem) {
            WeaponItem item2 = (WeaponItem)item;
            int stars = WeaponUtils.getStars(player.m_21205_());
            for (WeaponAbility ability : item2.getAdditionalAttribute().getAbilities()) {
                ability.onAttack(player.m_21205_(), entity, (LivingEntity)player, stars, item2.getAdditionalAttribute());
            }
        }
        if ((entity3 = this.m_19749_()) instanceof Player) {
            player = (Player)entity3;
            ElementHandler.addElement((LivingEntity)player, entity, Element.ofString(this.getElement()), damageResult.damage(), 200, true, damageResult.isCrit());
            SkillsUtils.addXp(player, Branches.MAGIC, 2);
        } else {
            ElementHandler.addElement(null, entity, Element.ofString(this.getElement()), damageResult.damage(), 200, true, damageResult.isCrit());
        }
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ELEMENT, (Object)"CRYO");
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(8.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setElement(tag.m_128461_("element"));
        this.setDamage(tag.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("element", this.getElement());
        tag.m_128350_("damage", this.getDamage());
    }

    public void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public void setElement(String value) {
        this.m_20088_().m_135381_(ELEMENT, (Object)value);
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public String getElement() {
        return (String)this.m_20088_().m_135370_(ELEMENT);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setContext(DamageContext context) {
        this.context = context;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }
}

