/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.entities.ShockwaveEntity;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.base.IAnimatedEntity;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.spells.entities.ScreenShakeEntity;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RenderUtils;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class IcySwordEntity
extends Projectile
implements IAnimatedEntity {
    AnimationController controller = new AnimationController(this);
    private float damage;
    private float duration;
    private int color;
    private boolean isFinish;
    public DamageContext context;
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(IcySwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public void setRadius(float num) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(num));
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public IcySwordEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public IcySwordEntity(Level level, float damage, float radius) {
        super((EntityType)EntityRegistry.ICY_SWORD.get(), level);
        this.setRadius(radius);
        this.damage = damage;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        this.controller.tick();
        this.color = ElementsUtils.getRandomColorByElement(Element.CRYO).getRGB();
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (this.f_19797_ > 160) {
            this.m_146870_();
        }
        if (this.f_19797_ > 62 && this.f_19797_ < 65) {
            ParticleUtils.createParticle(level, new GlowingParticleData(this.color, 0.3f, 40, 0.025f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 40, 0.0, 0.0, 0.0, 0.08f);
            List entities1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)this.getRadius()));
            for (LivingEntity entity1 : entities1) {
                LivingEntity owner;
                if (this.m_19749_() == null || entity1.m_20148_() == this.m_19749_().m_20148_()) continue;
                DamageContext.DamageResult damageResult = this.context != null ? this.context.resolve() : new DamageContext.DamageResult(this.getDamage(), false);
                Entity entity = this.m_19749_();
                ElementHandler.addElement(entity instanceof LivingEntity ? (owner = (LivingEntity)entity) : null, entity1, Element.CRYO, damageResult.damage(), 200, true, damageResult.isCrit());
                ScreenShakeEntity.summonShake(this.m_9236_(), this.m_20182_(), 12.0f, 0.3f, 15, 40);
                ShockwaveEntity shockwave = new ShockwaveEntity(this.m_9236_(), this.m_20182_(), null, 3.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)shockwave);
                double distanceSquared = this.m_20280_((Entity)entity1);
                if (!entity1.m_6084_()) continue;
                double distance = Math.sqrt(distanceSquared);
                double knockbackStrength = 0.8;
                double upwardMotion = 0.5;
                Vec3 motion = entity1.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(knockbackStrength / distance).m_82520_(0.0, upwardMotion, 0.0);
                entity1.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                if (!(entity1 instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)entity1;
                Networking.sendToClient(player, new EntityVelocityPacket(motion.f_82479_, motion.f_82480_, motion.f_82481_));
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.color = compound.m_128451_("color");
        this.duration = compound.m_128457_("duration");
        this.setRadius(compound.m_128457_("radius"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("color", this.color);
        compound.m_128350_("radius", this.getRadius());
        compound.m_128350_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public AnimationController getController() {
        return this.controller;
    }

    @Override
    public Entity getAnimatedEntity() {
        return this;
    }

    public void setController(AnimationController controller) {
        this.controller = controller;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setFinish(boolean isFinish) {
        this.isFinish = isFinish;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getDuration() {
        return this.duration;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public DamageContext getContext() {
        return this.context;
    }

    public void setContext(DamageContext context) {
        this.context = context;
    }

    public static class Render
    extends EntityRenderer<IcySwordEntity> {
        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(@NotNull IcySwordEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
            Map<String, Animation> animations = AnimationStorage.getAnimations(new ResourceLocation("etheria", "animations/icy_sword.animation.json"));
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/icy_sword.geo.json"));
            AnimationController controller = entityIn.getController();
            GeometryChanges changes = controller.apply(partialTicks);
            model.applyAnimChanges(changes);
            controller.startAnimation("idle", animations.get("animation.icy_sword.idle"), LoopMode.ONCE);
            float size = entityIn.getRadius() / 3.0f;
            if (size < 1.0f) {
                size = 1.0f;
            }
            poseStack.m_85836_();
            poseStack.m_85841_(size, size, size);
            RenderType glowingEffect = RenderUtils.getGlowingEffect(this.getTextureLocation(entityIn));
            model.renderModel(poseStack, buffer.m_6299_(glowingEffect), packedLightIn, OverlayTexture.f_118083_, 0.9f);
            Vector3f pos = model.getBone("bone").getWorldPosition(model.getBones());
            pos.add((float)entityIn.m_20182_().f_82479_, (float)entityIn.m_20182_().f_82480_, (float)entityIn.m_20182_().f_82481_);
            if (Minecraft.m_91087_().f_91073_ != null) {
                ParticleUtils.createParticle((Level)Minecraft.m_91087_().f_91073_, new GlowingParticleData(Color.WHITE, 0.3f, 40, 0.025f), pos.x, (double)pos.y + 0.5, pos.z, 5, 0.0, 0.0, 0.0, 0.02f);
            }
            poseStack.m_85849_();
        }

        @NotNull
        public ResourceLocation getTextureLocation(IcySwordEntity entityIn) {
            return new ResourceLocation("etheria", "textures/entity/cryo_sword.png");
        }
    }
}

