/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.BlockParticleData;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class IcySpearEntity
extends ThrowableProjectile {
    private float damage;
    private int color;
    private int duration;
    private DamageContext context;

    public IcySpearEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public IcySpearEntity(Level level, float damage, int color, int duration) {
        super((EntityType)EntityRegistry.ICY_SPEAR.get(), level);
        this.damage = damage;
        this.color = color;
        this.duration = duration;
        this.m_20242_(false);
    }

    public IcySpearEntity(Level level, float damage, int color, int duration, boolean isGravity) {
        super((EntityType)EntityRegistry.ICY_SPEAR.get(), level);
        this.damage = damage;
        this.color = color;
        this.duration = duration;
        this.m_20242_(isGravity);
    }

    public IcySpearEntity(Level level, float damage, int color) {
        super((EntityType)EntityRegistry.ICY_SPEAR.get(), level);
        this.damage = damage;
        this.color = color;
        this.duration = 100;
        this.m_20242_(false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.35f, 30, 0.9f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.0, 0.0, 0.0, 0.01);
            ParticleUtils.createParticle(this.m_9236_(), new BlockParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.1f, 25, 0.25f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.01, 0.01, 0.01, 0.05);
            float radius = 0.4f;
            float angle = (float)this.f_19797_ * 25.0f % 360.0f;
            Vec3 deltaMovement = this.m_20184_().m_82541_();
            Vec3 vec3 = new Vec3(-deltaMovement.f_82481_, 0.0, deltaMovement.f_82479_).m_82541_().m_82490_((double)radius);
            if (vec3.m_82556_() < 0.1) {
                vec3 = new Vec3(0.0, -deltaMovement.f_82481_, deltaMovement.f_82480_).m_82541_().m_82490_((double)radius);
            }
            Vec3 particlePos = this.m_20182_().m_82549_(vec3.m_82524_((float)Math.toRadians(angle)));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 0.0, -0.02, 0.0);
            if (this.f_19797_ % 2 == 0) {
                ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123790_, this.m_20182_(), 1, 0.15, 0.15, 0.15, 0.01);
            }
        }
    }

    public void m_6043_() {
        if (this.f_19797_ > this.duration) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!state.m_280555_()) {
            return;
        }
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.MASTER, 0.75f, 3.0f);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity owner;
        LivingEntity entity;
        block5: {
            block4: {
                Entity entity2;
                if (this.m_9236_().m_5776_() || !((entity2 = result.m_82443_()) instanceof LivingEntity)) break block4;
                entity = (LivingEntity)entity2;
                if (this.m_19749_() == null || !entity.m_20149_().equals(this.m_19749_().m_20149_())) break block5;
            }
            return;
        }
        DamageContext.DamageResult damageResult = this.context != null ? this.context.resolve() : new DamageContext.DamageResult(this.getDamage(), false);
        Entity entity3 = this.m_19749_();
        if (entity3 instanceof Player) {
            Player player = (Player)entity3;
            SkillsUtils.addXp(player, Branches.MAGIC, 2);
        }
        ElementHandler.addElement((entity3 = this.m_19749_()) instanceof LivingEntity ? (owner = (LivingEntity)entity3) : null, entity, Element.CRYO, damageResult.damage(), 200, true, damageResult.isCrit());
    }

    public void onRemovedFromWorld() {
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return;
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 0.8f, 1.5f);
        Vec3 pos = this.m_20182_();
        ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.7f, 25, 0.9f), pos, 25, 0.2, 0.2, 0.2, 0.2);
        ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42201_)), pos, 30, 0.4, 0.4, 0.4, 0.3);
        ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_175821_, pos, 15, 0.3, 0.3, 0.3, 0.05);
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.color = compound.m_128451_("color");
        this.duration = compound.m_128451_("duration");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("color", this.color);
        compound.m_128405_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getDamage() {
        return this.damage;
    }

    public int getColor() {
        return this.color;
    }

    public int getDuration() {
        return this.duration;
    }

    public DamageContext getContext() {
        return this.context;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setContext(DamageContext context) {
        this.context = context;
    }

    public static class Render
    extends EntityRenderer<IcySpearEntity> {
        public Render(EntityRendererProvider.Context renderManager) {
            super(renderManager);
        }

        public void render(IcySpearEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
            GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/icy_spear"));
            poseStack.m_85837_(0.0, -0.2, 0.0);
            double x = entity.m_20184_().m_7096_();
            double y = entity.m_20184_().m_7098_();
            double z = entity.m_20184_().m_7094_();
            double var2 = Math.sqrt(x * x + z * z);
            double atan2 = Math.atan2(x, z);
            double atan = Math.atan2(y, var2);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Math.toDegrees(atan2) + 180.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)Math.toDegrees(atan)));
            model.renderModel(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity))), 0xF000F0, OverlayTexture.f_118083_);
        }

        public ResourceLocation getTextureLocation(@NotNull IcySpearEntity p_114482_) {
            return new ResourceLocation("etheria", "textures/entity/isy_spear.png");
        }
    }
}

