/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.spells.entities.IcySpearEntity;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FrozenOrbitEntity
extends ThrowableProjectile {
    private float damage;
    private float duration;
    private boolean isNegative;
    public DamageContext context;
    private final List<IcySpearEntity> spears = new ArrayList<IcySpearEntity>();
    private final Set<UUID> hitCooldowns = new HashSet<UUID>();

    public FrozenOrbitEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FrozenOrbitEntity(Level level, float damage, int duration) {
        super((EntityType)EntityRegistry.FROZEN_ORBIT.get(), level);
        this.damage = damage;
        this.duration = duration;
        this.m_20242_(true);
    }

    public void m_8119_() {
        block13: {
            block12: {
                super.m_8119_();
                int CREATION_TICKS = 20;
                float ORBIT_RADIUS = 2.5f;
                if (!this.m_9236_().m_5776_()) break block12;
                if (this.f_19797_ <= 20) {
                    double angle;
                    int i;
                    float progress = (float)this.f_19797_ / 20.0f;
                    if (this.f_19797_ == 1) {
                        ParticleUtils.drawAnimatedCylNoUp((ParticleOptions)ParticleTypes.f_175821_, this.m_9236_(), this.m_20182_().m_82492_(0.0, 1.0, 0.0), 0, 3.0);
                        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11736_, SoundSource.BLOCKS, 0.5f, 2.0f);
                    }
                    for (i = 0; i < 3; ++i) {
                        angle = (double)i * 2.0943951023931953;
                        Vec3 groundPos = this.m_20182_().m_82492_(0.0, 1.0, 0.0).m_82520_(Math.cos(angle) * 2.5, 0.0, Math.sin(angle) * 2.5);
                        Vec3 orbitPos = this.m_20182_().m_82520_(Math.cos(angle) * 2.5, 0.0, Math.sin(angle) * 2.5);
                        ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.3f, 10, 0.9f), this.m_9236_(), groundPos, orbitPos, (int)(15.0f * progress), 0.05f, 0.1f);
                    }
                    if (this.f_19797_ == 20) {
                        for (i = 0; i < 3; ++i) {
                            angle = (double)i * 2.0943951023931953;
                            Vec3 spearPos = this.m_20182_().m_82520_(Math.cos(angle) * 2.5, 0.0, Math.sin(angle) * 2.5);
                            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(Color.WHITE, 0.7f, 10, 0.95f), spearPos, 10, 0.1, 0.1, 0.1, 0.05);
                        }
                    }
                }
                if (this.f_19797_ <= 20) break block13;
                ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.5f, 5, 0.95f), this.m_20182_(), 2, 0.1, 0.1, 0.1, 0.0);
                for (IcySpearEntity spear : this.spears) {
                    if (spear == null || spear.m_213877_()) continue;
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.1f, 3, 0.9f), this.m_9236_(), this.m_20182_(), spear.m_20182_(), 5, 0.0f, 0.1f);
                }
                break block13;
            }
            if (this.f_19797_ % 10 == 0) {
                this.hitCooldowns.clear();
            }
            if (this.f_19797_ == 20) {
                double angleOffset = 2.0943951023931953;
                for (int i = 0; i < 3; ++i) {
                    double angle = (double)i * angleOffset;
                    double x = this.m_20185_() + 2.5 * Math.cos(angle);
                    double z = this.m_20189_() + 2.5 * Math.sin(angle);
                    IcySpearEntity spear = new IcySpearEntity(this.m_9236_(), this.damage, ElementsUtils.getRandomColorByElement(Element.CRYO).getRGB(), (int)this.duration, true);
                    spear.m_6034_(x, this.m_20186_(), z);
                    spear.m_5602_(this.m_19749_());
                    spear.setContext(this.context);
                    this.spears.add(spear);
                    this.m_9236_().m_7967_((Entity)spear);
                }
            }
            if (this.f_19797_ > 20) {
                int direction = this.isNegative ? -1 : 1;
                double off = Math.PI * 2 / (double)this.spears.size();
                long time = System.currentTimeMillis();
                double angleSpeed = 0.002;
                double baseAngle = (double)time * angleSpeed;
                for (int i = 0; i < this.spears.size(); ++i) {
                    IcySpearEntity spear = this.spears.get(i);
                    if (spear == null || spear.m_213877_()) continue;
                    double angle = (baseAngle + (double)i * off) * (double)direction;
                    double x = this.m_20185_() + 2.5 * Math.cos(angle);
                    double z = this.m_20189_() + 2.5 * Math.sin(angle);
                    spear.m_6034_(x, this.m_20186_(), z);
                    spear.m_20256_(new Vec3(-Math.sin(angle) * (double)direction, 0.0, Math.cos(angle) * (double)direction).m_82490_(0.1));
                    AABB hitBox = spear.m_20191_().m_82400_(0.5);
                    List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, hitBox, entity -> entity.m_6084_() && (this.m_19749_() == null || !entity.m_20148_().equals(this.m_19749_().m_20148_())));
                    for (LivingEntity target : nearbyEntities) {
                        LivingEntity owner;
                        if (this.hitCooldowns.contains(target.m_20148_())) continue;
                        DamageContext.DamageResult damageResult = this.context != null ? this.context.resolve() : new DamageContext.DamageResult(this.getDamage(), false);
                        Entity entity2 = this.m_19749_();
                        boolean flag = ElementHandler.addElement(entity2 instanceof LivingEntity ? (owner = (LivingEntity)entity2) : null, target, Element.CRYO, damageResult.damage(), 200, true, damageResult.isCrit());
                        if (!flag) continue;
                        this.hitCooldowns.add(target.m_20148_());
                        this.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 2.0f);
                        ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_41980_)), target.m_146892_(), 15, 0.3, 0.3, 0.3, 0.2);
                    }
                }
            }
        }
    }

    protected void m_8097_() {
    }

    public void m_6043_() {
        if ((float)this.f_19797_ > this.duration) {
            this.m_146870_();
            this.spears.forEach(Entity::m_146870_);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.damage = compound.m_128457_("damage");
        this.isNegative = compound.m_128471_("isNegative");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("damage", this.damage);
        compound.m_128379_("isNegative", this.isNegative);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    public void setContext(DamageContext context) {
        this.context = context;
    }
}

