/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ElementalBarrageSpear
extends ThrowableProjectile {
    private static final EntityDataAccessor<String> ELEMENT = SynchedEntityData.m_135353_(ElementalBarrageSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ElementalBarrageSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetUUID;
    private static final int MAX_LIFETIME = 200;

    public ElementalBarrageSpear(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ElementalBarrageSpear(Level level, LivingEntity owner, @Nullable LivingEntity target, Element element, float damage) {
        this((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.ELEMENTAL_BARRAGE_SPEAR.get()), level);
        this.m_5602_((Entity)owner);
        this.target = target;
        if (target != null) {
            this.targetUUID = target.m_20148_();
        }
        this.setElement(element);
        this.setDamage(damage);
        this.m_146884_(owner.m_146892_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_213877_() || this.f_19797_ > 200) {
            this.m_146870_();
            return;
        }
        this.m_20256_(this.m_20184_().m_82490_((double)0.985f));
        if (!this.m_9236_().m_5776_()) {
            Level level;
            if ((this.target == null || !this.target.m_6084_() || this.target.m_213877_()) && this.targetUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
                LivingEntity living;
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entityByUUID = serverLevel.m_8791_(this.targetUUID);
                LivingEntity livingEntity = this.target = entityByUUID instanceof LivingEntity ? (living = (LivingEntity)entityByUUID) : null;
            }
            if (this.target != null) {
                Vec3 targetPos;
                Vec3 currentPos = this.m_20182_();
                if (currentPos.m_82554_(targetPos = this.target.m_146892_()) <= 1.0) {
                    this.target.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.getDamage());
                    this.m_146870_();
                    return;
                }
                Vec3 directionToTarget = targetPos.m_82546_(currentPos).m_82541_();
                Vec3 currentMotion = this.m_20184_();
                double speedVariation = 0.1 + (double)(this.m_19879_() % 10) * 0.1;
                double turnSpeedVariation = 0.1 + (double)(this.m_19879_() % 10) * 0.02;
                Vec3 newMotion = currentMotion.m_165921_(directionToTarget.m_82490_(speedVariation), turnSpeedVariation);
                this.m_20256_(newMotion);
            }
        }
        if (!this.m_9236_().f_46443_) {
            Element particleElement = this.getElement();
            AABB box = this.m_20191_().m_82400_(0.2);
            this.m_9236_().m_6443_(LivingEntity.class, box, entity -> this.m_19749_() == null || !this.m_19749_().m_20148_().equals(entity.m_20148_())).forEach(this::applyDamage);
            ParticleUtils.createParticle(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(particleElement), 0.3f, 40, 0.9f), this.f_19854_, this.f_19855_, this.f_19856_, 3, 0.025, 0.025, 0.025, 0.01);
            ParticleUtils.createParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, this.f_19854_, this.f_19855_, this.f_19856_, 3, 0.025, 0.025, 0.025, 0.01);
        }
    }

    private void applyDamage(LivingEntity target) {
        if (target instanceof Player) {
            Vec3 projectileMotion;
            Vec3 playerLook;
            boolean isBlocking;
            Player player = (Player)target;
            boolean bl = isBlocking = player.m_6117_() && player.m_21211_().m_150930_(Items.f_42740_);
            if (isBlocking && (playerLook = player.m_20154_()).m_82526_(projectileMotion = this.m_20184_().m_82541_()) < -0.3) {
                Entity originalOwner;
                this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.1);
                }
                if ((originalOwner = this.m_19749_()) instanceof LivingEntity) {
                    LivingEntity livingOwner;
                    this.target = livingOwner = (LivingEntity)originalOwner;
                    this.targetUUID = livingOwner.m_20148_();
                }
                this.m_5602_((Entity)player);
                this.m_146870_();
                return;
            }
        }
        DamageSource source = this.m_9236_().m_269111_().m_269425_();
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player playerOwner = (Player)entity;
            source = this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)playerOwner);
        } else {
            entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)entity;
                source = this.m_9236_().m_269111_().m_269333_(livingOwner);
            }
        }
        if (target.m_6469_(source, this.getDamage())) {
            ElementHandler.addElement(target, this.getElement(), this.getDamage(), 200, true);
        }
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult result) {
        Player playerOwner;
        Entity hitEntity = result.m_82443_();
        if (this.m_9236_().f_46443_ || !(hitEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingHitEntity = (LivingEntity)hitEntity;
        if (this.m_19749_() != null && hitEntity.m_20148_().equals(this.m_19749_().m_20148_())) {
            return;
        }
        DamageSource source = this.m_9236_().m_269111_().m_269425_();
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            playerOwner = (Player)entity;
            source = this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)playerOwner);
        } else {
            entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)entity;
                source = this.m_9236_().m_269111_().m_269333_(livingOwner);
            }
        }
        if (livingHitEntity.m_6469_(source, this.getDamage())) {
            ElementHandler.addElement(livingHitEntity, this.getElement(), this.getDamage(), 200, true);
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof Player) {
                playerOwner = (Player)entity2;
                SkillsUtils.addXp(playerOwner, Branches.MAGIC, 2);
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_276532_, this.m_5720_(), 0.7f, 1.5f);
        this.m_146870_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ELEMENT, (Object)Element.CRYO.name());
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(5.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("TargetUUID")) {
            this.targetUUID = tag.m_128342_("TargetUUID");
        }
        this.setElement(Element.valueOf(tag.m_128461_("Element")));
        this.setDamage(tag.m_128457_("Damage"));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.targetUUID != null) {
            tag.m_128362_("TargetUUID", this.targetUUID);
        }
        tag.m_128359_("Element", this.getElement().name());
        tag.m_128350_("Damage", this.getDamage());
    }

    public Element getElement() {
        return Element.valueOf((String)this.f_19804_.m_135370_(ELEMENT));
    }

    public void setElement(Element element) {
        this.f_19804_.m_135381_(ELEMENT, (Object)element.name());
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

