/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells.entities;

import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class BlazinRingEntity
extends Projectile {
    private float heal;
    private float duration;
    private int color;
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(BlazinRingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean isFinish;

    public void setRadius(float num) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(num));
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public BlazinRingEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BlazinRingEntity(Level level, float heal, float radius) {
        super((EntityType)EntityRegistry.BLAZING_RING.get(), level);
        this.setRadius(radius);
        this.heal = heal;
        this.m_20242_(true);
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.color = ElementsUtils.getRandomColorByElement(Element.PYRO).getRGB();
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (this.f_19797_ > 160) {
            this.m_146870_();
            return;
        }
        if (this.m_19749_() != null && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (this.f_19797_ % 20 == 0) {
                entity2.m_5634_(this.heal);
            }
        }
        ParticleUtils.drawParticlesToCenterNoY(new GlowingParticleData(this.color, 0.2f, 20, 0.025f), level, this.m_20182_(), 20, this.getRadius(), 0.8f, 0.5f);
        for (int i = 0; i < 5; ++i) {
            float angle = (float)(Math.PI * 2 * (double)level.f_46441_.m_188501_());
            float radius = this.getRadius();
            float offsetX = (float)(Math.cos(angle) * (double)radius);
            float offsetZ = (float)(Math.sin(angle) * (double)radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(this.color, 0.3f, 20, 0.025f), this.m_20185_() + (double)offsetX, this.m_20186_(), this.m_20189_() + (double)offsetZ, 1, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.heal = compound.m_128457_("heal");
        this.color = compound.m_128451_("color");
        this.duration = compound.m_128457_("duration");
        this.setRadius(compound.m_128457_("radius"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("heal", this.heal);
        compound.m_128405_("color", this.color);
        compound.m_128350_("radius", this.getRadius());
        compound.m_128350_("duration", this.duration);
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setHeal(float heal) {
        this.heal = heal;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setFinish(boolean isFinish) {
        this.isFinish = isFinish;
    }

    public float getHeal() {
        return this.heal;
    }

    public float getDuration() {
        return this.duration;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isFinish() {
        return this.isFinish;
    }
}

