/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells;

import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TickingSpells {
    public static void tick(Player player, String spell) {
        TickingSpells.pyro(player, spell);
        TickingSpells.cryo(player, spell);
    }

    public static void pyro(Player player, String spell) {
        Vec3 target;
        BlockHitResult ray;
        Vec3 eyeVec;
        Vec3 view;
        int maxDistance;
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        Element element = Element.PYRO;
        float radius = SpellsUtils.getSpellValue(player, spell, "radius");
        if (spell.equals("phoenix_rise")) {
            ParticleUtils.drawClientAnimatedCyl(level, player.m_20182_().m_82520_(0.0, 0.5, 0.0), player.f_19797_, radius, ElementsUtils.getRandomColorByElement(element));
        }
        if (spell.equals("fire_rain")) {
            ParticleUtils.drawClientAnimatedCyl(level, player.m_20182_().m_82520_(0.0, 0.5, 0.0), player.f_19797_, radius, ElementsUtils.getRandomColorByElement(element));
        }
        if (spell.equals("flame_explosion")) {
            maxDistance = 16;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            target = ray.m_82450_();
            ParticleUtils.drawClientAnimatedCyl(level, target.m_82520_(0.0, 0.5, 0.0), player.f_19797_, 2.0, ElementsUtils.getRandomColorByElement(element));
        }
        if (spell.equals("fireball")) {
            maxDistance = 32;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            target = ray.m_82450_();
            ParticleUtils.drawClientAnimatedCyl(level, target.m_82520_(0.0, 0.2, 0.0), player.f_19797_, 0.5, ElementsUtils.getRandomColorByElement(element));
        }
    }

    public static void cryo(Player player, String spell) {
        Vec3 target;
        BlockHitResult ray;
        Vec3 eyeVec;
        Vec3 view;
        int maxDistance;
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        Element element = Element.CRYO;
        float radius = SpellsUtils.getSpellValue(player, spell, "radius");
        if (spell.equals("icy_storm")) {
            maxDistance = 16;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            target = ray.m_82450_();
            ParticleUtils.drawClientAnimatedCyl(level, target.m_82520_(0.0, 0.5, 0.0), player.f_19797_, 3.0, ElementsUtils.getRandomColorByElement(element));
        }
        if (spell.equals("frost_explosion")) {
            maxDistance = 16;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            target = ray.m_82450_();
            ParticleUtils.drawClientAnimatedCyl(level, target.m_82520_(0.0, 0.5, 0.0), player.f_19797_, 2.0, ElementsUtils.getRandomColorByElement(element));
        }
        if (spell.equals("frost_shackles")) {
            maxDistance = 16;
            view = player.m_20252_(0.0f);
            eyeVec = player.m_20299_(0.0f);
            ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            target = ray.m_82450_();
            EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyeVec, (Vec3)eyeVec.m_82549_(view.m_82490_((double)maxDistance)), (AABB)new AABB(eyeVec, eyeVec.m_82549_(view.m_82490_((double)maxDistance))), entity -> entity instanceof LivingEntity && !entity.m_5833_(), (double)maxDistance);
            if (entityHitResult != null) {
                ParticleUtils.drawClientAnimatedCyl(level, entityHitResult.m_82450_(), player.f_19797_, radius, ElementsUtils.getRandomColorByElement(element));
            } else {
                ParticleUtils.drawClientAnimatedCyl(level, target.m_82520_(0.0, 0.5, 0.0), player.f_19797_, radius, ElementsUtils.getRandomColorByElement(element));
            }
        }
    }
}

