/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells;

import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.entities.Airflow;
import it.mralxart.etheria.items.CatalystItem;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.spells.entities.BarrageSpearEntity;
import it.mralxart.etheria.magic.spells.entities.BlazinRingEntity;
import it.mralxart.etheria.magic.spells.entities.ElementRain;
import it.mralxart.etheria.magic.spells.entities.ElementalStorm;
import it.mralxart.etheria.magic.spells.entities.Explosion;
import it.mralxart.etheria.magic.spells.entities.FireWhirl;
import it.mralxart.etheria.magic.spells.entities.FrostShackles;
import it.mralxart.etheria.magic.spells.entities.FrozenOrbitEntity;
import it.mralxart.etheria.magic.spells.entities.IcySpearEntity;
import it.mralxart.etheria.magic.spells.entities.IcySwordEntity;
import it.mralxart.etheria.magic.spells.entities.PhoenixRise;
import it.mralxart.etheria.magic.spells.entities.SpellEntity;
import it.mralxart.etheria.magic.spells.entities.SpellWhirlEntity;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.ItemUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SpellsCast {
    public static void cast(ServerPlayer player, String spell) {
        InteractionHand handWithStick = ItemUtils.getHandWithItem(player, (Item)ItemRegistry.MAGIC_STICK.get());
        if (handWithStick == null && !ItemUtils.onHand((Player)player, p -> p instanceof CatalystItem)) {
            return;
        }
        int reqEther = SpellsUtils.getRequiredEther(spell);
        ItemStack etherItem = EtherUtils.findEtherVessel((Player)player, reqEther);
        int etherCount = EtherUtils.getEther(etherItem);
        if (etherCount <= 0 || etherCount < reqEther) {
            player.m_5661_((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.rituals.warn.ether").getString() + ": " + reqEther + ".")), true);
            return;
        }
        EtherUtils.setEther(etherItem, etherCount - reqEther);
        Element element = SpellsUtils.getElement(spell);
        SkillsUtils.addXp((Player)player, Branches.MAGIC, 1);
        switch (element) {
            case CRYO: {
                SpellsCast.castCryo(player, spell);
                break;
            }
            case PYRO: {
                SpellsCast.castPyro(player, spell);
                break;
            }
            case AERO: {
                SpellsCast.castAero(player, spell);
            }
        }
    }

    private static void castAero(ServerPlayer player, String spell) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        float radius = SpellsUtils.getSpellValue((Player)player, spell, "radius");
        float strength = SpellsUtils.getSpellValue((Player)player, spell, "strength");
        int duration = Math.round(SpellsUtils.getSpellValue((Player)player, spell, "duration") * 20.0f) + 1;
        float damage = SpellsUtils.getSpellValue((Player)player, spell, "damage");
        int cooldown = (int)SpellsUtils.getSpellValue((Player)player, spell, "cooldown") * 20;
        Item item = player.m_21205_().m_41720_();
        if (item instanceof CatalystItem) {
            CatalystItem item2 = (CatalystItem)item;
            damage += item2.calculateDamage(player.m_21205_()) * 1.1f;
        }
        DamageContext context = ArtifactStatCalculator.createContext((LivingEntity)player, damage, Element.AERO);
        if (spell.equals("air_blade")) {
            Vec3 lookVector = player.m_20154_();
            int count = (int)SpellsUtils.getSpellValue((Player)player, spell, "count");
            ParticleUtils.createInwardParticleCircle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), 0.3f, 20, 0.2f), player.m_20299_(1.0f), 1.5, 20, 0.1f);
            Vec3 rightVector = lookVector.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            ArrayList<Double> offsets = new ArrayList<Double>();
            offsets.add(0.0);
            if (count >= 2) {
                offsets.add(-1.0);
            }
            if (count >= 3) {
                offsets.add(1.0);
            }
            ParticleUtils.createInwardParticleCircle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), 0.3f, 20, 0.2f), player.m_20299_(1.0f), 1.5, 20, 0.1f);
            Iterator iterator = offsets.iterator();
            while (iterator.hasNext()) {
                double offsetMult = (Double)iterator.next();
                SpellWhirlEntity entity = new SpellWhirlEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPELL_WHIRL.get()), player.m_9236_());
                entity.m_5602_((Entity)player);
                entity.setContext(context);
                entity.setElement("AERO");
                entity.m_20242_(true);
                double spawnX = player.m_20185_() + rightVector.f_82479_ * offsetMult;
                double spawnY = player.m_20186_() + 1.0;
                double spawnZ = player.m_20189_() + rightVector.f_82481_ * offsetMult;
                entity.m_6034_(spawnX, spawnY, spawnZ);
                entity.m_20334_(lookVector.m_82490_((double)1.5).f_82479_, lookVector.m_82490_((double)1.5).f_82480_, lookVector.m_82490_((double)1.5).f_82481_);
                level.m_7967_((Entity)entity);
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, 100 + 30 * count);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12230_, SoundSource.MASTER, 0.5f, 0.5f);
        } else if (spell.equals("air_storm")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            ElementalStorm entity = new ElementalStorm(level, duration, damage, Element.AERO);
            entity.setDuration(duration);
            entity.m_5602_((Entity)player);
            entity.setRadius(3.0f);
            entity.setElement(Element.AERO);
            entity.m_6034_(target.f_82479_, target.f_82480_ + 0.5, target.f_82481_);
            entity.setContext(context);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 2.4));
        } else if (spell.equals("aero_explosion")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.35f, 40, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 60, 0.05f, 0.05f, 0.05f, 0.15f);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 60, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 40, 0.05f, 0.05f, 0.05f, 0.1f);
            Explosion explosion = new Explosion((EntityType<Explosion>)((EntityType)EntityRegistry.EXPLOSION.get()), player.m_9236_(), Element.AERO.name());
            level.m_254849_(null, target.f_82479_, target.f_82480_, target.f_82481_, SpellsUtils.getUpgradeValue((Player)player, spell, "strength"), Level.ExplosionInteraction.NONE);
            explosion.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
            explosion.setOwnerUUID(player.m_20148_());
            explosion.setElement("AERO");
            explosion.setContext(context);
            player.m_9236_().m_7967_((Entity)explosion);
            for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox.m_82400_(3.0))) {
                if (entity.m_20149_().equals(player.m_20149_())) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 254, true, false));
                entity.m_146917_(duration);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12228_, SoundSource.MASTER, 0.5f, 0.5f);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("wind_dash")) {
            float hitRadius = radius > 0.0f ? radius : 2.5f;
            Vec3 look = player.m_20154_();
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12230_, SoundSource.PLAYERS, 2.0f, 1.0f);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12519_, SoundSource.PLAYERS, 0.5f, 2.0f);
            double motionX = look.f_82479_ * (double)strength;
            double motionY = look.f_82480_ * (double)strength;
            double motionZ = look.f_82481_ * (double)strength;
            if (player.m_20096_()) {
                motionY = Math.max(motionY, 0.35);
            }
            player.m_20334_(motionX, motionY, motionZ);
            Networking.sendToClient(player, new EntityVelocityPacket(motionX, motionY, motionZ));
            player.f_19812_ = true;
            player.m_183634_();
            AABB damageBox = player.m_20191_().m_82400_((double)hitRadius);
            List targets = level.m_45976_(LivingEntity.class, damageBox);
            for (LivingEntity target : targets) {
                if (target == player || target.m_7307_((Entity)player)) continue;
                ElementHandler.addElement(target, Element.AERO, context.resolve().damage(), 50, context.resolve().isCrit());
                target.m_147240_(0.5, -look.f_82479_, -look.f_82481_);
            }
            for (int i = 0; i < 20; ++i) {
                double d0 = random.m_188583_() * 0.02;
                double d1 = random.m_188583_() * 0.02;
                double d2 = random.m_188583_() * 0.02;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_() - look.f_82479_ * 0.5 + (random.m_188500_() - 0.5) * 0.5, player.m_20186_() + 0.5 - look.f_82480_ * 0.5 + (random.m_188500_() - 0.5) * 0.5, player.m_20189_() - look.f_82481_ * 0.5 + (random.m_188500_() - 0.5) * 0.5, d0, d1, d2);
            }
            if (!targets.isEmpty()) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + look.f_82479_, player.m_20186_() + 1.0, player.m_20189_() + look.f_82481_, look.f_82479_, look.f_82480_, look.f_82481_);
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, 120);
        } else if (spell.equals("wind_flow")) {
            Airflow airflow = new Airflow((EntityType<? extends Projectile>)((EntityType)EntityRegistry.AIRFLOW.get()), player.m_9236_());
            airflow.m_146884_(player.m_20182_());
            airflow.setLife(duration);
            airflow.setRadius(radius);
            airflow.setLvl((int)strength);
            player.m_9236_().m_7967_((Entity)airflow);
            SpellsUtils.addSpellCooldown((Player)player, spell, 100);
        } else if (spell.equals("sky_crash")) {
            Vec3 currentMove = player.m_20184_();
            player.m_20334_(currentMove.f_82479_ * 0.0, -2.5, currentMove.f_82481_ * 0.0);
            Networking.sendToClient(player, new EntityVelocityPacket(currentMove.f_82479_ * 0.0, -2.5, currentMove.f_82481_ * 0.0));
            player.m_19880_().add("etheria:sky_crashing");
            player.f_19812_ = true;
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11886_, SoundSource.PLAYERS, 2.0f, 0.5f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 0.5f);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        }
    }

    private static void castCryo(ServerPlayer player, String spell) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        float radius = SpellsUtils.getSpellValue((Player)player, spell, "radius");
        int duration = Math.round(SpellsUtils.getSpellValue((Player)player, spell, "duration") * 20.0f) + 1;
        float damage = SpellsUtils.getSpellValue((Player)player, spell, "damage");
        int cooldown = (int)SpellsUtils.getSpellValue((Player)player, spell, "cooldown") * 20;
        Item item = player.m_21205_().m_41720_();
        if (item instanceof CatalystItem) {
            CatalystItem item2 = (CatalystItem)item;
            damage += item2.calculateDamage(player.m_21205_()) * 1.1f;
        }
        DamageContext context = ArtifactStatCalculator.createContext((LivingEntity)player, damage, Element.CRYO);
        if (spell.equals("icy_spear")) {
            Vec3 lookVector = player.m_20154_();
            ParticleUtils.createInwardParticleCircle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.3f, 20, 0.2f), player.m_20299_(1.0f), 1.5, 20, 0.1f);
            ParticleUtils.createInwardParticleCircle(level, (ParticleOptions)ParticleTypes.f_175821_, player.m_20299_(1.0f), 1.5, 15, 0.1f);
            IcySpearEntity entity2 = new IcySpearEntity(level, damage + 2.0f, ElementsUtils.getColorByElement(ElementsUtils.getElement((Player)player)).getRGB());
            entity2.m_5602_((Entity)player);
            entity2.setContext(context);
            entity2.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity2.m_20334_(lookVector.m_82490_((double)1.5).f_82479_, lookVector.m_82490_((double)1.5).f_82480_, lookVector.m_82490_((double)1.5).f_82481_);
            level.m_7967_((Entity)entity2);
            SpellsUtils.addSpellCooldown((Player)player, spell, 160);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_144205_, SoundSource.PLAYERS, 0.5f, 2.0f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_144201_, SoundSource.MASTER, 0.5f, 0.5f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_144244_, SoundSource.MASTER, 0.5f, 0.5f);
        } else if (spell.equals("icy_storm")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            ElementalStorm entity3 = new ElementalStorm(level, duration, damage, Element.CRYO);
            entity3.setDuration(duration);
            entity3.m_5602_((Entity)player);
            entity3.setRadius(3.0f);
            entity3.setElement(Element.CRYO);
            entity3.m_6034_(target.f_82479_, target.f_82480_ + 0.5, target.f_82481_);
            entity3.setContext(context);
            level.m_7967_((Entity)entity3);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 2.4));
        } else if (spell.equals("frost_shackles")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyeVec, (Vec3)eyeVec.m_82549_(view.m_82490_((double)maxDistance)), (AABB)new AABB(eyeVec, eyeVec.m_82549_(view.m_82490_((double)maxDistance))), entity -> entity instanceof LivingEntity && !entity.m_5833_(), (double)maxDistance);
            if (entityHitResult != null) {
                AABB targetBoundingBox = new AABB(entityHitResult.m_82450_().f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
                for (LivingEntity targetEntity : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox)) {
                    if (targetEntity.m_20148_().equals(player.m_20148_())) continue;
                    targetEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 254, true, false));
                    Vec3 position = targetEntity.m_20318_(0.0f);
                    FrostShackles frostShackles = new FrostShackles((EntityType<? extends Projectile>)((EntityType)EntityRegistry.FROST_SHACKLES.get()), player.m_9236_());
                    frostShackles.setLifeTime(duration);
                    frostShackles.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                    frostShackles.m_5602_((Entity)targetEntity);
                    frostShackles.setDamage(damage);
                    frostShackles.setContext(context);
                    frostShackles.setEntity(targetEntity.m_19879_());
                    player.m_9236_().m_7967_((Entity)frostShackles);
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(ElementsUtils.getElement((Player)player)), 0.5f, 40, 0.5f), position.m_7096_(), position.m_7098_(), position.m_7094_(), 40, 0.2, 0.2, 0.2, 0.2f);
                    player.m_9236_().m_5594_(null, targetEntity.m_20183_(), SoundEvents.f_12474_, SoundSource.MASTER, 2.0f, 1.0f + random.m_188501_() * 0.25f);
                }
            } else {
                AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
                for (LivingEntity entity4 : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox)) {
                    if (entity4.m_20148_().equals(player.m_20148_())) continue;
                    entity4.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 254, true, false));
                    Vec3 position = entity4.m_20318_(0.0f);
                    FrostShackles frostShackles = new FrostShackles((EntityType<? extends Projectile>)((EntityType)EntityRegistry.FROST_SHACKLES.get()), player.m_9236_());
                    frostShackles.setLifeTime(duration);
                    frostShackles.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                    frostShackles.m_5602_((Entity)player);
                    frostShackles.setDamage(damage);
                    frostShackles.setEntity(entity4.m_19879_());
                    frostShackles.setContext(context);
                    player.m_9236_().m_7967_((Entity)frostShackles);
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(ElementsUtils.getElement((Player)player)), 0.5f, 40, 0.5f), position.m_7096_(), position.m_7098_(), position.m_7094_(), 40, 0.2, 0.2, 0.2, 0.2f);
                    player.m_9236_().m_5594_(null, entity4.m_20183_(), SoundEvents.f_12474_, SoundSource.MASTER, 2.0f, 1.0f + random.m_188501_() * 0.25f);
                }
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 1.2));
        } else if (spell.equals("frost_explosion")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.35f, 40, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 60, 0.05f, 0.05f, 0.05f, 0.15f);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 60, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 40, 0.05f, 0.05f, 0.05f, 0.1f);
            Explosion explosion = new Explosion((EntityType<Explosion>)((EntityType)EntityRegistry.EXPLOSION.get()), player.m_9236_(), Element.CRYO.name());
            level.m_254849_(null, target.f_82479_, target.f_82480_, target.f_82481_, SpellsUtils.getUpgradeValue((Player)player, spell, "strength"), Level.ExplosionInteraction.NONE);
            explosion.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
            explosion.setOwnerUUID(player.m_20148_());
            explosion.setElement("CRYO");
            explosion.setContext(context);
            player.m_9236_().m_7967_((Entity)explosion);
            for (LivingEntity entity5 : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox.m_82400_(3.0))) {
                if (entity5.m_20149_().equals(player.m_20149_())) continue;
                entity5.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 254, true, false));
                entity5.m_146917_(duration);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12473_, SoundSource.MASTER, 0.5f, 0.5f);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("frozen_orbit")) {
            entity = new FrozenOrbitEntity(level, damage, duration);
            ((FrozenOrbitEntity)((Object)entity)).setDuration(duration);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            ((FrozenOrbitEntity)((Object)entity)).setContext(context);
            level.m_7967_((Entity)entity);
            entity = new FrozenOrbitEntity(level, damage, duration);
            ((FrozenOrbitEntity)((Object)entity)).setDuration(duration);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 0.6, player.m_20189_());
            ((FrozenOrbitEntity)((Object)entity)).setNegative(true);
            ((FrozenOrbitEntity)((Object)entity)).setContext(context);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 2.4));
        } else if (spell.equals("icy_barrage")) {
            for (int i = 0; i < 2; ++i) {
                BarrageSpearEntity entity6 = new BarrageSpearEntity(level, damage);
                entity6.m_5602_((Entity)player);
                entity6.setDuration(200);
                entity6.setContext(context);
                entity6.m_6034_(player.m_20185_() + random.m_188500_(), player.m_20186_() + 1.0, player.m_20189_() + random.m_188500_());
                double offsetX = (random.m_188500_() - 0.5) * 0.5;
                double offsetZ = (random.m_188500_() - 0.5) * 0.5;
                double offsetY = 0.8 + (random.m_188500_() - 0.5) * 0.2;
                entity6.m_20334_(offsetX, offsetY, offsetZ);
                if (entity6.isAddedToWorld()) continue;
                level.m_7967_((Entity)entity6);
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("icy_sword")) {
            entity = new IcySwordEntity(level, damage, radius);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            ((IcySwordEntity)entity).setContext(context);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, 400);
        }
    }

    private static void castPyro(ServerPlayer player, String spell) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        float radius = SpellsUtils.getSpellValue((Player)player, spell, "radius");
        int duration = Math.round(SpellsUtils.getSpellValue((Player)player, spell, "duration") * 20.0f) + 1;
        float damage = SpellsUtils.getSpellValue((Player)player, spell, "damage");
        int cooldown = (int)SpellsUtils.getSpellValue((Player)player, spell, "cooldown") * 20;
        Item item = player.m_21205_().m_41720_();
        if (item instanceof CatalystItem) {
            CatalystItem item2 = (CatalystItem)item;
            damage += item2.calculateDamage(player.m_21205_()) * 1.1f;
        }
        DamageContext context = ArtifactStatCalculator.createContext((LivingEntity)player, damage, Element.PYRO);
        if (spell.equals("fire_rain")) {
            ElementRain rain = new ElementRain((EntityType<? extends Projectile>)((EntityType)EntityRegistry.ELEMENT_RAIN.get()), player.m_9236_());
            Vec3 pos = new Vec3(player.m_20185_(), player.m_20186_() + 18.0, player.m_20189_());
            rain.m_146884_(pos);
            rain.setRadius(radius);
            rain.setLifetime(duration);
            rain.setFrequency((int)Math.round(4.0 - (double)SpellsUtils.getSpellLevel((Player)player, "fire_rain") * 0.7));
            rain.setContext(context);
            rain.m_5602_((Entity)player);
            rain.setElement(Element.PYRO.name().toLowerCase());
            level.m_7967_((Entity)rain);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("fireball")) {
            Vec3 lookVector = player.m_20154_();
            SpellEntity entity = new SpellEntity(level, damage, Element.PYRO.name());
            entity.m_5602_((Entity)player);
            entity.setContext(context);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity.m_20334_(lookVector.f_82479_, lookVector.f_82480_ + (double)0.01f, lookVector.f_82481_);
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, 120);
        } else if (spell.equals("phoenix_rise")) {
            entity = new PhoenixRise(level, damage, radius);
            entity.m_5602_((Entity)player);
            entity.setContext(context);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity.m_5602_((Entity)player);
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("flame_explosion")) {
            int maxDistance = 16;
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)maxDistance, view.f_82480_ * (double)maxDistance, view.f_82481_ * (double)maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            Vec3 target = ray.m_82450_();
            AABB targetBoundingBox = new AABB(target.f_82479_ - (double)radius, target.f_82480_ - (double)radius, target.f_82481_ - (double)radius, target.f_82479_ + (double)radius, target.f_82480_ + (double)radius, target.f_82481_ + (double)radius);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.35f, 40, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 60, 0.05f, 0.05f, 0.05f, 0.15f);
            ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.2f, 60, 0.2f), target.f_82479_, target.f_82480_ + 0.1, target.f_82481_, 40, 0.05f, 0.05f, 0.05f, 0.1f);
            Explosion explosion = new Explosion((EntityType<Explosion>)((EntityType)EntityRegistry.EXPLOSION.get()), player.m_9236_(), Element.PYRO.name());
            level.m_254849_(null, target.f_82479_, target.f_82480_, target.f_82481_, SpellsUtils.getUpgradeValue((Player)player, spell, "strength") / 4.0f, Level.ExplosionInteraction.NONE);
            explosion.m_6034_(target.f_82479_, target.f_82480_, target.f_82481_);
            explosion.setOwnerUUID(player.m_20148_());
            explosion.setElement(Element.PYRO.name());
            explosion.setContext(context);
            player.m_9236_().m_7967_((Entity)explosion);
            for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, targetBoundingBox.m_82400_(3.0))) {
                if (entity.m_20149_().equals(player.m_20149_())) continue;
                entity.m_7311_(140);
            }
            SpellsUtils.addSpellCooldown((Player)player, spell, cooldown);
        } else if (spell.equals("fire_whirl")) {
            entity = new FireWhirl(level, damage, radius);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
            entity.m_20242_(true);
            entity.setContext(context);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 1.5));
        } else if (spell.equals("blazing_ring")) {
            entity = new BlazinRingEntity(level, (int)SpellsUtils.getSpellValue((Player)player, spell, "heal"), radius);
            entity.m_5602_((Entity)player);
            entity.m_6034_(player.m_20185_(), player.m_20186_() + 0.2, player.m_20189_());
            entity.m_20242_(true);
            level.m_7967_((Entity)entity);
            SpellsUtils.addSpellCooldown((Player)player, spell, (int)((double)duration * 1.5));
        }
    }
}

