/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.spells;

import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class Spell
implements INBTSerializable<CompoundTag> {
    @AutoSerialize
    private String id;
    @AutoSerialize
    private int level;
    @AutoSerialize
    private int xp;
    @AutoSerialize
    private boolean unlock;
    @AutoSerialize
    private boolean active;
    @AutoSerialize
    private String element;
    @AutoSerialize
    private String element2;
    public Map<StatType, Float> mainStats;
    public Map<StatType, Float> stats;

    public Spell(String ids, int lvl, boolean purchase, boolean activate, String element) {
        this.id = ids;
        this.level = lvl;
        this.unlock = purchase;
        this.active = activate;
        this.element = element;
        this.element2 = "";
        this.xp = 0;
        this.mainStats = new HashMap<StatType, Float>();
        this.stats = new HashMap<StatType, Float>();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = NbtUtils.serialize(this);
        ListTag mainStatsList = new ListTag();
        for (Map.Entry<StatType, Float> entry : this.mainStats.entrySet()) {
            CompoundTag statTag = new CompoundTag();
            statTag.m_128359_("StatType", entry.getKey().name().toUpperCase());
            statTag.m_128350_("Value", entry.getValue().floatValue());
            mainStatsList.add((Object)statTag);
        }
        nbt.m_128365_("etheria$main_stats", (Tag)mainStatsList);
        ListTag secondaryStatsList = new ListTag();
        for (Map.Entry<StatType, Float> entry : this.stats.entrySet()) {
            CompoundTag statTag = new CompoundTag();
            statTag.m_128359_("StatType", entry.getKey().name().toUpperCase());
            statTag.m_128350_("Value", entry.getValue().floatValue());
            secondaryStatsList.add((Object)statTag);
        }
        nbt.m_128365_("etheria$stats", (Tag)secondaryStatsList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        float value;
        StatType type;
        CompoundTag statTag;
        int i;
        NbtUtils.deserialize(this, nbt);
        if (!this.element.equalsIgnoreCase(SpellsUtils.getElement(this.id).name())) {
            this.element = SpellsUtils.getElement(this.id).name().toLowerCase();
        }
        this.mainStats = new HashMap<StatType, Float>();
        if (nbt.m_128425_("etheria$main_stats", 9)) {
            ListTag mainStatsList = nbt.m_128437_("etheria$main_stats", 10);
            for (i = 0; i < mainStatsList.size(); ++i) {
                statTag = mainStatsList.m_128728_(i);
                type = StatType.valueOf(statTag.m_128461_("StatType").toUpperCase());
                value = statTag.m_128457_("Value");
                this.mainStats.put(type, Float.valueOf(value));
            }
        }
        this.stats = new HashMap<StatType, Float>();
        if (nbt.m_128425_("etheria$stats", 9)) {
            ListTag statsList = nbt.m_128437_("etheria$stats", 10);
            for (i = 0; i < statsList.size(); ++i) {
                statTag = statsList.m_128728_(i);
                type = StatType.valueOf(statTag.m_128461_("StatType").toUpperCase());
                value = statTag.m_128457_("Value");
                this.stats.put(type, Float.valueOf(value));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public int getXp() {
        return this.xp;
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getElement() {
        return this.element;
    }

    public String getElement2() {
        return this.element2;
    }

    public Map<StatType, Float> getMainStats() {
        return this.mainStats;
    }

    public Map<StatType, Float> getStats() {
        return this.stats;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setElement2(String element2) {
        this.element2 = element2;
    }

    public void setMainStats(Map<StatType, Float> mainStats) {
        this.mainStats = mainStats;
    }

    public void setStats(Map<StatType, Float> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Spell)) {
            return false;
        }
        Spell other = (Spell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getXp() != other.getXp()) {
            return false;
        }
        if (this.isUnlock() != other.isUnlock()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$element = this.getElement();
        String other$element = other.getElement();
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        String this$element2 = this.getElement2();
        String other$element2 = other.getElement2();
        if (this$element2 == null ? other$element2 != null : !this$element2.equals(other$element2)) {
            return false;
        }
        Map<StatType, Float> this$mainStats = this.getMainStats();
        Map<StatType, Float> other$mainStats = other.getMainStats();
        if (this$mainStats == null ? other$mainStats != null : !((Object)this$mainStats).equals(other$mainStats)) {
            return false;
        }
        Map<StatType, Float> this$stats = this.getStats();
        Map<StatType, Float> other$stats = other.getStats();
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Spell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getXp();
        result = result * 59 + (this.isUnlock() ? 79 : 97);
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        String $element2 = this.getElement2();
        result = result * 59 + ($element2 == null ? 43 : $element2.hashCode());
        Map<StatType, Float> $mainStats = this.getMainStats();
        result = result * 59 + ($mainStats == null ? 43 : ((Object)$mainStats).hashCode());
        Map<StatType, Float> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "Spell(id=" + this.getId() + ", level=" + this.getLevel() + ", xp=" + this.getXp() + ", unlock=" + this.isUnlock() + ", active=" + this.isActive() + ", element=" + this.getElement() + ", element2=" + this.getElement2() + ", mainStats=" + String.valueOf(this.getMainStats()) + ", stats=" + String.valueOf(this.getStats()) + ")";
    }

    public Spell() {
    }
}

