/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals.utils;

import it.mralxart.etheria.blocks.EtherPedestal;
import it.mralxart.etheria.magic.rituals.Ritual;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.magic.rituals.data.RitualStage;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.SyncTilePacket;
import it.mralxart.etheria.tiles.EtherAltarTile;
import it.mralxart.etheria.tiles.EtherDistributorTile;
import it.mralxart.etheria.tiles.EtherPedestalTile;
import it.mralxart.etheria.tiles.RunicPedestalTile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RitualUtils {
    public static Ritual dataToRitual(RitualData data) {
        Ritual ritual = new Ritual(data.getId(), data.getMainIngredient(), data.getElement(), data.getRitualDifficulty(), data.getIngredients().values().stream().toList(), data.getRequiredEther(), data.getResult(), data.getCrashChance());
        ritual.setRuneItems(data.getRunes().values().stream().toList());
        return ritual;
    }

    public static int countPedestals(Level world, BlockPos centerPos, int radius) {
        int pedestalCount = 0;
        for (int x = centerPos.m_123341_() - radius; x <= centerPos.m_123341_() + radius; ++x) {
            for (int y = centerPos.m_123342_() - radius; y <= centerPos.m_123342_() + radius; ++y) {
                for (int z = centerPos.m_123343_() - radius; z <= centerPos.m_123343_() + radius; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(currentPos);
                    if (!(blockState.m_60734_() instanceof EtherPedestal)) continue;
                    ++pedestalCount;
                }
            }
        }
        return pedestalCount;
    }

    public static ItemStack getItemFromAltar(Level world, BlockPos pedestalPos) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof EtherAltarTile) {
            EtherAltarTile tile = (EtherAltarTile)tileEntity;
            return tile.getStack();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getItemFromPedestal(Level world, BlockPos pedestalPos) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof EtherPedestalTile) {
            return ((EtherPedestalTile)tileEntity).getItemStack();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getRuneFromPedestal(Level world, BlockPos pedestalPos) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof RunicPedestalTile) {
            return ((RunicPedestalTile)tileEntity).getStack();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getCrystalFromPedestal(Level world, BlockPos pedestalPos) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof EtherDistributorTile) {
            return ((EtherDistributorTile)tileEntity).getItemStack();
        }
        return ItemStack.f_41583_;
    }

    public static void throwingItems(Level world, BlockPos pedestalPos) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof EtherPedestalTile) {
            EtherPedestalTile tile = (EtherPedestalTile)tileEntity;
            BlockState oldState = tileEntity.m_58900_();
            ItemStack itemStack = tile.getItemStack();
            tile.setItemStack(ItemStack.f_41583_);
            tileEntity.m_6596_();
            world.m_7260_(pedestalPos, oldState, world.m_8055_(pedestalPos), 3);
            double x = (double)pedestalPos.m_123341_() + 0.5;
            double y = (double)pedestalPos.m_123342_() + 1.0;
            double z = (double)pedestalPos.m_123343_() + 0.5;
            ItemEntity itemEntity = new ItemEntity(world, x, y, z, itemStack.m_41777_());
            itemEntity.m_20334_((world.f_46441_.m_188500_() - 0.5) * 0.2, 0.3 + world.f_46441_.m_188500_() * 0.2, (world.f_46441_.m_188500_() - 0.5) * 0.2);
            world.m_7967_((Entity)itemEntity);
        }
    }

    public static void throwingRunes(Level world, BlockPos pedestalPos) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof RunicPedestalTile) {
            RunicPedestalTile tile = (RunicPedestalTile)tileEntity;
            BlockState oldState = tileEntity.m_58900_();
            ItemStack itemStack = tile.getStack();
            tile.setStack(ItemStack.f_41583_);
            tileEntity.m_6596_();
            world.m_7260_(pedestalPos, oldState, world.m_8055_(pedestalPos), 3);
            double x = (double)pedestalPos.m_123341_() + 0.5;
            double y = (double)pedestalPos.m_123342_() + 1.0;
            double z = (double)pedestalPos.m_123343_() + 0.5;
            ItemEntity itemEntity = new ItemEntity(world, x, y, z, itemStack.m_41777_());
            itemEntity.m_20334_((world.f_46441_.m_188500_() - 0.5) * 0.2, 0.3 + world.f_46441_.m_188500_() * 0.2, (world.f_46441_.m_188500_() - 0.5) * 0.2);
            world.m_7967_((Entity)itemEntity);
        }
    }

    public static void setItemOnPedestal(Level world, BlockPos pedestalPos, ItemStack stack) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof EtherPedestalTile) {
            BlockState oldState = tileEntity.m_58900_();
            ((EtherPedestalTile)tileEntity).setItemStack(stack);
            tileEntity.m_6596_();
            world.m_7260_(pedestalPos, oldState, world.m_8055_(pedestalPos), 3);
            Networking.sendToAll(new SyncTilePacket(tileEntity, true));
        }
    }

    public static void setRuneOnPedestal(Level world, BlockPos pedestalPos, ItemStack stack) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof RunicPedestalTile) {
            BlockState oldState = tileEntity.m_58900_();
            ((RunicPedestalTile)tileEntity).setStack(stack);
            tileEntity.m_6596_();
            world.m_7260_(pedestalPos, oldState, world.m_8055_(pedestalPos), 3);
        }
    }

    public static void setCrystalOnPedestal(Level world, BlockPos pedestalPos, ItemStack stack) {
        BlockEntity tileEntity = world.m_7702_(pedestalPos);
        if (tileEntity instanceof EtherDistributorTile) {
            BlockState oldState = tileEntity.m_58900_();
            ((EtherDistributorTile)tileEntity).setItemStack(stack);
            tileEntity.m_6596_();
            world.m_7260_(pedestalPos, oldState, world.m_8055_(pedestalPos), 3);
        }
    }

    public static Map<BlockPos, ItemStack> filterPedestalsWithItems(Level level, List<BlockPos> pedestalPositions) {
        HashMap<BlockPos, ItemStack> filteredPedestals = new HashMap<BlockPos, ItemStack>();
        for (BlockPos pedestalPos : pedestalPositions) {
            EtherPedestalTile tile;
            ItemStack stack;
            BlockEntity blockEntity = level.m_7702_(pedestalPos);
            if (!(blockEntity instanceof EtherPedestalTile) || (stack = (tile = (EtherPedestalTile)blockEntity).getItemStack()).m_41619_()) continue;
            filteredPedestals.put(pedestalPos, stack.m_41777_());
        }
        return filteredPedestals;
    }

    public static Map<BlockPos, ItemStack> filterCrystalPedestalsWithItems(Level level, List<BlockPos> pedestalPositions) {
        HashMap<BlockPos, ItemStack> filteredPedestals = new HashMap<BlockPos, ItemStack>();
        for (BlockPos pedestalPos : pedestalPositions) {
            EtherDistributorTile tile;
            ItemStack stack;
            BlockEntity blockEntity = level.m_7702_(pedestalPos);
            if (!(blockEntity instanceof EtherDistributorTile) || (stack = (tile = (EtherDistributorTile)blockEntity).getItemStack()).m_41619_()) continue;
            filteredPedestals.put(pedestalPos, stack.m_41777_());
        }
        return filteredPedestals;
    }

    public static RitualStage getCurrentPhase(int tickCount, int totalTicks) {
        int phaseTicks = totalTicks / 8;
        if (tickCount < phaseTicks) {
            return RitualStage.RITUAL_PHASE_1;
        }
        if (tickCount < phaseTicks * 2) {
            return RitualStage.RITUAL_PHASE_2;
        }
        if (tickCount < phaseTicks * 3) {
            return RitualStage.RITUAL_PHASE_3;
        }
        if (tickCount < phaseTicks * 4) {
            return RitualStage.RITUAL_PHASE_4;
        }
        if (tickCount < phaseTicks * 5) {
            return RitualStage.RITUAL_PHASE_5;
        }
        if (tickCount < phaseTicks * 6) {
            return RitualStage.RITUAL_PHASE_6;
        }
        if (tickCount < phaseTicks * 7) {
            return RitualStage.RITUAL_PHASE_7;
        }
        return RitualStage.RITUAL_PHASE_8;
    }
}

