/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals.utils;

import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.blocks.BeamEmitter;
import it.mralxart.etheria.blocks.CryoSealPedestal;
import it.mralxart.etheria.blocks.EtherAltar;
import it.mralxart.etheria.blocks.EtherDistributor;
import it.mralxart.etheria.blocks.EtherPrism;
import it.mralxart.etheria.blocks.PyroSealPedestal;
import it.mralxart.etheria.blocks.RunicPedestal;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.entities.EnigmaCrystal;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.handlers.IceFreezeHandler;
import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.items.base.IEtherPedestal;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.magic.rituals.Ritual;
import it.mralxart.etheria.magic.rituals.RitualRegistry;
import it.mralxart.etheria.magic.rituals.data.RitualDifficulty;
import it.mralxart.etheria.magic.rituals.data.RitualStage;
import it.mralxart.etheria.magic.rituals.events.CrashRitualEvent;
import it.mralxart.etheria.magic.rituals.events.EssenceGenerationEvent;
import it.mralxart.etheria.magic.rituals.events.SplashParticleEvent;
import it.mralxart.etheria.magic.rituals.results.EnigmaResult;
import it.mralxart.etheria.magic.rituals.utils.RitualEventManager;
import it.mralxart.etheria.magic.rituals.utils.RitualUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.ParticleSpawnerPacket;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.tiles.EtherAltarTile;
import it.mralxart.etheria.tiles.EtherDistributorTile;
import it.mralxart.etheria.tiles.EtherPedestalTile;
import it.mralxart.etheria.tiles.EtherPrismTile;
import it.mralxart.etheria.tiles.RunicPedestalTile;
import it.mralxart.etheria.tiles.SealPedestalTile;
import it.mralxart.etheria.utils.BlockUtils;
import it.mralxart.etheria.utils.ColorUtils;
import it.mralxart.etheria.utils.EntityUtils;
import it.mralxart.etheria.utils.EtherUtils;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class RitualManager
implements INBTSerializable<CompoundTag> {
    @Nullable
    private Ritual ritual;
    private ServerLevel level;
    private BlockPos altarPos = new BlockPos(0, 0, 0);
    private int tickCount = 0;
    private int tickPartCount = 0;
    private int tickCountUnlock = 0;
    @AutoSerialize
    private int tickCountEssence = 0;
    private int tickCountCrash = 0;
    @AutoSerialize
    private Element element = Element.ETHER;
    @AutoSerialize
    private Element altarElement = Element.CRYO;
    private Map<EtherPedestalTile, ItemStack> pedestalItems = new HashMap<EtherPedestalTile, ItemStack>();
    private List<BlockPos> sealPedestal = new ArrayList<BlockPos>();
    private List<BlockPos> pedestals = new ArrayList<BlockPos>();
    private List<BlockPos> etherPedestals = new ArrayList<BlockPos>();
    private List<BlockPos> runicPedestals = new ArrayList<BlockPos>();
    private List<Element> actElements = new ArrayList<Element>();
    private List<BlockPos> sealPedestalCache = new ArrayList<BlockPos>();
    private int cacheRefreshCooldown = 0;
    private int etherAmount;
    private float speed;
    private float chance;
    private ArtifactStatCalculator artifacts = new ArtifactStatCalculator();
    @AutoSerialize
    private boolean isActive = false;
    @AutoSerialize
    private boolean isBlocked = false;
    @AutoSerialize
    private boolean isUnlock = false;
    @AutoSerialize
    private boolean isOverload = false;
    private boolean isCrash = false;
    private boolean hasEnigma = false;
    private RitualEventManager eventManager = new RitualEventManager();
    private RitualStage ritualStage = RitualStage.BEFORE_RITUAL;
    private RitualStage previousRitualStage = RitualStage.BEFORE_RITUAL;
    private ServerPlayer player;
    private Map<Integer, Integer> randomSeeds = new HashMap<Integer, Integer>();
    private int maxTime = 500;
    private int tickCount1 = 10;
    private int tickCount2 = 0;
    private int tickAnimCount1 = 10;
    private int tickAnimCount2 = 0;
    private int seed = 0;
    private int seed2 = 0;

    public RitualManager() {
        this.eventManager.registerEvent(new EssenceGenerationEvent(List.of(RitualStage.RITUAL_PHASE_3, RitualStage.RITUAL_PHASE_4, RitualStage.RITUAL_PHASE_5, RitualStage.RITUAL_PHASE_6), RitualStage.AFTER_RITUAL, 0));
        this.eventManager.registerEvent(new SplashParticleEvent(List.of(RitualStage.RITUAL_PHASE_2, RitualStage.RITUAL_PHASE_4, RitualStage.RITUAL_PHASE_6, RitualStage.RITUAL_PHASE_8), RitualStage.AFTER_RITUAL, 0));
        this.eventManager.registerEvent(new CrashRitualEvent(List.of(RitualStage.RITUAL_PHASE_3, RitualStage.RITUAL_PHASE_5), RitualStage.AFTER_RITUAL, 0));
    }

    public String startRitual(ServerPlayer player) {
        if (this.ritual != null && this.etherAmount >= this.ritual.getEtherAmount() && !this.ritual.isActive()) {
            if (!this.hasStartRitual()) {
                return "";
            }
            this.ritual.setActive(true);
            this.isActive = true;
            this.player = player;
            for (int i = 0; i < 16; ++i) {
                this.randomSeeds.put(i, new Random().nextInt(1, 20));
            }
            return "";
        }
        if (this.ritual == null) {
            return Component.m_237115_((String)"etheria.rituals.warn.recognized").getString();
        }
        if (this.etherAmount < this.ritual.getEtherAmount()) {
            return Component.m_237115_((String)"etheria.rituals.warn.ether").getString();
        }
        return "";
    }

    public void tick(Level level, BlockPos posAltar, int tickCountTile) {
        BlockEntity blockEntity;
        EtherPedestalTile blockEntity2;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.level = serverLevel;
            this.altarPos = posAltar;
        }
        if (level.f_46443_ && tickCountTile % 10 == 0) {
            for (BlockPos blockPos : BlockUtils.findBlocks(level, posAltar, 4, IEtherPedestal.class).stream().toList()) {
                BlockEntity blockEntity3 = level.m_7702_(blockPos);
                if (!(blockEntity3 instanceof EtherPedestalTile)) continue;
                blockEntity2 = (EtherPedestalTile)blockEntity3;
                blockEntity2.setBlocked(this.isBlocked);
                blockEntity2.setProgress(this.tickCountUnlock);
            }
        }
        ++this.tickPartCount;
        if (this.randomSeeds.isEmpty()) {
            for (int i = 0; i < 16; ++i) {
                this.randomSeeds.put(i, new Random().nextInt(1, 20));
            }
        }
        if ((blockEntity = level.m_7702_(posAltar)) instanceof EtherAltarTile) {
            EtherAltarTile tile = (EtherAltarTile)blockEntity;
            this.altarElement = tile.getElement();
        }
        boolean bl = this.hasEnigma = !EntityUtils.findEntitiesByClass(level, EnigmaCrystal.class, this.altarPos.m_252807_().m_82520_(0.0, 4.0, 0.0), 3.0).isEmpty();
        if (this.isBlocked) {
            if (this.cacheRefreshCooldown > 0) {
                --this.cacheRefreshCooldown;
            }
            if (this.cacheRefreshCooldown <= 0) {
                this.cacheRefreshCooldown = 100;
                if (this.altarElement.equals((Object)Element.CRYO)) {
                    this.sealPedestalCache = BlockUtils.findBlocks(level, posAltar, 10, CryoSealPedestal.class);
                } else if (this.altarElement.equals((Object)Element.PYRO)) {
                    this.sealPedestalCache = BlockUtils.findBlocks(level, posAltar, 15, PyroSealPedestal.class);
                } else {
                    this.sealPedestalCache.clear();
                }
                this.sealPedestal = this.sealPedestalCache;
            }
            if (this.altarElement.equals((Object)Element.CRYO)) {
                boolean hasFireSeal = false;
                for (BlockPos pos3 : this.sealPedestal) {
                    BlockEntity blockEntity4 = level.m_7702_(pos3);
                    if (!(blockEntity4 instanceof SealPedestalTile) || (itemStack = (sealPedestalTile = (SealPedestalTile)blockEntity4).getItemStack()).m_41619_()) continue;
                    if (itemStack.m_41720_() == ItemRegistry.FIRE_SEAL.get()) {
                        hasFireSeal = true;
                    }
                    if (!hasFireSeal) continue;
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.3f, 100, 0.2f), level, pos3.m_252807_().m_82520_(0.0, 0.8, 0.0), posAltar.m_252807_(), 1, 1.0f);
                }
                if (hasFireSeal && this.isBlocked && !this.isUnlock) {
                    this.setUnlock(true);
                }
            } else if (this.altarElement.equals((Object)Element.PYRO)) {
                boolean hasFrostHeart = false;
                for (BlockPos pos : this.sealPedestal) {
                    itemStack = level.m_7702_(pos);
                    if (!(itemStack instanceof SealPedestalTile) || (itemStack = (sealPedestalTile = (SealPedestalTile)itemStack).getItemStack()).m_41619_()) continue;
                    if (itemStack.m_41720_() == ItemRegistry.FROST_HEART.get()) {
                        hasFrostHeart = true;
                    }
                    if (!hasFrostHeart) continue;
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.3f, 240, 0.2f), level, pos.m_252807_().m_82520_(0.0, 9.1, 0.0), posAltar.m_252807_(), 1, 1.2f);
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.2f, 40, 0.2f), level, pos.m_252807_().m_82520_(0.0, 0.2, 0.0), pos.m_252807_().m_82520_(0.0, 0.7, 0.0), 1, 1.2f);
                }
                if (hasFrostHeart && this.isBlocked && !this.isUnlock) {
                    this.setUnlock(true);
                }
            }
        }
        if (this.level != null) {
            if (tickCountTile % 14 == 0) {
                this.runicPedestals = BlockUtils.findBlocks(level, this.altarPos, 4, RunicPedestal.class);
                this.etherPedestals = BlockUtils.findBlocks(level, this.altarPos, 4, EtherDistributor.class);
                this.pedestals = BlockUtils.findBlocks(level, this.altarPos, 4, IEtherPedestal.class);
                Optional optionalBlockPos = this.etherPedestals.stream().findFirst();
                if (optionalBlockPos.isPresent()) {
                    this.etherPedestals = new ArrayList<BlockPos>();
                    this.etherPedestals.add((BlockPos)optionalBlockPos.get());
                }
            }
            for (BlockPos blockPos : this.pedestals.stream().toList()) {
                BlockEntity sealPedestalTile = level.m_7702_(blockPos);
                if (!(sealPedestalTile instanceof EtherPedestalTile)) continue;
                blockEntity2 = (EtherPedestalTile)sealPedestalTile;
                blockEntity2.setBlocked(this.isBlocked);
                if (this.isBlocked && this.altarElement.equals((Object)Element.PYRO)) {
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.2f, 20, 0.25f), level, blockPos.m_252807_().m_82520_(0.0, 0.3, 0.0), blockPos.m_252807_().m_82520_(0.0, 0.8, 0.0), 1, 0.5f);
                    float yOffset = Mth.m_14031_((float)((float)Math.toRadians(this.tickPartCount))) * 0.3f;
                    ParticleUtils.drawAnimatedCyl(level, blockPos.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickPartCount, 0.6, ElementsUtils.getColorByElement(Element.PYRO));
                }
                if (this.isUnlock) {
                    if (!this.altarElement.equals((Object)Element.CRYO)) continue;
                    blockEntity2.setProgress(this.tickCountUnlock);
                    float yOffset = Mth.m_14031_((float)((float)Math.toRadians(this.tickCountUnlock)));
                    ParticleUtils.drawAnimatedCyl(level, blockPos.m_252807_().m_82520_(0.0, 0.0, 0.0), this.tickCountUnlock, yOffset, ElementsUtils.getColorByElement(Element.PYRO));
                    continue;
                }
                this.reloadPedestalItems(blockEntity2, blockEntity2.getItemStack());
            }
            this.checkRituals();
            if (this.isBlocked && this.altarElement.equals((Object)Element.PYRO)) {
                ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.PYRO), 0.2f, 20, 0.25f), level, this.altarPos.m_252807_().m_82520_(0.0, 0.3, 0.0), this.altarPos.m_252807_().m_82520_(0.0, 0.8, 0.0), 1, 0.5f);
                float yOffset = Mth.m_14031_((float)((float)Math.toRadians(this.tickPartCount))) * 0.3f;
                ParticleUtils.drawAnimatedCyl(level, this.altarPos.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickPartCount, 0.6, ElementsUtils.getRandomColorByElement(Element.PYRO));
            } else if (this.isBlocked && this.altarElement.equals((Object)Element.AERO)) {
                ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), 0.2f, 20, 0.25f), level, this.altarPos.m_252807_().m_82520_(0.0, 0.3, 0.0), this.altarPos.m_252807_().m_82520_(0.0, 0.8, 0.0), 1, 0.05f);
                float yOffset = Mth.m_14031_((float)((float)Math.toRadians(this.tickPartCount))) * 0.3f;
                ParticleUtils.drawAnimatedCyl(level, this.altarPos.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickPartCount, 0.6, ElementsUtils.getRandomColorByElement(Element.AERO));
                for (BlockPos pos : this.pedestals) {
                    ParticleUtils.createWavyLine(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), 0.1f, 2, 0.002f), this.altarPos.m_252807_().m_82520_(0.0, -0.45, 0.0), pos.m_252807_().m_82520_(0.0, -0.45, 0.0), 1, 0, 10.0, 0.05f, this.seed, false);
                    ParticleUtils.drawAnimatedCyl(level, pos.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickCountUnlock, 0.5, ElementsUtils.getColorByElement(this.altarElement));
                }
            }
            if (this.isUnlock) {
                float yOffset = Mth.m_14031_((float)((float)Math.toRadians(this.tickCountUnlock))) * 0.03f;
                ParticleUtils.drawAnimatedCyl(level, posAltar.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickCountUnlock, 0.6, ElementsUtils.getColorByElement(this.altarElement));
            }
            this.checkCrystals();
        }
        if (this.isUnlock) {
            ++this.tickCountUnlock;
            if (this.altarElement.equals((Object)Element.PYRO)) {
                float yOffset = Mth.m_14031_((float)((float)Math.toRadians(this.tickCountUnlock) * 1.5f)) * 0.5f;
                ParticleUtils.drawAnimatedCyl(level, posAltar.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickCountUnlock, 0.8, ElementsUtils.getColorByElement(Element.CRYO));
                for (BlockPos pos : this.pedestals.stream().toList()) {
                    ParticleUtils.drawAnimatedCyl(level, pos.m_252807_().m_82520_(0.0, (double)yOffset, 0.0), this.tickCountUnlock, 0.7, ElementsUtils.getColorByElement(Element.CRYO));
                }
            }
            if (this.tickCountUnlock > 500) {
                this.setUnlock(false);
                this.setBlocked(false);
                for (BlockPos blockPos : this.pedestals.stream().toList()) {
                    if (this.altarElement.equals((Object)Element.PYRO)) {
                        ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.CRYO), 0.3f, 80, 0.25f), level, blockPos.m_252807_().m_82520_(0.0, -0.5, 0.0), blockPos.m_252807_().m_82520_(0.0, 1.0, 0.0), 40, 1.0f);
                    }
                    if (this.altarElement.equals((Object)Element.AERO)) {
                        ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), 0.3f, 80, 0.25f), level, blockPos.m_252807_().m_82520_(0.0, -0.5, 0.0), blockPos.m_252807_().m_82520_(0.0, 1.0, 0.0), 40, 1.0f);
                    }
                    if (!this.altarElement.equals((Object)Element.CRYO)) continue;
                    ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.PYRO), 0.3f, 80, 0.25f), level, blockPos.m_252807_().m_82520_(0.0, -0.5, 0.0), blockPos.m_252807_().m_82520_(0.0, 1.0, 0.0), 40, 1.0f);
                }
                if (this.altarElement.equals((Object)Element.PYRO)) {
                    IceFreezeHandler.start(level, this.altarPos.m_7495_(), blockState -> blockState.m_60734_() instanceof EtherAltar || blockState.m_60734_() instanceof IEtherPedestal || blockState.m_60734_() instanceof RunicPedestal || blockState.m_60734_() instanceof EtherDistributor, 5);
                    for (BlockPos blockPos : this.sealPedestal) {
                        IceFreezeHandler.start(level, blockPos.m_7495_(), blockState -> blockState.m_60734_() instanceof EtherAltar || blockState.m_60734_() instanceof IEtherPedestal || blockState.m_60734_() instanceof RunicPedestal || blockState.m_60734_() instanceof EtherDistributor, 4);
                    }
                    for (BlockPos blockPos : this.sealPedestal) {
                        BlockEntity yOffset = level.m_7702_(blockPos);
                        if (!(yOffset instanceof SealPedestalTile)) continue;
                        sealPedestalTile = (SealPedestalTile)yOffset;
                        sealPedestalTile.setItemStack(ItemStack.f_41583_);
                    }
                } else if (this.altarElement.equals((Object)Element.CRYO)) {
                    for (BlockPos blockPos : this.sealPedestal) {
                        BlockEntity yOffset = level.m_7702_(blockPos);
                        if (!(yOffset instanceof SealPedestalTile)) continue;
                        sealPedestalTile = (SealPedestalTile)yOffset;
                        sealPedestalTile.setItemStack(ItemStack.f_41583_);
                    }
                } else if (this.altarElement.equals((Object)Element.AERO)) {
                    IceFreezeHandler.start(level, this.altarPos.m_7495_(), blockState -> false, 40, Blocks.f_50069_.m_49966_(), Color.GRAY);
                    List<BlockPos> poses = BlockUtils.findBlocks(level, this.altarPos, 20, BeamEmitter.class);
                    for (BlockPos pos : poses) {
                        IceFreezeHandler.start(level, pos.m_7495_(), blockState -> false, 40, Blocks.f_50069_.m_49966_(), Color.GRAY);
                    }
                }
            }
        } else if (this.tickCountUnlock > 0) {
            this.tickCountUnlock -= 4;
        }
        if (!this.isActive) {
            this.tickCountEssence = 0;
            this.isCrash = false;
            if (this.ritual != null) {
                if (!this.hasStartRitual()) {
                    return;
                }
                ParticleUtils.drawAnimatedCyl(level, this.altarPos.m_252807_(), this.tickPartCount, 1.0, new Color(this.getEtherColor()));
            }
            return;
        }
        if (this.ritual != null) {
            Object posCenter;
            this.element = this.ritual.getElement();
            this.speed = switch (this.ritual.getRitualDifficulty()) {
                default -> throw new IncompatibleClassChangeError();
                case RitualDifficulty.EASY -> 1.0f;
                case RitualDifficulty.BASIC -> 2.0f;
                case RitualDifficulty.ELEMENTARY -> 4.0f;
                case RitualDifficulty.ADVANCED -> 7.0f;
            };
            switch (this.ritual.getRitualDifficulty()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case EASY: {
                    float f = 0.93f;
                    break;
                }
                case BASIC: {
                    float f = 0.84f;
                    break;
                }
                case ELEMENTARY: {
                    float f = 0.78f;
                    break;
                }
                case ADVANCED: {
                    float f = this.chance = 0.7f;
                }
            }
            if (this.isHasEnigma()) {
                this.chance -= 0.1f;
            }
            ++this.tickCount;
            this.ritualStage = RitualUtils.getCurrentPhase(this.tickCount, (int)((float)this.getMaxTime() * this.speed));
            if (this.previousRitualStage != this.ritualStage) {
                this.eventManager.executeStage(this.ritualStage, this);
                this.previousRitualStage = this.ritualStage;
            }
            this.eventManager.tickEvents(this);
            float smoothTick = (float)(this.tickCount % 300) + (float)(this.tickCount % 300) / 300.0f;
            ParticleUtils.drawAnimatedCylNoUp(level, this.altarPos.m_252807_(), (int)smoothTick, 4.0 * ((double)this.speed * 0.1), new Color(this.getEtherColor()));
            float f = (float)this.tickCount / 500.0f;
            ArrayList<BlockPos> pedestalList = new ArrayList<BlockPos>(RitualUtils.filterPedestalsWithItems(level, this.pedestals).keySet());
            for (int index = 0; index < pedestalList.size(); ++index) {
                BlockPos pos4 = (BlockPos)pedestalList.get(index);
                if (this.randomSeeds.isEmpty()) break;
                int seed = this.randomSeeds.get(index % this.randomSeeds.size());
                if (this.tickCountEssence <= 0 || this.tickCountEssence >= 402) continue;
                long time = System.currentTimeMillis();
                float angle = (float)(time % 3600L) / 10.0f;
                float yOffset = Mth.m_14031_((float)((float)Math.toRadians(angle))) * 0.09f;
                boolean finish = this.tickCountEssence > 400;
                ParticleUtils.createWavyLine(level, new GlowingParticleData(this.getEtherColor(), 0.1f, finish ? 15 : 2, 0.002f, !finish), pos4.m_252807_(), this.altarPos.m_252807_().m_82520_(0.0, 1.2 + (double)yOffset, 0.0), this.tickCountEssence, (int)(200.0 - (double)seed * 0.5), (double)(finish ? 20 : 50) + (double)seed * 0.1, (double)0.2f + (double)seed * 0.002, seed, finish);
            }
            List<BlockPos> orderedPedestals = RitualManager.orderPedestalsSequentially(pedestalList);
            for (int i = 0; i < orderedPedestals.size(); ++i) {
                BlockPos current = orderedPedestals.get(i);
                BlockPos next = orderedPedestals.get((i + 1) % orderedPedestals.size());
                ParticleUtils.createWavyLine(level, new GlowingParticleData(this.getEtherColor(), 0.1f, 4, 0.002f), current.m_252807_().m_82520_(0.0, -0.45, 0.0), next.m_252807_().m_82520_(0.0, -0.45, 0.0), 1, 0, 20.0, 0.05f, this.seed, false);
            }
            for (BlockPos pos5 : RitualUtils.filterCrystalPedestalsWithItems(level, this.etherPedestals).keySet()) {
                ItemStack stack = RitualUtils.filterCrystalPedestalsWithItems(level, this.etherPedestals).get(pos5);
                if (!(stack.m_41720_() instanceof IEtherEntryItem)) continue;
                posCenter = pos5.m_252807_().m_82520_(0.0, 0.5, 0.0);
                ++this.tickCount1;
                if (this.tickCount1 >= 30) {
                    this.tickCount1 = 0;
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.3f, 10 + level.f_46441_.m_216339_(5, 10), 0.002f), ((Vec3)posCenter).f_82479_, ((Vec3)posCenter).f_82480_, ((Vec3)posCenter).f_82481_, 10, 0.02, 0.02, 0.02, 0.005f);
                }
                ++this.tickCount2;
                if (this.tickCount2 >= 30) {
                    this.tickCount2 = 0;
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.ETHER), 0.3f, 10 + level.f_46441_.m_216339_(5, 10), 0.002f), ((Vec3)posCenter).f_82479_, ((Vec3)posCenter).f_82480_, ((Vec3)posCenter).f_82481_, 10, 0.02, 0.02, 0.02, 0.005f);
                }
                if (this.tickCount1 == this.tickCount2) {
                    this.tickCount1 += 16;
                }
                if (this.tickCount1 % 30 == 0) {
                    this.seed = this.randomSeeds.get(new Random().nextInt(this.randomSeeds.size()));
                }
                if (this.tickCount2 % 30 == 0) {
                    this.seed2 = this.randomSeeds.get(new Random().nextInt(this.randomSeeds.size()));
                }
                ParticleUtils.createWavyLine(level, new GlowingParticleData(this.getEtherColor(), 0.1f, 3, 0.002f), (Vec3)posCenter, this.altarPos.m_252807_().m_82520_(0.0, 0.5, 0.0), this.tickCount1, 25, 50.0, (double)0.2f - (double)this.seed * 0.01, this.seed, false);
                ParticleUtils.createWavyLine(level, new GlowingParticleData(this.getEtherColor(), 0.1f, 3, 0.002f), (Vec3)posCenter, this.altarPos.m_252807_().m_82520_(0.0, 0.5, 0.0), this.tickCount2, 25, 50.0, (double)-0.2f + (double)this.seed2 * 0.01, this.seed2, false);
            }
            if (this.hasEnigma) {
                Vec3 posCenter2 = this.altarPos.m_252807_().m_82520_(0.0, 5.0, 0.0);
                ++this.tickAnimCount1;
                if (this.tickAnimCount1 >= 20) {
                    this.tickAnimCount1 = 0;
                    ParticleUtils.createParticle(level, new GlowingParticleData(EnigmaUtils.getEnigmaStartColor(this.tickCount), 0.3f, 10 + level.f_46441_.m_216339_(5, 10), 0.002f), posCenter2.f_82479_, posCenter2.f_82480_, posCenter2.f_82481_, 10, 0.02, 0.02, 0.02, 0.005f);
                }
                ++this.tickAnimCount2;
                if (this.tickAnimCount2 >= 20) {
                    this.tickAnimCount2 = 0;
                    ParticleUtils.createParticle(level, new GlowingParticleData(EnigmaUtils.getEnigmaEndColor(this.tickCount), 0.3f, 10 + level.f_46441_.m_216339_(5, 10), 0.002f), posCenter2.f_82479_, posCenter2.f_82480_, posCenter2.f_82481_, 10, 0.02, 0.02, 0.02, 0.005f);
                }
                if (this.tickAnimCount1 == this.tickAnimCount2) {
                    this.tickAnimCount1 += 10;
                }
                ParticleUtils.createBentLine(level, new GlowingParticleData(EnigmaUtils.getEnigmaStartColor(this.tickCount), 0.1f, 3, 0.002f), posCenter2, this.altarPos.m_252807_().m_82520_(0.0, 0.5, 0.0), this.tickAnimCount1, 15, 50.0, (double)0.6f - (double)this.seed * 0.03, 10, this.seed, false);
                ParticleUtils.createBentLine(level, new GlowingParticleData(EnigmaUtils.getEnigmaEndColor(this.tickCount), 0.1f, 3, 0.002f), posCenter2, this.altarPos.m_252807_().m_82520_(0.0, 0.5, 0.0), this.tickAnimCount2, 15, 50.0, (double)-0.6f + (double)this.seed2 * 0.03, 10, this.seed2, false);
            }
            for (BlockPos pos6 : BlockUtils.findBlocks(level, posAltar, 4, EtherPrism.class).stream().toList()) {
                posCenter = level.m_7702_(pos6);
                if (!(posCenter instanceof EtherPrismTile)) continue;
                EtherPrismTile blockEntity4 = (EtherPrismTile)posCenter;
                this.artifacts.updateStats(blockEntity4.getItemStacks());
                this.artifacts.updateElements(blockEntity4.getItemStacks());
                for (Element element : this.artifacts.getElements().values()) {
                    ParticleUtils.createParticle(level, new GlowingParticleData(ElementsUtils.getColorByElement(element), 0.3f, 20 + level.f_46441_.m_216339_(10, 14), 0.002f), (double)pos6.m_123341_() + 0.5, (double)pos6.m_123342_() + 0.65, (double)pos6.m_123343_() + 0.5, 1, 0.2, 0.2, 0.2, 0.005f);
                }
            }
            for (BlockPos pos7 : this.pedestals.stream().toList()) {
                posCenter = level.m_7702_(pos7);
                if (!(posCenter instanceof EtherPedestalTile)) continue;
                EtherPedestalTile blockEntity5 = (EtherPedestalTile)posCenter;
                BlockState state = blockEntity5.m_58900_();
                blockEntity5.setProgress(f);
                blockEntity5.m_6596_();
                level.m_7260_(pos7, state, level.m_8055_(pos7), 3);
            }
            for (BlockPos pos8 : this.runicPedestals.stream().toList()) {
                RunicPedestalTile tile;
                BlockEntity state = level.m_7702_(pos8);
                if (!(state instanceof RunicPedestalTile) || (tile = (RunicPedestalTile)state).getStack().m_41619_()) continue;
                long time = System.currentTimeMillis();
                float angle = (float)(time % 3600L) / 10.0f;
                float yOffset = Mth.m_14031_((float)((float)Math.toRadians(angle))) * 0.05f;
                ParticleUtils.drawAnimatedCyl(level, pos8.m_252807_().m_82520_(0.0, 0.5 + (double)yOffset, 0.0), (int)smoothTick, 0.2f, new Color(this.getEtherColor()));
            }
            if (!this.validateAltarItem(this.ritual)) {
                this.stopRitual(this.ritual);
            } else if (!this.validateIngredients(this.ritual)) {
                this.stopRitual(this.ritual);
            } else if (!this.validateRunes(this.ritual)) {
                this.stopRitual(this.ritual);
            } else if (this.etherAmount < this.ritual.getEtherAmount()) {
                this.stopRitual(this.ritual);
            }
            float baseTick = (float)this.getMaxTime() * this.speed;
            float finalTick = baseTick / (1.0f + this.artifacts.getStatValue(StatType.RITUAL_SPEED) / 100.0f);
            if (this.isCrash && (float)this.tickCountCrash >= 100.0f * this.speed) {
                this.crashRitual(this.ritual);
            }
            if ((float)this.tickCount >= finalTick) {
                Random random = new Random();
                if (random.nextFloat() < this.chance + this.artifacts.getStatValue(StatType.RITUAL_LUCK)) {
                    this.finishRitual(this.ritual);
                } else {
                    this.stopRitual(this.ritual);
                }
            }
        }
    }

    private int getRandomEtherColor() {
        return ColorUtils.getRandomColorRGB(new Color(213, 185, 237), new Color(253, 249, 255), new Color(190, 153, 222), new Color(226, 215, 249));
    }

    public int getEtherColor() {
        float baseHue = 300.0f;
        float hueRange = 59.0f;
        float[] startHSV = new float[]{baseHue / 360.0f, 0.1f, 0.9f};
        if (this.isCrash) {
            float progress = (float)(this.tickCountCrash % (int)(200.0f * this.speed)) / (200.0f * this.speed);
            float interpolatedHue = (baseHue + progress * hueRange) % 360.0f / 360.0f;
            float interpolatedSaturation = Math.min(startHSV[1] + 1.4f * progress, 1.0f);
            Color interpolatedColor = this.hsvToRGB(interpolatedHue, interpolatedSaturation, startHSV[2]);
            return interpolatedColor.getRGB();
        }
        return this.getRandomEtherColor();
    }

    public boolean hasStartRitual() {
        if (RitualRegistry.getDataRitual(this.ritual.getId()).isEnigma() && !this.hasEnigma) {
            return false;
        }
        return !(this.ritual.getRitualResult() instanceof EnigmaResult) || !EnigmaUtils.isEnigma(RitualUtils.getItemFromAltar((Level)this.level, this.altarPos));
    }

    private float[] rgbToHSV(int r, int g, int b) {
        float[] hsv = new float[3];
        Color.RGBtoHSB(r, g, b, hsv);
        return hsv;
    }

    private Color hsvToRGB(float h, float s, float v) {
        int rgb = Color.HSBtoRGB(h, s, v);
        return new Color(rgb);
    }

    public void reloadPedestalItems(EtherPedestalTile pedestal, ItemStack stack) {
        if (stack.m_41619_()) {
            this.pedestalItems.remove(pedestal);
        } else {
            this.pedestalItems.put(pedestal, stack);
        }
    }

    public void stopRitual(Ritual ritual) {
        this.clearPedestals();
        this.tickPartCount = 0;
        for (BlockPos pos : this.pedestals.stream().toList()) {
            ParticleUtils.createParticle((Level)this.level, new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.1f, 40 + this.level.f_46441_.m_216339_(10, 14), 0.002f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.85, (double)pos.m_123343_() + 0.5, 50, 0.2, 0.2, 0.2, 0.005);
        }
        ritual.setActive(false);
        this.isActive = false;
        this.ritual = null;
        this.tickCount = 0;
    }

    private static List<BlockPos> orderPedestalsSequentially(List<BlockPos> pedestals) {
        ArrayList<BlockPos> ordered = new ArrayList<BlockPos>();
        if (pedestals.isEmpty()) {
            return ordered;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos current = pedestals.get(0);
        ordered.add(current);
        visited.add(current);
        while (ordered.size() < pedestals.size()) {
            BlockPos closest = null;
            double closestDistance = Double.MAX_VALUE;
            for (BlockPos pedestal : pedestals) {
                double distance;
                if (visited.contains(pedestal) || !((distance = current.m_123331_((Vec3i)pedestal)) < closestDistance)) continue;
                closestDistance = distance;
                closest = pedestal;
            }
            if (closest == null) continue;
            ordered.add(closest);
            visited.add(closest);
            current = closest;
        }
        return ordered;
    }

    public void crashRitual(Ritual ritual) {
        for (BlockPos pos : this.pedestals.stream().toList()) {
            RitualUtils.throwingItems((Level)this.level, pos);
            BlockEntity blockEntity = this.level.m_7702_(pos);
            if (!(blockEntity instanceof EtherPedestalTile)) continue;
            EtherPedestalTile blockEntity2 = (EtherPedestalTile)blockEntity;
            blockEntity2.setProgress(0.0f);
            blockEntity2.m_6596_();
        }
        for (BlockPos pos : this.runicPedestals.stream().toList()) {
            RitualUtils.throwingRunes((Level)this.level, pos);
        }
        for (BlockPos pos : this.etherPedestals) {
            ItemStack itemStack = RitualUtils.getCrystalFromPedestal((Level)this.level, pos);
            BlockEntity blockEntity = this.level.m_7702_(pos);
            if (!(blockEntity instanceof EtherDistributorTile)) continue;
            EtherDistributorTile tile = (EtherDistributorTile)blockEntity;
            if (ritual == null) continue;
            BlockState oldState = tile.m_58900_();
            EtherUtils.setEther(itemStack, (int)((float)EtherUtils.getEther(itemStack) - (float)ritual.getEtherAmount() * (1.0f + this.artifacts.getStatValue(StatType.ETHER_COST) / 100.0f)));
            RitualUtils.setItemOnPedestal((Level)this.level, pos, itemStack);
            tile.m_6596_();
            this.level.m_7260_(pos, oldState, this.level.m_8055_(pos), 3);
        }
        this.tickPartCount = 0;
        for (BlockPos pos : this.pedestals.stream().toList()) {
            ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.PYRO), 0.3f, 100, 0.2f), (Level)this.level, pos.m_252807_().m_82520_(0.0, 0.5, 0.0), pos.m_252807_(), 1, 1.0f);
        }
        ritual.setActive(false);
        this.isActive = false;
        this.ritual = null;
        this.tickCount = 0;
    }

    public void finishRitual(Ritual ritual) {
        int xp;
        AchievementHandler.grantAdvancementInRadius(this.level, this.altarPos.m_252807_(), 7.0, "rituals");
        switch (ritual.getRitualDifficulty()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EASY: {
                int n = 2;
                break;
            }
            case BASIC: {
                int n = 6;
                break;
            }
            case ELEMENTARY: {
                int n = 14;
                break;
            }
            case ADVANCED: {
                int n = xp = 20;
            }
        }
        if (this.player != null) {
            SkillsUtils.addXp((Player)this.player, Branches.MAGIC, xp);
        }
        this.clearPedestals();
        this.tickPartCount = 0;
        for (BlockPos pos : this.pedestals.stream().toList()) {
            ParticleUtils.createParticle((Level)this.level, new GlowingParticleData(new Color(201, 131, 222), 0.1f, 60 + this.level.f_46441_.m_216339_(10, 14), 0.002f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.85, (double)pos.m_123343_() + 0.5, 30, 0.2, 0.2, 0.2, 0.005);
        }
        ritual.setActive(false);
        this.isActive = false;
        ritual.getRitualResult().executeResult((Level)this.level, this.altarPos, ritual.getId(), this.player);
        ParticleUtils.createParticle((Level)this.level, new GlowingParticleData(new Color(201, 131, 222), 0.1f, 60 + this.level.f_46441_.m_216339_(10, 14), 0.002f), (double)this.altarPos.m_123341_() + 0.5, (double)this.altarPos.m_123342_() + 0.85, (double)this.altarPos.m_123343_() + 0.5, 30, 0.2, 0.2, 0.2, 0.005);
        this.tickCount = 0;
        this.ritual = null;
    }

    public void checkRituals() {
        for (Ritual ritual1 : RitualRegistry.getRituals()) {
            if (this.canStartRitual(ritual1)) {
                this.ritual = ritual1;
                break;
            }
            this.ritual = null;
        }
    }

    public void checkCrystals() {
        int ether = 0;
        for (BlockPos pos : RitualUtils.filterCrystalPedestalsWithItems((Level)this.level, this.etherPedestals).keySet()) {
            ItemStack itemStack = RitualUtils.getCrystalFromPedestal((Level)this.level, pos);
            if (!(itemStack.m_41720_() instanceof IEtherEntryItem) || this.ritual == null) continue;
            ether += EtherUtils.getEther(itemStack);
        }
        this.etherAmount = ether;
    }

    public boolean canStartRitual(Ritual ritual) {
        boolean altar = this.validateAltarItem(ritual);
        boolean ing = this.validateIngredients(ritual);
        boolean runes = this.validateRunes(ritual);
        return altar && ing && runes;
    }

    private void clearPedestals() {
        this.tickCountEssence = 0;
        for (BlockPos pos : this.pedestals.stream().toList()) {
            RitualUtils.setItemOnPedestal((Level)this.level, pos, ItemStack.f_41583_);
            BlockEntity blockEntity = this.level.m_7702_(pos);
            if (!(blockEntity instanceof EtherPedestalTile)) continue;
            EtherPedestalTile blockEntity2 = (EtherPedestalTile)blockEntity;
            blockEntity2.setProgress(0.0f);
            blockEntity2.m_6596_();
        }
        for (BlockPos pos : this.runicPedestals.stream().toList()) {
            RitualUtils.setRuneOnPedestal((Level)this.level, pos, ItemStack.f_41583_);
        }
        for (BlockPos pos : this.etherPedestals) {
            ItemStack itemStack = RitualUtils.getCrystalFromPedestal((Level)this.level, pos);
            BlockEntity blockEntity = this.level.m_7702_(pos);
            if (!(blockEntity instanceof EtherDistributorTile)) continue;
            EtherDistributorTile tile = (EtherDistributorTile)blockEntity;
            if (this.ritual == null) continue;
            BlockState oldState = tile.m_58900_();
            EtherUtils.setEther(itemStack, (int)((float)EtherUtils.getEther(itemStack) - (float)this.ritual.getEtherAmount() * (1.0f - this.artifacts.getStatValue(StatType.ETHER_COST) / 100.0f)));
            RitualUtils.setItemOnPedestal((Level)this.level, pos, itemStack);
            tile.m_6596_();
            this.level.m_7260_(pos, oldState, this.level.m_8055_(pos), 3);
        }
    }

    public void init(ServerLevel level, BlockPos altarPos) {
        this.level = level;
        this.altarPos = altarPos;
        this.pedestals = BlockUtils.findBlocks((Level)level, altarPos, 4, IEtherPedestal.class);
        this.etherPedestals = BlockUtils.findBlocks((Level)level, altarPos, 4, BlockRegistry.ETHER_DISTRIBUTOR);
    }

    public boolean validateRunes(Ritual ritual) {
        ArrayList<ItemStack> runeItems = new ArrayList<ItemStack>(this.runicPedestals.stream().map(pedestalPos -> RitualUtils.getRuneFromPedestal((Level)this.level, pedestalPos)).filter(item -> !item.m_41619_() && item.m_41720_() != Items.f_41852_).toList());
        List<ItemStack> requiredRunes = ritual.getRuneItems().stream().map(RuneItem::asItemStack).toList();
        if (requiredRunes.isEmpty()) {
            return true;
        }
        if (runeItems.size() != requiredRunes.size()) {
            return false;
        }
        for (ItemStack requiredRune : requiredRunes) {
            boolean matched = runeItems.removeIf(rune -> ItemStack.m_150942_((ItemStack)rune, (ItemStack)requiredRune));
            if (matched) continue;
            return false;
        }
        return true;
    }

    public boolean validateAltarItem(Ritual ritual) {
        ItemStack altar = RitualUtils.getItemFromAltar((Level)this.level, this.altarPos);
        Ingredient ingredient = ritual.getMainIngredient();
        return ritual.getMainIngredient().test(RitualUtils.getItemFromAltar((Level)this.level, this.altarPos));
    }

    public boolean validateIngredients(Ritual ritual) {
        List<ItemStack> pedestalItems = this.pedestals.stream().map(pedestalPos -> RitualUtils.getItemFromPedestal((Level)this.level, pedestalPos)).toList();
        int pedestalItemCount = (int)pedestalItems.stream().filter(item -> !item.m_41619_()).count();
        int ritualIngredientCount = ritual.getIngredientList().size();
        if (ritualIngredientCount == 0) {
            return true;
        }
        if (pedestalItemCount != ritualIngredientCount) {
            return false;
        }
        for (ItemStack pedestalItem : pedestalItems) {
            if (pedestalItem.m_41619_() || pedestalItem.m_41720_() == Items.f_41852_) continue;
            boolean foundMatchingIngredient = false;
            for (Ingredient ingredient : ritual.getIngredientList()) {
                if (!ingredient.test(pedestalItem)) continue;
                foundMatchingIngredient = true;
            }
            if (foundMatchingIngredient) continue;
            return false;
        }
        return true;
    }

    private void addEtherParticles(BlockPos pedestalPos) {
        double xSpeed = 0.1 * (double)(this.altarPos.m_123341_() - pedestalPos.m_123341_()) / 2.0;
        double zSpeed = 0.1 * (double)(this.altarPos.m_123343_() - pedestalPos.m_123343_()) / 2.0;
        if (this.level.m_213780_().m_188500_() < 0.6) {
            Networking.sendToAll(new ParticleSpawnerPacket(new GlowingParticleData(new Color(193, 92, 224).getRGB(), 0.2f, 20, 0.002f), (double)pedestalPos.m_123341_() + 0.5, (double)pedestalPos.m_123342_() + 0.1 + (double)0.4f, (double)pedestalPos.m_123343_() + 0.5, xSpeed, 0.0, zSpeed));
        }
    }

    public static void breakRitual(Level level, BlockPos pos) {
        for (BlockPos altarPos : BlockUtils.findBlocks(level, pos, 4, EtherAltar.class).stream().toList()) {
            for (BlockPos pedestalPos : BlockUtils.findBlocks(level, altarPos, 4, IEtherPedestal.class).stream().toList()) {
                EtherPedestalTile tile;
                BlockEntity blockEntity = level.m_7702_(pedestalPos);
                if (!(blockEntity instanceof EtherPedestalTile) || !(tile = (EtherPedestalTile)blockEntity).isGenerated()) continue;
                level.m_7731_(altarPos, Blocks.f_50016_.m_49966_(), 3);
                ParticleUtils.drawParticleLine(new GlowingParticleData(ElementsUtils.getColorByElement(Element.CRYO), 0.4f, new Random().nextInt(80, 110), 0.25f), level, altarPos.m_252807_(), pedestalPos.m_252807_(), 30, 1.0f);
                level.m_7731_(pedestalPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public CompoundTag serializeNBT() {
        return NbtUtils.serialize(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        NbtUtils.deserialize(this, nbt);
    }

    @Nullable
    public Ritual getRitual() {
        return this.ritual;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public int getTickPartCount() {
        return this.tickPartCount;
    }

    public int getTickCountUnlock() {
        return this.tickCountUnlock;
    }

    public int getTickCountEssence() {
        return this.tickCountEssence;
    }

    public int getTickCountCrash() {
        return this.tickCountCrash;
    }

    public Element getElement() {
        return this.element;
    }

    public Element getAltarElement() {
        return this.altarElement;
    }

    public Map<EtherPedestalTile, ItemStack> getPedestalItems() {
        return this.pedestalItems;
    }

    public List<BlockPos> getSealPedestal() {
        return this.sealPedestal;
    }

    public List<BlockPos> getPedestals() {
        return this.pedestals;
    }

    public List<BlockPos> getEtherPedestals() {
        return this.etherPedestals;
    }

    public List<BlockPos> getRunicPedestals() {
        return this.runicPedestals;
    }

    public List<Element> getActElements() {
        return this.actElements;
    }

    public List<BlockPos> getSealPedestalCache() {
        return this.sealPedestalCache;
    }

    public int getCacheRefreshCooldown() {
        return this.cacheRefreshCooldown;
    }

    public int getEtherAmount() {
        return this.etherAmount;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getChance() {
        return this.chance;
    }

    public ArtifactStatCalculator getArtifacts() {
        return this.artifacts;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public boolean isUnlock() {
        return this.isUnlock;
    }

    public boolean isOverload() {
        return this.isOverload;
    }

    public boolean isCrash() {
        return this.isCrash;
    }

    public boolean isHasEnigma() {
        return this.hasEnigma;
    }

    public RitualEventManager getEventManager() {
        return this.eventManager;
    }

    public RitualStage getRitualStage() {
        return this.ritualStage;
    }

    public RitualStage getPreviousRitualStage() {
        return this.previousRitualStage;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public Map<Integer, Integer> getRandomSeeds() {
        return this.randomSeeds;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getTickCount1() {
        return this.tickCount1;
    }

    public int getTickCount2() {
        return this.tickCount2;
    }

    public int getTickAnimCount1() {
        return this.tickAnimCount1;
    }

    public int getTickAnimCount2() {
        return this.tickAnimCount2;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getSeed2() {
        return this.seed2;
    }

    public void setRitual(@Nullable Ritual ritual) {
        this.ritual = ritual;
    }

    public void setLevel(ServerLevel level) {
        this.level = level;
    }

    public void setAltarPos(BlockPos altarPos) {
        this.altarPos = altarPos;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public void setTickPartCount(int tickPartCount) {
        this.tickPartCount = tickPartCount;
    }

    public void setTickCountUnlock(int tickCountUnlock) {
        this.tickCountUnlock = tickCountUnlock;
    }

    public void setTickCountEssence(int tickCountEssence) {
        this.tickCountEssence = tickCountEssence;
    }

    public void setTickCountCrash(int tickCountCrash) {
        this.tickCountCrash = tickCountCrash;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setAltarElement(Element altarElement) {
        this.altarElement = altarElement;
    }

    public void setPedestalItems(Map<EtherPedestalTile, ItemStack> pedestalItems) {
        this.pedestalItems = pedestalItems;
    }

    public void setSealPedestal(List<BlockPos> sealPedestal) {
        this.sealPedestal = sealPedestal;
    }

    public void setPedestals(List<BlockPos> pedestals) {
        this.pedestals = pedestals;
    }

    public void setEtherPedestals(List<BlockPos> etherPedestals) {
        this.etherPedestals = etherPedestals;
    }

    public void setRunicPedestals(List<BlockPos> runicPedestals) {
        this.runicPedestals = runicPedestals;
    }

    public void setActElements(List<Element> actElements) {
        this.actElements = actElements;
    }

    public void setSealPedestalCache(List<BlockPos> sealPedestalCache) {
        this.sealPedestalCache = sealPedestalCache;
    }

    public void setCacheRefreshCooldown(int cacheRefreshCooldown) {
        this.cacheRefreshCooldown = cacheRefreshCooldown;
    }

    public void setEtherAmount(int etherAmount) {
        this.etherAmount = etherAmount;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public void setArtifacts(ArtifactStatCalculator artifacts) {
        this.artifacts = artifacts;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public void setUnlock(boolean isUnlock) {
        this.isUnlock = isUnlock;
    }

    public void setOverload(boolean isOverload) {
        this.isOverload = isOverload;
    }

    public void setCrash(boolean isCrash) {
        this.isCrash = isCrash;
    }

    public void setHasEnigma(boolean hasEnigma) {
        this.hasEnigma = hasEnigma;
    }

    public void setEventManager(RitualEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setRitualStage(RitualStage ritualStage) {
        this.ritualStage = ritualStage;
    }

    public void setPreviousRitualStage(RitualStage previousRitualStage) {
        this.previousRitualStage = previousRitualStage;
    }

    public void setPlayer(ServerPlayer player) {
        this.player = player;
    }

    public void setRandomSeeds(Map<Integer, Integer> randomSeeds) {
        this.randomSeeds = randomSeeds;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public void setTickCount1(int tickCount1) {
        this.tickCount1 = tickCount1;
    }

    public void setTickCount2(int tickCount2) {
        this.tickCount2 = tickCount2;
    }

    public void setTickAnimCount1(int tickAnimCount1) {
        this.tickAnimCount1 = tickAnimCount1;
    }

    public void setTickAnimCount2(int tickAnimCount2) {
        this.tickAnimCount2 = tickAnimCount2;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setSeed2(int seed2) {
        this.seed2 = seed2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RitualManager)) {
            return false;
        }
        RitualManager other = (RitualManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTickCount() != other.getTickCount()) {
            return false;
        }
        if (this.getTickPartCount() != other.getTickPartCount()) {
            return false;
        }
        if (this.getTickCountUnlock() != other.getTickCountUnlock()) {
            return false;
        }
        if (this.getTickCountEssence() != other.getTickCountEssence()) {
            return false;
        }
        if (this.getTickCountCrash() != other.getTickCountCrash()) {
            return false;
        }
        if (this.getCacheRefreshCooldown() != other.getCacheRefreshCooldown()) {
            return false;
        }
        if (this.getEtherAmount() != other.getEtherAmount()) {
            return false;
        }
        if (Float.compare(this.getSpeed(), other.getSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getChance(), other.getChance()) != 0) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isBlocked() != other.isBlocked()) {
            return false;
        }
        if (this.isUnlock() != other.isUnlock()) {
            return false;
        }
        if (this.isOverload() != other.isOverload()) {
            return false;
        }
        if (this.isCrash() != other.isCrash()) {
            return false;
        }
        if (this.isHasEnigma() != other.isHasEnigma()) {
            return false;
        }
        if (this.getMaxTime() != other.getMaxTime()) {
            return false;
        }
        if (this.getTickCount1() != other.getTickCount1()) {
            return false;
        }
        if (this.getTickCount2() != other.getTickCount2()) {
            return false;
        }
        if (this.getTickAnimCount1() != other.getTickAnimCount1()) {
            return false;
        }
        if (this.getTickAnimCount2() != other.getTickAnimCount2()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getSeed2() != other.getSeed2()) {
            return false;
        }
        Ritual this$ritual = this.getRitual();
        Ritual other$ritual = other.getRitual();
        if (this$ritual == null ? other$ritual != null : !((Object)this$ritual).equals(other$ritual)) {
            return false;
        }
        ServerLevel this$level = this.getLevel();
        ServerLevel other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        BlockPos this$altarPos = this.getAltarPos();
        BlockPos other$altarPos = other.getAltarPos();
        if (this$altarPos == null ? other$altarPos != null : !this$altarPos.equals(other$altarPos)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)((Object)this$element)).equals((Object)other$element)) {
            return false;
        }
        Element this$altarElement = this.getAltarElement();
        Element other$altarElement = other.getAltarElement();
        if (this$altarElement == null ? other$altarElement != null : !((Object)((Object)this$altarElement)).equals((Object)other$altarElement)) {
            return false;
        }
        Map<EtherPedestalTile, ItemStack> this$pedestalItems = this.getPedestalItems();
        Map<EtherPedestalTile, ItemStack> other$pedestalItems = other.getPedestalItems();
        if (this$pedestalItems == null ? other$pedestalItems != null : !((Object)this$pedestalItems).equals(other$pedestalItems)) {
            return false;
        }
        List<BlockPos> this$sealPedestal = this.getSealPedestal();
        List<BlockPos> other$sealPedestal = other.getSealPedestal();
        if (this$sealPedestal == null ? other$sealPedestal != null : !((Object)this$sealPedestal).equals(other$sealPedestal)) {
            return false;
        }
        List<BlockPos> this$pedestals = this.getPedestals();
        List<BlockPos> other$pedestals = other.getPedestals();
        if (this$pedestals == null ? other$pedestals != null : !((Object)this$pedestals).equals(other$pedestals)) {
            return false;
        }
        List<BlockPos> this$etherPedestals = this.getEtherPedestals();
        List<BlockPos> other$etherPedestals = other.getEtherPedestals();
        if (this$etherPedestals == null ? other$etherPedestals != null : !((Object)this$etherPedestals).equals(other$etherPedestals)) {
            return false;
        }
        List<BlockPos> this$runicPedestals = this.getRunicPedestals();
        List<BlockPos> other$runicPedestals = other.getRunicPedestals();
        if (this$runicPedestals == null ? other$runicPedestals != null : !((Object)this$runicPedestals).equals(other$runicPedestals)) {
            return false;
        }
        List<Element> this$actElements = this.getActElements();
        List<Element> other$actElements = other.getActElements();
        if (this$actElements == null ? other$actElements != null : !((Object)this$actElements).equals(other$actElements)) {
            return false;
        }
        List<BlockPos> this$sealPedestalCache = this.getSealPedestalCache();
        List<BlockPos> other$sealPedestalCache = other.getSealPedestalCache();
        if (this$sealPedestalCache == null ? other$sealPedestalCache != null : !((Object)this$sealPedestalCache).equals(other$sealPedestalCache)) {
            return false;
        }
        ArtifactStatCalculator this$artifacts = this.getArtifacts();
        ArtifactStatCalculator other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        RitualEventManager this$eventManager = this.getEventManager();
        RitualEventManager other$eventManager = other.getEventManager();
        if (this$eventManager == null ? other$eventManager != null : !this$eventManager.equals(other$eventManager)) {
            return false;
        }
        RitualStage this$ritualStage = this.getRitualStage();
        RitualStage other$ritualStage = other.getRitualStage();
        if (this$ritualStage == null ? other$ritualStage != null : !((Object)((Object)this$ritualStage)).equals((Object)other$ritualStage)) {
            return false;
        }
        RitualStage this$previousRitualStage = this.getPreviousRitualStage();
        RitualStage other$previousRitualStage = other.getPreviousRitualStage();
        if (this$previousRitualStage == null ? other$previousRitualStage != null : !((Object)((Object)this$previousRitualStage)).equals((Object)other$previousRitualStage)) {
            return false;
        }
        ServerPlayer this$player = this.getPlayer();
        ServerPlayer other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Map<Integer, Integer> this$randomSeeds = this.getRandomSeeds();
        Map<Integer, Integer> other$randomSeeds = other.getRandomSeeds();
        return !(this$randomSeeds == null ? other$randomSeeds != null : !((Object)this$randomSeeds).equals(other$randomSeeds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RitualManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTickCount();
        result = result * 59 + this.getTickPartCount();
        result = result * 59 + this.getTickCountUnlock();
        result = result * 59 + this.getTickCountEssence();
        result = result * 59 + this.getTickCountCrash();
        result = result * 59 + this.getCacheRefreshCooldown();
        result = result * 59 + this.getEtherAmount();
        result = result * 59 + Float.floatToIntBits(this.getSpeed());
        result = result * 59 + Float.floatToIntBits(this.getChance());
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isBlocked() ? 79 : 97);
        result = result * 59 + (this.isUnlock() ? 79 : 97);
        result = result * 59 + (this.isOverload() ? 79 : 97);
        result = result * 59 + (this.isCrash() ? 79 : 97);
        result = result * 59 + (this.isHasEnigma() ? 79 : 97);
        result = result * 59 + this.getMaxTime();
        result = result * 59 + this.getTickCount1();
        result = result * 59 + this.getTickCount2();
        result = result * 59 + this.getTickAnimCount1();
        result = result * 59 + this.getTickAnimCount2();
        result = result * 59 + this.getSeed();
        result = result * 59 + this.getSeed2();
        Ritual $ritual = this.getRitual();
        result = result * 59 + ($ritual == null ? 43 : ((Object)$ritual).hashCode());
        ServerLevel $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        BlockPos $altarPos = this.getAltarPos();
        result = result * 59 + ($altarPos == null ? 43 : $altarPos.hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)((Object)$element)).hashCode());
        Element $altarElement = this.getAltarElement();
        result = result * 59 + ($altarElement == null ? 43 : ((Object)((Object)$altarElement)).hashCode());
        Map<EtherPedestalTile, ItemStack> $pedestalItems = this.getPedestalItems();
        result = result * 59 + ($pedestalItems == null ? 43 : ((Object)$pedestalItems).hashCode());
        List<BlockPos> $sealPedestal = this.getSealPedestal();
        result = result * 59 + ($sealPedestal == null ? 43 : ((Object)$sealPedestal).hashCode());
        List<BlockPos> $pedestals = this.getPedestals();
        result = result * 59 + ($pedestals == null ? 43 : ((Object)$pedestals).hashCode());
        List<BlockPos> $etherPedestals = this.getEtherPedestals();
        result = result * 59 + ($etherPedestals == null ? 43 : ((Object)$etherPedestals).hashCode());
        List<BlockPos> $runicPedestals = this.getRunicPedestals();
        result = result * 59 + ($runicPedestals == null ? 43 : ((Object)$runicPedestals).hashCode());
        List<Element> $actElements = this.getActElements();
        result = result * 59 + ($actElements == null ? 43 : ((Object)$actElements).hashCode());
        List<BlockPos> $sealPedestalCache = this.getSealPedestalCache();
        result = result * 59 + ($sealPedestalCache == null ? 43 : ((Object)$sealPedestalCache).hashCode());
        ArtifactStatCalculator $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        RitualEventManager $eventManager = this.getEventManager();
        result = result * 59 + ($eventManager == null ? 43 : $eventManager.hashCode());
        RitualStage $ritualStage = this.getRitualStage();
        result = result * 59 + ($ritualStage == null ? 43 : ((Object)((Object)$ritualStage)).hashCode());
        RitualStage $previousRitualStage = this.getPreviousRitualStage();
        result = result * 59 + ($previousRitualStage == null ? 43 : ((Object)((Object)$previousRitualStage)).hashCode());
        ServerPlayer $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Map<Integer, Integer> $randomSeeds = this.getRandomSeeds();
        result = result * 59 + ($randomSeeds == null ? 43 : ((Object)$randomSeeds).hashCode());
        return result;
    }

    public String toString() {
        return "RitualManager(ritual=" + String.valueOf(this.getRitual()) + ", level=" + String.valueOf(this.getLevel()) + ", altarPos=" + String.valueOf(this.getAltarPos()) + ", tickCount=" + this.getTickCount() + ", tickPartCount=" + this.getTickPartCount() + ", tickCountUnlock=" + this.getTickCountUnlock() + ", tickCountEssence=" + this.getTickCountEssence() + ", tickCountCrash=" + this.getTickCountCrash() + ", element=" + String.valueOf((Object)this.getElement()) + ", altarElement=" + String.valueOf((Object)this.getAltarElement()) + ", pedestalItems=" + String.valueOf(this.getPedestalItems()) + ", sealPedestal=" + String.valueOf(this.getSealPedestal()) + ", pedestals=" + String.valueOf(this.getPedestals()) + ", etherPedestals=" + String.valueOf(this.getEtherPedestals()) + ", runicPedestals=" + String.valueOf(this.getRunicPedestals()) + ", actElements=" + String.valueOf(this.getActElements()) + ", sealPedestalCache=" + String.valueOf(this.getSealPedestalCache()) + ", cacheRefreshCooldown=" + this.getCacheRefreshCooldown() + ", etherAmount=" + this.getEtherAmount() + ", speed=" + this.getSpeed() + ", chance=" + this.getChance() + ", artifacts=" + String.valueOf(this.getArtifacts()) + ", isActive=" + this.isActive() + ", isBlocked=" + this.isBlocked() + ", isUnlock=" + this.isUnlock() + ", isOverload=" + this.isOverload() + ", isCrash=" + this.isCrash() + ", hasEnigma=" + this.isHasEnigma() + ", eventManager=" + String.valueOf(this.getEventManager()) + ", ritualStage=" + String.valueOf((Object)this.getRitualStage()) + ", previousRitualStage=" + String.valueOf((Object)this.getPreviousRitualStage()) + ", player=" + String.valueOf(this.getPlayer()) + ", randomSeeds=" + String.valueOf(this.getRandomSeeds()) + ", maxTime=" + this.getMaxTime() + ", tickCount1=" + this.getTickCount1() + ", tickCount2=" + this.getTickCount2() + ", tickAnimCount1=" + this.getTickAnimCount1() + ", tickAnimCount2=" + this.getTickAnimCount2() + ", seed=" + this.getSeed() + ", seed2=" + this.getSeed2() + ")";
    }
}

