/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals.utils;

import it.mralxart.etheria.magic.rituals.RitualEvent;
import it.mralxart.etheria.magic.rituals.data.RitualStage;
import it.mralxart.etheria.magic.rituals.utils.RitualManager;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class RitualEventManager {
    private final Map<RitualStage, List<RitualEvent>> events = new EnumMap<RitualStage, List<RitualEvent>>(RitualStage.class);
    private final List<String> eventLog = new ArrayList<String>();

    public RitualEventManager() {
        for (RitualStage stage : RitualStage.values()) {
            this.events.put(stage, new ArrayList());
        }
    }

    public void registerEvent(RitualEvent event) {
        for (RitualStage stage : event.getActivationStages()) {
            this.events.get((Object)stage).add(event);
        }
        this.events.get((Object)event.getEndStage()).add(event);
    }

    public boolean executeStage(RitualStage stage, RitualManager context) {
        boolean eventExecuted = false;
        for (RitualEvent event : this.events.get((Object)stage)) {
            if (!event.shouldExecute(stage)) continue;
            event.setActivated(true);
            event.execute(context);
            eventExecuted = true;
        }
        return eventExecuted;
    }

    public void tickEvents(RitualManager context) {
        for (RitualStage stage : RitualStage.values()) {
            for (RitualEvent event : this.events.get((Object)stage)) {
                if (!event.isActivated() || context.getRitualStage() != stage) continue;
                event.tick(context);
            }
        }
    }

    public List<String> getEventLog() {
        return new ArrayList<String>(this.eventLog);
    }
}

