/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.rituals;

import it.mralxart.etheria.magic.rituals.data.RitualStage;
import it.mralxart.etheria.magic.rituals.utils.RitualManager;
import java.util.List;
import java.util.Random;

public abstract class RitualEvent {
    private final List<RitualStage> activationStages;
    private final RitualStage endStage;
    private final int priority;
    private boolean isActivated = false;
    public Random random = new Random();

    public RitualEvent(List<RitualStage> activationStages, RitualStage endStage, int priority) {
        this.activationStages = activationStages;
        this.endStage = endStage;
        this.priority = priority;
    }

    public boolean shouldExecute(RitualStage currentStage) {
        return this.activationStages.contains((Object)currentStage);
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setActivated(boolean activated) {
        this.isActivated = activated;
    }

    public boolean execute(RitualManager context) {
        return true;
    }

    public void tick(RitualManager context) {
        if (this.isActivated()) {
            // empty if block
        }
    }

    public List<RitualStage> getActivationStages() {
        return this.activationStages;
    }

    public RitualStage getEndStage() {
        return this.endStage;
    }

    public int getPriority() {
        return this.priority;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RitualEvent)) {
            return false;
        }
        RitualEvent other = (RitualEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isActivated() != other.isActivated()) {
            return false;
        }
        List<RitualStage> this$activationStages = this.getActivationStages();
        List<RitualStage> other$activationStages = other.getActivationStages();
        if (this$activationStages == null ? other$activationStages != null : !((Object)this$activationStages).equals(other$activationStages)) {
            return false;
        }
        RitualStage this$endStage = this.getEndStage();
        RitualStage other$endStage = other.getEndStage();
        if (this$endStage == null ? other$endStage != null : !((Object)((Object)this$endStage)).equals((Object)other$endStage)) {
            return false;
        }
        Random this$random = this.getRandom();
        Random other$random = other.getRandom();
        return !(this$random == null ? other$random != null : !this$random.equals(other$random));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RitualEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isActivated() ? 79 : 97);
        List<RitualStage> $activationStages = this.getActivationStages();
        result = result * 59 + ($activationStages == null ? 43 : ((Object)$activationStages).hashCode());
        RitualStage $endStage = this.getEndStage();
        result = result * 59 + ($endStage == null ? 43 : ((Object)((Object)$endStage)).hashCode());
        Random $random = this.getRandom();
        result = result * 59 + ($random == null ? 43 : $random.hashCode());
        return result;
    }

    public String toString() {
        return "RitualEvent(activationStages=" + String.valueOf(this.getActivationStages()) + ", endStage=" + String.valueOf((Object)this.getEndStage()) + ", priority=" + this.getPriority() + ", isActivated=" + this.isActivated() + ", random=" + String.valueOf(this.getRandom()) + ")";
    }
}

