/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.Item;

public class RecipeData {
    private final String id;
    private final String tag;
    private final Item item;
    private final Item upItem;
    private final List<Item> items;

    public static RecipeDataBuilder builder(String marker, String tag) {
        RecipeDataBuilder builder = new RecipeDataBuilder();
        builder.id(marker);
        builder.tag(tag);
        builder.item(null);
        builder.upItem(null);
        builder.items(new ArrayList<Item>());
        return builder;
    }

    public static RecipeDataBuilder builder(String marker, Item item) {
        RecipeDataBuilder builder = new RecipeDataBuilder();
        builder.id(marker);
        builder.item(item);
        builder.tag("");
        builder.upItem(null);
        builder.items(new ArrayList<Item>());
        return builder;
    }

    public static RecipeDataBuilder builder(String marker, Item item, Item upItem) {
        RecipeDataBuilder builder = new RecipeDataBuilder();
        builder.id(marker);
        builder.item(item);
        builder.upItem(upItem);
        builder.tag("");
        builder.items(new ArrayList<Item>());
        return builder;
    }

    public static RecipeDataBuilder builder(String marker, Item ... items) {
        RecipeDataBuilder builder = new RecipeDataBuilder();
        builder.id(marker);
        builder.item(null);
        builder.upItem(null);
        builder.items(Arrays.stream(items).toList());
        builder.tag("");
        return builder;
    }

    RecipeData(String id, String tag, Item item, Item upItem, List<Item> items) {
        this.id = id;
        this.tag = tag;
        this.item = item;
        this.upItem = upItem;
        this.items = items;
    }

    public String getId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public Item getItem() {
        return this.item;
    }

    public Item getUpItem() {
        return this.upItem;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeData)) {
            return false;
        }
        RecipeData other = (RecipeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        Item this$item = this.getItem();
        Item other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        Item this$upItem = this.getUpItem();
        Item other$upItem = other.getUpItem();
        if (this$upItem == null ? other$upItem != null : !this$upItem.equals(other$upItem)) {
            return false;
        }
        List<Item> this$items = this.getItems();
        List<Item> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecipeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        Item $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        Item $upItem = this.getUpItem();
        result = result * 59 + ($upItem == null ? 43 : $upItem.hashCode());
        List<Item> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "RecipeData(id=" + this.getId() + ", tag=" + this.getTag() + ", item=" + String.valueOf(this.getItem()) + ", upItem=" + String.valueOf(this.getUpItem()) + ", items=" + String.valueOf(this.getItems()) + ")";
    }

    public static class RecipeDataBuilder {
        private String id;
        private String tag;
        private Item item;
        private Item upItem;
        private List<Item> items;

        RecipeDataBuilder() {
        }

        public RecipeDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RecipeDataBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public RecipeDataBuilder item(Item item) {
            this.item = item;
            return this;
        }

        public RecipeDataBuilder upItem(Item upItem) {
            this.upItem = upItem;
            return this;
        }

        public RecipeDataBuilder items(List<Item> items) {
            this.items = items;
            return this;
        }

        public RecipeData build() {
            return new RecipeData(this.id, this.tag, this.item, this.upItem, this.items);
        }

        public String toString() {
            return "RecipeData.RecipeDataBuilder(id=" + this.id + ", tag=" + this.tag + ", item=" + String.valueOf(this.item) + ", upItem=" + String.valueOf(this.upItem) + ", items=" + String.valueOf(this.items) + ")";
        }
    }
}

