/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon.data;

import it.mralxart.etheria.magic.magemicon.data.ChapterData;
import it.mralxart.etheria.magic.magemicon.data.PageData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CategoryData {
    private final String id;
    private Map<String, ChapterData> chapters;
    private Map<String, PageData> pages;
    private PageData mainPage;
    private boolean secret;
    private ItemStack item;

    public static CategoryDataBuilder builder(String id) {
        CategoryDataBuilder builder = new CategoryDataBuilder();
        builder.id(id);
        return builder;
    }

    private static boolean $default$secret() {
        return false;
    }

    private static ItemStack $default$item() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    CategoryData(String id, Map<String, ChapterData> chapters, Map<String, PageData> pages, PageData mainPage, boolean secret, ItemStack item) {
        this.id = id;
        this.chapters = chapters;
        this.pages = pages;
        this.mainPage = mainPage;
        this.secret = secret;
        this.item = item;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, ChapterData> getChapters() {
        return this.chapters;
    }

    public Map<String, PageData> getPages() {
        return this.pages;
    }

    public PageData getMainPage() {
        return this.mainPage;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setChapters(Map<String, ChapterData> chapters) {
        this.chapters = chapters;
    }

    public void setPages(Map<String, PageData> pages) {
        this.pages = pages;
    }

    public void setMainPage(PageData mainPage) {
        this.mainPage = mainPage;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryData)) {
            return false;
        }
        CategoryData other = (CategoryData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSecret() != other.isSecret()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, ChapterData> this$chapters = this.getChapters();
        Map<String, ChapterData> other$chapters = other.getChapters();
        if (this$chapters == null ? other$chapters != null : !((Object)this$chapters).equals(other$chapters)) {
            return false;
        }
        Map<String, PageData> this$pages = this.getPages();
        Map<String, PageData> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        PageData this$mainPage = this.getMainPage();
        PageData other$mainPage = other.getMainPage();
        if (this$mainPage == null ? other$mainPage != null : !((Object)this$mainPage).equals(other$mainPage)) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        return !(this$item == null ? other$item != null : !this$item.equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoryData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSecret() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, ChapterData> $chapters = this.getChapters();
        result = result * 59 + ($chapters == null ? 43 : ((Object)$chapters).hashCode());
        Map<String, PageData> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        PageData $mainPage = this.getMainPage();
        result = result * 59 + ($mainPage == null ? 43 : ((Object)$mainPage).hashCode());
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        return result;
    }

    public String toString() {
        return "CategoryData(id=" + this.getId() + ", chapters=" + String.valueOf(this.getChapters()) + ", pages=" + String.valueOf(this.getPages()) + ", mainPage=" + String.valueOf(this.getMainPage()) + ", secret=" + this.isSecret() + ", item=" + String.valueOf(this.getItem()) + ")";
    }

    public static class CategoryDataBuilder {
        private String id;
        private boolean secret$set;
        private boolean secret$value;
        private boolean item$set;
        private ItemStack item$value;
        private Map<String, ChapterData> chapters = new HashMap<String, ChapterData>();
        private Map<String, PageData> pages = new HashMap<String, PageData>();
        private PageData mainPage = PageData.builder("main").build();

        public CategoryDataBuilder chapter(ChapterData chapter) {
            this.chapters.put(chapter.getId(), chapter);
            return this;
        }

        public CategoryDataBuilder page(PageData page) {
            this.pages.put(page.getId(), page);
            return this;
        }

        public CategoryDataBuilder mainPage(PageData mainPage) {
            this.mainPage = mainPage;
            return this;
        }

        CategoryDataBuilder() {
        }

        public CategoryDataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CategoryDataBuilder chapters(Map<String, ChapterData> chapters) {
            this.chapters = chapters;
            return this;
        }

        public CategoryDataBuilder pages(Map<String, PageData> pages) {
            this.pages = pages;
            return this;
        }

        public CategoryDataBuilder secret(boolean secret) {
            this.secret$value = secret;
            this.secret$set = true;
            return this;
        }

        public CategoryDataBuilder item(ItemStack item) {
            this.item$value = item;
            this.item$set = true;
            return this;
        }

        public CategoryData build() {
            boolean secret$value = this.secret$value;
            if (!this.secret$set) {
                secret$value = CategoryData.$default$secret();
            }
            ItemStack item$value = this.item$value;
            if (!this.item$set) {
                item$value = CategoryData.$default$item();
            }
            return new CategoryData(this.id, this.chapters, this.pages, this.mainPage, secret$value, item$value);
        }

        public String toString() {
            return "CategoryData.CategoryDataBuilder(id=" + this.id + ", chapters=" + String.valueOf(this.chapters) + ", pages=" + String.valueOf(this.pages) + ", mainPage=" + String.valueOf(this.mainPage) + ", secret$value=" + this.secret$value + ", item$value=" + String.valueOf(this.item$value) + ")";
        }
    }
}

