/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon;

import it.mralxart.etheria.magic.magemicon.Category;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.Page;
import it.mralxart.etheria.magic.magemicon.data.CategoriesData;
import it.mralxart.etheria.magic.magemicon.data.CategoryData;
import it.mralxart.etheria.magic.magemicon.data.ChapterData;
import it.mralxart.etheria.magic.magemicon.data.PageData;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.MageMiconRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public class MageMiconUtils {
    public static Category dataToCategory(CategoryData data) {
        return new Category(data.getId(), data.getItem(), MageMiconUtils.chapterList(data.getChapters()), MageMiconUtils.pageList(data.getPages()), MageMiconUtils.dataToPage(data.getMainPage()));
    }

    public static Chapter dataToChapter(ChapterData data) {
        return new Chapter(data.getId(), MageMiconUtils.pageList(data.getPages()), data.getText());
    }

    public static List<Chapter> chapterList(Map<String, ChapterData> pagesMap) {
        ArrayList<Chapter> chapters = new ArrayList<Chapter>();
        for (Map.Entry<String, ChapterData> entry : pagesMap.entrySet()) {
            Chapter chapter = new Chapter(entry.getKey(), MageMiconUtils.pageList(entry.getValue().getPages()), entry.getValue().getText());
            chapters.add(chapter);
        }
        return chapters;
    }

    public static List<Page> dataToPage(List<PageData> data) {
        ArrayList<Page> pageList = new ArrayList<Page>();
        for (PageData pageData : data) {
            pageList.add(MageMiconUtils.dataToPage(pageData));
        }
        return pageList;
    }

    public static Page dataToPage(PageData data) {
        Page page = new Page(data.getId(), data.getType(), data.getText(), data.getEntity(), data.getItem());
        page.sortIndex = data.getIndex();
        return page;
    }

    public static List<Page> pageList(Map<String, PageData> pagesMap) {
        ArrayList<Page> pagesList = new ArrayList<Page>();
        for (Map.Entry<String, PageData> entry : pagesMap.entrySet()) {
            Page page = new Page(entry.getValue().getId(), entry.getValue().getType(), entry.getValue().getText(), entry.getValue().getEntity(), entry.getValue().getItem());
            page.sortIndex = entry.getValue().getIndex();
            pagesList.add(page);
        }
        return pagesList;
    }

    public static List<String> getCategories() {
        ArrayList<String> data = new ArrayList<String>();
        CategoriesData categoryData = MageMiconRegistry.create().getCategories();
        if (categoryData != null) {
            categoryData.getCategories().forEach((key, value) -> data.add((String)key));
        }
        return data;
    }

    public static List<String> getChapters(String categoryName) {
        CategoryData category;
        ArrayList<String> chapterNames = new ArrayList<String>();
        CategoriesData categoryData = MageMiconRegistry.create().getCategories();
        if (categoryData != null && (category = categoryData.getCategories().get(categoryName)) != null) {
            category.getChapters().forEach((key, value) -> chapterNames.add((String)key));
        }
        return chapterNames;
    }

    public static List<String> getAllChapters() {
        ArrayList<String> allChapters = new ArrayList<String>();
        CategoriesData categoryData = MageMiconRegistry.create().getCategories();
        if (categoryData != null) {
            categoryData.getCategories().forEach((categoryName, category) -> {
                if (category != null) {
                    category.getChapters().forEach((chapterName, chapter) -> allChapters.add((String)chapterName));
                }
            });
        }
        return allChapters;
    }

    public static Map<String, ChapterData> getAllChaptersWithIds() {
        HashMap<String, ChapterData> chaptersMap = new HashMap<String, ChapterData>();
        CategoriesData categoryData = MageMiconRegistry.create().getCategories();
        if (categoryData != null) {
            categoryData.getCategories().forEach((categoryName, category) -> {
                if (category != null) {
                    chaptersMap.putAll(category.getChapters());
                }
            });
        }
        return chaptersMap;
    }

    @Nullable
    public static Category getCategoryByChapterId(String chapterId) {
        CategoriesData categoryData = MageMiconRegistry.create().getCategories();
        if (categoryData != null) {
            for (Map.Entry<String, CategoryData> categoryEntry : categoryData.getCategories().entrySet()) {
                CategoryData category = categoryEntry.getValue();
                if (category == null) continue;
                for (Map.Entry<String, ChapterData> chapterEntry : category.getChapters().entrySet()) {
                    if (!chapterEntry.getKey().equals(chapterId)) continue;
                    return MageMiconUtils.dataToCategory(category);
                }
            }
        }
        return null;
    }

    public static Category getCategory(String category) {
        return MageMiconUtils.dataToCategory(MageMiconRegistry.create().getCategories().getCategories().get(category));
    }

    public static Chapter getChapter(String category, String chapter) {
        return MageMiconUtils.dataToChapter(MageMiconRegistry.create().getCategories().getCategories().get(category).getChapters().get(chapter));
    }

    public static ChapterData getChapterData(String category, String chapter) {
        return MageMiconRegistry.create().getCategories().getCategories().get(category).getChapters().get(chapter);
    }

    public static Chapter getEmptyChapter(String chapter) {
        return new Chapter(chapter, new ArrayList<Page>(), "");
    }

    public static boolean isChapterLocked(Player player, String id) {
        return MageMiconUtils.getAllChaptersWithIds().get(id) != null && MageMiconUtils.getAllChaptersWithIds().get(id).isLocked() && !CapabilityRegistry.getCap(player).getChapters().contains(new Chapter(id));
    }
}

