/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.magemicon;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ICustomScaledGui;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.CategoryWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.ChapterWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.CometWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.NextPageWidget;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import it.mralxart.etheria.client.particles.utils.ParticleContainer;
import it.mralxart.etheria.magic.magemicon.Category;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.magemicon.Page;
import it.mralxart.etheria.magic.magemicon.data.CategoryData;
import it.mralxart.etheria.magic.magemicon.data.ChapterData;
import it.mralxart.etheria.magic.rituals.Ritual;
import it.mralxart.etheria.magic.rituals.RitualRegistry;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.MageMiconRegistry;
import it.mralxart.etheria.registry.SoundsRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MageMicon
extends Screen
implements ICustomScaledGui {
    private final Minecraft MC = Minecraft.m_91087_();
    private final Random random = new Random();
    private ParticleContainer particleContainer = new ParticleContainer();
    public static ResourceLocation GUI = new ResourceLocation("etheria", "textures/gui/gui.png");
    public static ResourceLocation PAPER = new ResourceLocation("etheria", "textures/gui/paper.png");
    @Nullable
    public Page page1;
    @Nullable
    public Page page2;
    public String beforeCategory = "";
    public Category category;
    public Chapter chapter;
    public int indexPage1 = 0;
    public int indexPage2 = 1;
    public int pagesIndex = 0;
    public final Player player;
    public ItemStack item;
    public String id;
    public int backgroundHeight = 314;
    public int backgroundWidth = 191;
    public int mainOffY = 0;
    public int tickCount = 0;
    private float time = 0.0f;
    private final List<CometWidget> comets = new ArrayList<CometWidget>();
    private Predicate<String> categoryFilter = category -> !category.equals("anvil") && !category.equals("kor_lunar");
    private SoundInstance instance = null;
    private Screen returnScreen;

    public MageMicon(Predicate<String> categoryFilter, boolean customOst) {
        super((Component)Component.m_237119_());
        this.categoryFilter = categoryFilter;
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        this.player = this.MC.f_91074_;
        if (this.category == null) {
            MageMiconUtils.getCategories().stream().filter(categoryFilter).findFirst().ifPresent(foundCategory -> {
                this.category = MageMiconUtils.getCategory(foundCategory);
            });
        }
        for (int i = 0; i < 5; ++i) {
            this.comets.add(new CometWidget(this.random.nextFloat() * (float)this.f_96543_ - (float)this.random.nextInt(400), this.random.nextFloat() * (float)this.f_96544_ - (float)this.random.nextInt(400), 1.6f + this.random.nextFloat() * 0.8f, this.random.nextInt(300) + this.random.nextInt(300)));
        }
        if (customOst) {
            Minecraft.m_91087_().m_91106_().m_120391_();
            this.instance = SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundsRegistry.PYRO_1.get()), (float)0.6f);
        }
    }

    public MageMicon() {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        this.player = this.MC.f_91074_;
        if (this.category == null) {
            this.category = MageMiconUtils.getCategory("basics");
        }
        for (int i = 0; i < 5; ++i) {
            this.comets.add(new CometWidget(this.random.nextFloat() * (float)this.f_96543_ - (float)this.random.nextInt(400), this.random.nextFloat() * (float)this.f_96544_ - (float)this.random.nextInt(400), 1.6f + this.random.nextFloat() * 0.8f, this.random.nextInt(300) + this.random.nextInt(300)));
        }
        Minecraft.m_91087_().m_91106_().m_120391_();
    }

    public void m_7379_() {
        if (this.returnScreen != null) {
            Minecraft.m_91087_().m_91152_(this.returnScreen);
            return;
        }
        if (this.chapter == null || this.category == null) {
            super.m_7379_();
            Minecraft.m_91087_().m_91106_().m_120399_(this.instance);
            Minecraft.m_91087_().m_91106_().m_120407_();
        } else {
            this.page1 = new Page();
            this.page2 = new Page();
            this.chapter = null;
            if (this.category.index.isEmpty()) {
                this.category.index = this.beforeCategory;
            }
            if (this.category == null) {
                this.category = MageMiconUtils.getCategory(MageMiconUtils.getCategories().stream().filter(this.categoryFilter).findFirst().get());
            }
            this.resetScreen();
            this.particleContainer.clear();
        }
    }

    public void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int yOff = 0;
        for (String mageCategory : MageMiconUtils.getCategories()) {
            if (!this.categoryFilter.test(mageCategory) || mageCategory.equals("rem_space")) continue;
            this.m_142416_(new CategoryWidget(centerX - 172, centerY - 75 + yOff, this, mageCategory));
            yOff += 22;
        }
        if (this.category != null) {
            switch (this.category.index) {
                case "rituals": {
                    this.renderRitualsWidgets();
                    break;
                }
                case "spells": {
                    this.renderSpellWidgets();
                    break;
                }
                default: {
                    this.renderDefaultWidgets();
                    break;
                }
            }
        } else {
            this.renderDefaultWidgets();
        }
        int totalPages = 0;
        if (this.chapter != null) {
            for (Page page : this.chapter.getPages()) {
                if (page.getType().equals((Object)Page.Type.ANVIL)) {
                    this.renderAnvilWidgets();
                }
                if (page.getIndex() == null || page.getIndex().isEmpty()) continue;
                ++totalPages;
            }
        } else if (this.category != null) {
            if (this.category.index.equals("rituals")) {
                for (Ritual data : RitualRegistry.getRituals()) {
                    if (data.getId() == null || data.getId().isEmpty()) continue;
                    ++totalPages;
                }
            } else if (this.category.index.equals("spells")) {
                for (String ignored : SpellsUtils.getStringSpells()) {
                    ++totalPages;
                }
            } else {
                for (Chapter page : this.category.getChapters()) {
                    if (page.getIndex() == null || page.getIndex().isEmpty()) continue;
                    ++totalPages;
                }
            }
            totalPages = (int)Math.ceil((double)totalPages / 5.0);
        }
        int totalTurnedPages = this.pagesIndex * 2;
        if (totalPages > 1) {
            if (this.pagesIndex * 2 < totalPages - 2) {
                this.m_142416_(new NextPageWidget(centerX - this.backgroundHeight / 2 + 278, centerY - this.backgroundWidth / 2 + 164, this, true));
            }
            if (this.pagesIndex > 0) {
                this.m_142416_(new NextPageWidget(centerX - this.backgroundHeight / 2 + 17, centerY - this.backgroundWidth / 2 + 164, this, false));
            }
        }
        if (this.page1 != null) {
            this.page1.init(this, centerX - this.backgroundHeight / 2, centerY - this.backgroundWidth / 2, 0);
        }
        if (this.page2 != null) {
            this.page2.init(this, centerX - this.backgroundHeight / 2 + 152, centerY - this.backgroundWidth / 2, 1);
        }
    }

    @NotNull
    public <T extends GuiEventListener & Renderable> T m_142416_(@NotNull T p_169406_) {
        this.f_169369_.add((Renderable)p_169406_);
        return (T)this.m_7787_(p_169406_);
    }

    private void renderAnvilWidgets() {
    }

    private void renderSpellWidgets() {
        int xOffset = 0;
        int yOffset = 0;
        int widgetCount = 0;
        boolean first = true;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startIndex = this.pagesIndex * 10;
        int endIndex = startIndex + 10;
        List<Spell> spells = SpellsUtils.getSpells((Player)this.MC.f_91074_);
        spells.sort(Comparator.comparing(Spell::getElement, Comparator.reverseOrder()));
        for (int i = startIndex; i < endIndex && i < spells.size(); ++i) {
            Spell spell = spells.get(i);
            this.m_142416_(new ChapterWidget(centerX - 143 + xOffset - 15, centerY - 100 + yOffset + 44, this, "spells", spell.getId(), first));
            yOffset += 22;
            if (++widgetCount == 5) {
                first = false;
                xOffset += 150;
                yOffset = 0;
            }
            if (widgetCount == 10) break;
        }
    }

    private void renderRitualsWidgets() {
        int xOffset = 0;
        int yOffset = 0;
        int widgetCount = 0;
        int startIndex = this.pagesIndex * 10;
        int endIndex = startIndex + 10;
        boolean first = true;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        List<Ritual> rituals = RitualRegistry.getRituals();
        if (!rituals.isEmpty()) {
            rituals.sort(Comparator.comparing(Ritual::getRitualDifficulty, Comparator.comparingInt(Enum::ordinal)).thenComparing(Ritual::getElement, Comparator.reverseOrder()).thenComparingInt(Ritual::getEtherAmount));
            for (int i = startIndex; i < endIndex && i < rituals.size(); ++i) {
                Ritual ritual = rituals.get(i);
                if (!ritual.getId().isEmpty() && ritual.getRitualResult().getResultItem() != null) {
                    this.m_142416_(new ChapterWidget(centerX - 143 + xOffset - 15 + 10, centerY - 100 + yOffset + 44, this, first).setCategory(ritual.getId()).setStack(ritual.getRitualResult().getResultItem()));
                } else if (ritual.getRitualResult().getResultItem() == null) {
                    this.m_142416_(new ChapterWidget(centerX - 143 + xOffset - 15 + 10, centerY - 100 + yOffset + 44, this, first, ritual.getId()));
                } else {
                    this.m_142416_(new ChapterWidget(centerX - 143 + xOffset - 15 + 10, centerY - 100 + yOffset + 44, this, ritual.getRitualResult().getResultItem(), first));
                }
                yOffset += 22;
                if (++widgetCount == 5) {
                    first = false;
                    xOffset += 150;
                    yOffset = 0;
                }
                if (widgetCount == 10) break;
            }
        }
        this.updatePages();
    }

    private void renderDefaultWidgets() {
        CategoryData categoryData;
        Map<String, ChapterData> chapters;
        int xOffset = 0;
        int yOffset = 0;
        int widgetCount = 0;
        boolean first = true;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        Map<String, CategoryData> categories = MageMiconRegistry.create().getCategories().getCategories();
        if (categories.containsKey(this.category.index) && (chapters = (categoryData = categories.get(this.category.index)).getChapters()) != null && this.chapter == null) {
            List<ChapterData> indexedChapters = chapters.values().stream().filter(chapter -> chapter.getIndex() != -1).sorted(Comparator.comparingInt(ChapterData::getIndex)).toList();
            List<ChapterData> nonIndexedChapters = chapters.values().stream().filter(chapter -> chapter.getIndex() == -1).toList();
            for (ChapterData chapter2 : indexedChapters) {
                this.m_142416_(new ChapterWidget(centerX - 143 + xOffset - 15 + 10, centerY - 100 + yOffset + 44, this, chapter2.getId(), first));
                yOffset += 22;
                if (++widgetCount == 5) {
                    first = false;
                    xOffset += 150;
                    yOffset = 0;
                }
                if (widgetCount != 10) continue;
                break;
            }
            for (ChapterData chapter2 : nonIndexedChapters) {
                this.m_142416_(new ChapterWidget(centerX - 143 + xOffset - 15 + 10, centerY - 100 + yOffset + 44, this, chapter2.getId(), first));
                yOffset += 22;
                if (++widgetCount == 5) {
                    first = false;
                    xOffset += 150;
                    yOffset = 0;
                }
                if (widgetCount != 10) continue;
                break;
            }
        }
        this.updatePages();
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        ResourceLocation texture = new ResourceLocation("etheria", "textures/gui/background.png");
        ResourceLocation cometTexture = new ResourceLocation("etheria", "textures/gui/comet.png");
        int size = 576;
        float speed = 0.005f;
        this.time += speed;
        float radius = 50.0f;
        float xOffset = (float)(Math.sin(this.time) * (double)radius * Math.sin((double)this.time * 0.5));
        float yOffset = (float)(Math.cos(this.time) * (double)radius * Math.sin((double)this.time * 0.5));
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        poseStack.m_252880_((float)this.f_96543_ / 2.0f - xOffset - 50.0f, (float)this.f_96544_ / 2.0f - yOffset - 80.0f, -100.0f);
        guiGraphics.m_280398_(texture, -(size / 2), -(size / 2) + this.mainOffY / 2, 0, (float)size, (float)size, size, size, size, size);
        int[] offsets = new int[]{-size, 0, size};
        for (int dx : offsets) {
            for (int dy : offsets) {
                guiGraphics.m_280398_(texture, -(size / 2) + dx, -(size / 2) + dy + this.mainOffY / 2, 0, (float)size, (float)size, size, size, size, size);
            }
        }
        poseStack.m_85849_();
        Object object = this.comets.iterator();
        while (object.hasNext()) {
            CometWidget comet = (CometWidget)object.next();
            comet.update();
            poseStack.m_85836_();
            poseStack.m_252880_(comet.x, comet.y, 0.0f);
            guiGraphics.m_280398_(cometTexture, (int)(-19.0f + comet.offX), (int)(-20.0f + comet.offY) + this.mainOffY / 2, 0, 38.0f, 40.0f, 38, 40, 38, 40);
            poseStack.m_85849_();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ICustomRenderWidget widget;
        AbstractButton button;
        PoseStack poseStack = guiGraphics.m_280168_();
        ++this.tickCount;
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        poseStack.m_85836_();
        guiGraphics.m_280163_(GUI, centerX - this.backgroundHeight / 2, centerY - this.backgroundWidth / 2, 0.0f, 0.0f, this.backgroundHeight, this.backgroundWidth, this.backgroundHeight, this.backgroundWidth);
        poseStack.m_85849_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || !((widget = (ICustomRenderWidget)button) instanceof CategoryWidget)) continue;
            widget.render(guiGraphics, partialTick, mouseX, mouseY);
        }
        guiGraphics.m_280163_(PAPER, centerX - this.backgroundHeight / 2, centerY - this.backgroundWidth / 2, 0.0f, 0.0f, this.backgroundHeight, this.backgroundWidth, this.backgroundHeight, this.backgroundWidth);
        this.renderPages(guiGraphics, mouseX, mouseY);
        for (GuiEventListener listener : new ArrayList(this.m_6702_())) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || (widget = (ICustomRenderWidget)button) instanceof CategoryWidget) continue;
            widget.render(guiGraphics, partialTick, mouseX, mouseY);
        }
        for (AbstractParticle particle : this.particleContainer.getParticles()) {
            particle.render(this, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderPages(GuiGraphics guiGraphics, float pMouseX, float pMouseY) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        if (this.category.index.startsWith("space") || this.category.index.equals("rem_space")) {
            centerY += this.mainOffY;
        }
        if (this.page1 != null) {
            this.page1.render(this, guiGraphics, centerX - this.backgroundHeight / 2, centerY - this.backgroundWidth / 2, pMouseX, pMouseY, 0);
        }
        if (this.page2 != null) {
            this.page2.render(this, guiGraphics, centerX - this.backgroundHeight / 2 + 152, centerY - this.backgroundWidth / 2, pMouseX, pMouseY, 1);
        }
    }

    public void setPage(Page page1, Page page2) {
        this.page1 = page1;
        this.page2 = page2;
    }

    public void updatePages() {
        if (this.chapter != null) {
            if (!this.chapter.getPages().isEmpty()) {
                ArrayList<Page> data = new ArrayList<Page>(this.chapter.getPages().stream().filter(chapter -> chapter.getSortIndex() != -1).sorted(Comparator.comparingInt(Page::getSortIndex)).toList());
                ArrayList<Page> nonData = new ArrayList<Page>(this.chapter.getPages().stream().filter(chapter -> chapter.getSortIndex() == -1).toList());
                data.addAll(nonData);
                this.setPage(this.getPage(data, this.indexPage1), this.getPage(data, this.indexPage2));
            }
        } else if (this.category != null && this.category.getPages() != null) {
            this.setPage(this.getPage(this.category.getPages(), this.indexPage1), this.getPage(this.category.getPages(), this.indexPage2));
        }
    }

    public Page getPage(List<Page> pages, int i) {
        if (i >= pages.size()) {
            return new Page();
        }
        return pages.get(i);
    }

    public void m_86600_() {
        this.getParticleContainer().tickParticles(this);
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ITickWidget)) continue;
            ITickWidget widget = (ITickWidget)button;
            widget.tick();
        }
        if (this.instance != null) {
            Minecraft.m_91087_().m_91106_().m_120389_(false);
            if (!Minecraft.m_91087_().m_91106_().m_120403_(this.instance)) {
                int i = this.random.nextInt(1, 3);
                int ii = this.random.nextInt(1, 2);
                float randomPitch = switch (ii) {
                    case 1 -> 0.9f;
                    case 2 -> 1.1f;
                    default -> 1.0f;
                };
                switch (i) {
                    case 1: {
                        this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_1.get()), (float)randomPitch, (float)0.5f);
                        break;
                    }
                    case 2: {
                        this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_2.get()), (float)randomPitch, (float)0.5f);
                        break;
                    }
                    case 3: {
                        this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_3.get()), (float)randomPitch, (float)0.5f);
                    }
                }
                Minecraft.m_91087_().m_91106_().m_120367_(this.instance);
            }
        }
    }

    public void resetScreen() {
        this.m_169413_();
        this.m_7856_();
    }

    @Override
    public int getScale() {
        return 3;
    }

    public Minecraft getMC() {
        return this.MC;
    }

    public Random getRandom() {
        return this.random;
    }

    public ParticleContainer getParticleContainer() {
        return this.particleContainer;
    }

    @Nullable
    public Page getPage1() {
        return this.page1;
    }

    @Nullable
    public Page getPage2() {
        return this.page2;
    }

    public String getBeforeCategory() {
        return this.beforeCategory;
    }

    public Category getCategory() {
        return this.category;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public int getIndexPage1() {
        return this.indexPage1;
    }

    public int getIndexPage2() {
        return this.indexPage2;
    }

    public int getPagesIndex() {
        return this.pagesIndex;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getId() {
        return this.id;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getMainOffY() {
        return this.mainOffY;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public float getTime() {
        return this.time;
    }

    public List<CometWidget> getComets() {
        return this.comets;
    }

    public Predicate<String> getCategoryFilter() {
        return this.categoryFilter;
    }

    public SoundInstance getInstance() {
        return this.instance;
    }

    public Screen getReturnScreen() {
        return this.returnScreen;
    }

    public void setParticleContainer(ParticleContainer particleContainer) {
        this.particleContainer = particleContainer;
    }

    public void setPage1(@Nullable Page page1) {
        this.page1 = page1;
    }

    public void setPage2(@Nullable Page page2) {
        this.page2 = page2;
    }

    public void setBeforeCategory(String beforeCategory) {
        this.beforeCategory = beforeCategory;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public void setIndexPage1(int indexPage1) {
        this.indexPage1 = indexPage1;
    }

    public void setIndexPage2(int indexPage2) {
        this.indexPage2 = indexPage2;
    }

    public void setPagesIndex(int pagesIndex) {
        this.pagesIndex = pagesIndex;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBackgroundHeight(int backgroundHeight) {
        this.backgroundHeight = backgroundHeight;
    }

    public void setBackgroundWidth(int backgroundWidth) {
        this.backgroundWidth = backgroundWidth;
    }

    public void setMainOffY(int mainOffY) {
        this.mainOffY = mainOffY;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void setCategoryFilter(Predicate<String> categoryFilter) {
        this.categoryFilter = categoryFilter;
    }

    public void setInstance(SoundInstance instance) {
        this.instance = instance;
    }

    public void setReturnScreen(Screen returnScreen) {
        this.returnScreen = returnScreen;
    }
}

