/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.loom.data;

import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.INBTSerializable;

public class LoomDataInfo
implements INBTSerializable<CompoundTag> {
    @AutoSerialize
    private String id;
    @AutoSerialize
    private List<String> commonItems;
    @AutoSerialize
    private List<String> epicItems;
    @AutoSerialize
    private List<String> legendaryItems;
    @AutoSerialize
    private List<String> mythicalItems;
    private static final Random random = new Random();

    public CompoundTag serializeNBT() {
        return NbtUtils.serialize(this);
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        NbtUtils.deserialize(this, compoundTag);
    }

    public String getRandomCommonItem() {
        return this.commonItems.get(random.nextInt(this.commonItems.size()));
    }

    public String getRandomLegendaryItems() {
        return this.legendaryItems.get(random.nextInt(this.legendaryItems.size()));
    }

    public String getRandomMythicItems() {
        return this.mythicalItems.get(random.nextInt(this.mythicalItems.size()));
    }

    public String getRandomEpicItem() {
        return this.epicItems.get(random.nextInt(this.epicItems.size()));
    }

    public static String convertItemString(String itemString) {
        String[] parts = itemString.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438: " + itemString);
        }
        String modId = parts[1];
        String itemId = parts[2];
        return modId + ":" + itemId;
    }

    public static LoomDataInfoBuilder builder() {
        return new LoomDataInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public List<String> getCommonItems() {
        return this.commonItems;
    }

    public List<String> getEpicItems() {
        return this.epicItems;
    }

    public List<String> getLegendaryItems() {
        return this.legendaryItems;
    }

    public List<String> getMythicalItems() {
        return this.mythicalItems;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCommonItems(List<String> commonItems) {
        this.commonItems = commonItems;
    }

    public void setEpicItems(List<String> epicItems) {
        this.epicItems = epicItems;
    }

    public void setLegendaryItems(List<String> legendaryItems) {
        this.legendaryItems = legendaryItems;
    }

    public void setMythicalItems(List<String> mythicalItems) {
        this.mythicalItems = mythicalItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoomDataInfo)) {
            return false;
        }
        LoomDataInfo other = (LoomDataInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$commonItems = this.getCommonItems();
        List<String> other$commonItems = other.getCommonItems();
        if (this$commonItems == null ? other$commonItems != null : !((Object)this$commonItems).equals(other$commonItems)) {
            return false;
        }
        List<String> this$epicItems = this.getEpicItems();
        List<String> other$epicItems = other.getEpicItems();
        if (this$epicItems == null ? other$epicItems != null : !((Object)this$epicItems).equals(other$epicItems)) {
            return false;
        }
        List<String> this$legendaryItems = this.getLegendaryItems();
        List<String> other$legendaryItems = other.getLegendaryItems();
        if (this$legendaryItems == null ? other$legendaryItems != null : !((Object)this$legendaryItems).equals(other$legendaryItems)) {
            return false;
        }
        List<String> this$mythicalItems = this.getMythicalItems();
        List<String> other$mythicalItems = other.getMythicalItems();
        return !(this$mythicalItems == null ? other$mythicalItems != null : !((Object)this$mythicalItems).equals(other$mythicalItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoomDataInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $commonItems = this.getCommonItems();
        result = result * 59 + ($commonItems == null ? 43 : ((Object)$commonItems).hashCode());
        List<String> $epicItems = this.getEpicItems();
        result = result * 59 + ($epicItems == null ? 43 : ((Object)$epicItems).hashCode());
        List<String> $legendaryItems = this.getLegendaryItems();
        result = result * 59 + ($legendaryItems == null ? 43 : ((Object)$legendaryItems).hashCode());
        List<String> $mythicalItems = this.getMythicalItems();
        result = result * 59 + ($mythicalItems == null ? 43 : ((Object)$mythicalItems).hashCode());
        return result;
    }

    public String toString() {
        return "LoomDataInfo(id=" + this.getId() + ", commonItems=" + String.valueOf(this.getCommonItems()) + ", epicItems=" + String.valueOf(this.getEpicItems()) + ", legendaryItems=" + String.valueOf(this.getLegendaryItems()) + ", mythicalItems=" + String.valueOf(this.getMythicalItems()) + ")";
    }

    public LoomDataInfo(String id, List<String> commonItems, List<String> epicItems, List<String> legendaryItems, List<String> mythicalItems) {
        this.id = id;
        this.commonItems = commonItems;
        this.epicItems = epicItems;
        this.legendaryItems = legendaryItems;
        this.mythicalItems = mythicalItems;
    }

    public static class LoomDataInfoBuilder {
        private String id;
        private List<String> commonItems = new ArrayList<String>();
        private List<String> epicItems = new ArrayList<String>();
        private List<String> legendaryItems = new ArrayList<String>();
        private List<String> mythicalItems = new ArrayList<String>();

        public LoomDataInfoBuilder common(String skill) {
            this.commonItems.add(skill);
            return this;
        }

        public LoomDataInfoBuilder common(Item item) {
            this.commonItems.add(LoomDataInfo.convertItemString(item.m_5524_()));
            return this;
        }

        public LoomDataInfoBuilder epic(String skill) {
            this.epicItems.add(skill);
            return this;
        }

        public LoomDataInfoBuilder legendary(Item item) {
            this.legendaryItems.add(LoomDataInfo.convertItemString(item.m_5524_()));
            return this;
        }

        public LoomDataInfoBuilder mythical(Item item) {
            this.mythicalItems.add(LoomDataInfo.convertItemString(item.m_5524_()));
            return this;
        }

        public LoomDataInfoBuilder mythicals(String ... infos) {
            this.mythicalItems.addAll(Arrays.asList(infos));
            return this;
        }

        public LoomDataInfoBuilder legendarys(String ... infos) {
            this.legendaryItems.addAll(Arrays.asList(infos));
            return this;
        }

        public LoomDataInfoBuilder epic(Item item) {
            this.epicItems.add(LoomDataInfo.convertItemString(item.m_5524_()));
            return this;
        }

        public LoomDataInfoBuilder commons(String ... infos) {
            this.commonItems.addAll(Arrays.asList(infos));
            return this;
        }

        public LoomDataInfoBuilder epics(String ... infos) {
            this.epicItems.addAll(Arrays.asList(infos));
            return this;
        }

        LoomDataInfoBuilder() {
        }

        public LoomDataInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public LoomDataInfoBuilder commonItems(List<String> commonItems) {
            this.commonItems = commonItems;
            return this;
        }

        public LoomDataInfoBuilder epicItems(List<String> epicItems) {
            this.epicItems = epicItems;
            return this;
        }

        public LoomDataInfoBuilder legendaryItems(List<String> legendaryItems) {
            this.legendaryItems = legendaryItems;
            return this;
        }

        public LoomDataInfoBuilder mythicalItems(List<String> mythicalItems) {
            this.mythicalItems = mythicalItems;
            return this;
        }

        public LoomDataInfo build() {
            return new LoomDataInfo(this.id, this.commonItems, this.epicItems, this.legendaryItems, this.mythicalItems);
        }

        public String toString() {
            return "LoomDataInfo.LoomDataInfoBuilder(id=" + this.id + ", commonItems=" + String.valueOf(this.commonItems) + ", epicItems=" + String.valueOf(this.epicItems) + ", legendaryItems=" + String.valueOf(this.legendaryItems) + ", mythicalItems=" + String.valueOf(this.mythicalItems) + ")";
        }
    }
}

