/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.loom;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.magic.loom.EtherLoomStorage;
import it.mralxart.etheria.magic.loom.data.LoomDataInfo;
import it.mralxart.etheria.magic.loom.data.LoomType;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.tiles.EtherLoomTile;
import it.mralxart.etheria.utils.NbtUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.annotations.AutoSerialize;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class EtherLoomManager
implements INBTSerializable<CompoundTag> {
    private Level level;
    private BlockPos pos;
    private ServerPlayer player;
    @AutoSerialize
    public int tickCount;
    public boolean isActive;
    private boolean isFinished;
    private boolean isItemGived;
    private boolean isScreenDimmed;
    private LoomType type;
    private LoomType bestRoll = LoomType.COMMON;
    public List<LoomType> rolls = new ArrayList<LoomType>();
    private List<ItemStack> rollItem = new ArrayList<ItemStack>();
    private List<ItemStack> rollItemCap = new ArrayList<ItemStack>();
    private int rollCount = 0;
    private LoomDataInfo info = LoomDataInfo.builder().build();
    private List<ParticleUtils.LineData> lines;

    public void setup(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
        this.tickCount = 0;
        this.isActive = false;
        this.isFinished = false;
        this.isItemGived = false;
        this.isScreenDimmed = false;
        this.bestRoll = LoomType.COMMON;
        this.rollItemCap = new ArrayList<ItemStack>();
        this.rollItem = new ArrayList<ItemStack>();
        this.rolls = new ArrayList<LoomType>();
        this.lines = new ArrayList<ParticleUtils.LineData>(2);
    }

    public void start(ServerPlayer player, LoomType type, String id, int countRoll) {
        LoomType roll;
        this.player = player;
        this.isActive = true;
        if (player.m_9236_().f_46443_) {
            return;
        }
        this.lines.add(new ParticleUtils.LineData(0));
        this.lines.add(new ParticleUtils.LineData(16));
        this.info = EtherLoomStorage.build().get(id);
        if (this.info == null) {
            return;
        }
        this.type = type;
        for (int i = 0; i < countRoll; ++i) {
            roll = this.roll((Player)player);
            this.rolls.add(roll);
            if (roll.equals((Object)LoomType.EPIC) && this.bestRoll.equals((Object)LoomType.COMMON)) {
                this.bestRoll = LoomType.EPIC;
            } else if (roll.equals((Object)LoomType.LEGENDARY) && (this.bestRoll.equals((Object)LoomType.EPIC) || this.bestRoll.equals((Object)LoomType.COMMON))) {
                this.bestRoll = LoomType.LEGENDARY;
            } else if (roll.equals((Object)LoomType.MYTHIC) && (this.bestRoll.equals((Object)LoomType.EPIC) || this.bestRoll.equals((Object)LoomType.COMMON) || this.bestRoll.equals((Object)LoomType.LEGENDARY))) {
                this.bestRoll = LoomType.MYTHIC;
            }
            String itemId = roll.equals((Object)LoomType.COMMON) ? this.info.getRandomCommonItem() : (roll.equals((Object)LoomType.EPIC) ? this.info.getRandomEpicItem() : (roll.equals((Object)LoomType.MYTHIC) ? this.info.getRandomMythicItems() : this.info.getRandomLegendaryItems()));
            String[] parts = itemId.split(":");
            if (parts.length < 2 || parts.length > 3) {
                return;
            }
            String itemResource = parts[0] + ":" + parts[1];
            int[] count = new int[]{1};
            if (parts.length == 3) {
                try {
                    count[0] = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException e) {
                    count[0] = 1;
                }
            }
            String spellId = "";
            boolean randomEnchant = false;
            int enchantmentLevel = 0;
            if (parts[1].equals("spell_scroll")) {
                spellId = parts[2];
            } else if (parts.length == 3 && parts[2].startsWith("enchanted.")) {
                randomEnchant = true;
                try {
                    enchantmentLevel = Integer.parseInt(parts[2].split("\\.")[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!spellId.isEmpty()) {
                ItemStack stack = ((Item)ItemRegistry.SPELL_SCROLL.get()).m_7968_();
                CompoundTag nbt = stack.m_41784_();
                nbt.m_128359_("spell_id", spellId);
                nbt.m_128359_("etheria$element", SpellsUtils.getSpellElement(spellId));
                this.rollItem.add(stack);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemResource));
            if (item != null) {
                EnchantmentInstance enchantment;
                ItemStack stack = new ItemStack((ItemLike)item, count[0]);
                if (randomEnchant && (enchantment = EtherLoomManager.getRandomEnchantment(enchantmentLevel, stack, false)) != null) {
                    if (stack.m_150930_(Items.f_42690_)) {
                        EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)enchantment);
                    } else {
                        stack.m_41663_(enchantment.f_44947_, enchantment.f_44948_);
                    }
                }
                this.rollItem.add(stack);
                continue;
            }
            if (id.equalsIgnoreCase("cryo")) {
                this.rollItem.add(((Item)ItemRegistry.FROSTBOUND_WISH.get()).m_7968_());
                continue;
            }
            if (!id.equalsIgnoreCase("pyro")) continue;
            this.rollItem.add(((Item)ItemRegistry.BLAZING_WISH.get()).m_7968_());
        }
        roll = this.level.m_7702_(this.pos);
        if (roll instanceof EtherLoomTile) {
            EtherLoomTile tile = (EtherLoomTile)((Object)roll);
            BlockState oldState = this.level.m_8055_(this.pos);
            tile.m_187481_();
            tile.m_6596_();
            this.level.m_7260_(this.pos, oldState, this.level.m_8055_(this.pos), 3);
        }
    }

    public void tick() {
        Vec3 posRes;
        if (this.isFinished) {
            this.finishTick();
        }
        if (!this.isActive || this.isFinished) {
            return;
        }
        if (this.level.f_46443_) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount <= 200) {
            ParticleUtils.drawParticlesToCenter(new GlowingParticleData(EtherLoomManager.getRollColor(this.bestRoll.name()).getRGB(), Math.max(0.1f, this.level.f_46441_.m_188501_() / 6.0f), 10 + this.level.f_46441_.m_216339_(3, 30), 0.25f, 1.0f), this.level, this.pos.m_252807_().m_82520_(0.0, 0.5, 0.0), 20, 0.7f, 0.03f, 0.01f);
            Vec3 posCenter = this.pos.m_252807_().m_82520_(0.0, 0.5, 0.0);
            posRes = this.pos.m_252807_().m_82520_(0.0, 2.0, 0.0);
            ParticleUtils.createLines(this.level, EtherLoomManager.getRollColor(this.bestRoll.name()), posCenter, posRes, this.lines, null, 3.0f, 0.2f, 80, 20, true);
        }
        ParticleUtils.createSpringSpiral(this.level, new GlowingParticleData(EtherLoomManager.getRollColor(this.bestRoll.name()).getRGB(), Math.max(0.1f, this.level.f_46441_.m_188501_() / 6.0f), 10 + this.level.f_46441_.m_216339_(3, 30), 0.25f, 1.0f), this.pos.m_252807_().m_82520_(0.0, -0.5, 0.0), this.pos.m_252807_().m_82520_(0.0, 2.0, 0.0), this.tickCount, 220, 40.0, 0.4f, 1.0, 12345L, false);
        if (this.tickCount > 190) {
            posRes = this.level.m_7702_(this.pos);
            if (posRes instanceof EtherLoomTile) {
                EtherLoomTile tile = (EtherLoomTile)posRes;
                BlockState oldState = this.level.m_8055_(this.pos);
                tile.setStack(ItemStack.f_41583_);
                tile.m_6596_();
                this.level.m_7260_(this.pos, oldState, this.level.m_8055_(this.pos), 3);
            }
            this.tickCount = 0;
            this.rollItemCap = new ArrayList<ItemStack>(this.rollItem);
            ArrayList<Pair> sortedRolls = new ArrayList<Pair>();
            for (int i = 0; i < this.rollItemCap.size(); ++i) {
                sortedRolls.add(new Pair((Object)this.rollItemCap.get(i), (Object)this.rolls.get(i)));
            }
            sortedRolls.sort(Comparator.comparing(Pair::getSecond));
            this.rollItemCap.clear();
            this.rolls.clear();
            for (Pair pair : sortedRolls) {
                this.rollItemCap.add((ItemStack)pair.getFirst());
                this.rolls.add((LoomType)((Object)pair.getSecond()));
            }
            this.isActive = false;
            this.isFinished = true;
        }
    }

    private void dimScreen() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("text", "");
        tag.m_128405_("time", 10);
        tag.m_128405_("fade", 10);
        tag.m_128405_("color", 0xFFFFFF);
        Networking.sendToClient(this.player, new S2CPacket(tag, 1));
    }

    public static Color getRollColor(String roll) {
        switch (roll.toLowerCase()) {
            case "common": {
                return new Color(207, 221, 232);
            }
            case "epic": {
                return new Color(100, 140, 250);
            }
            case "legendary": {
                return new Color(158, 102, 200);
            }
            case "mythic": {
                return new Color(255, 23, 154);
            }
        }
        return Color.WHITE;
    }

    private void finishTick() {
        ++this.tickCount;
        if (this.player != null && this.tickCount < 2 && !this.isScreenDimmed) {
            this.dimScreen();
            this.isScreenDimmed = true;
            this.tickCount = -20;
        }
        int maxTicks = this.rollItemCap.size() * 90 - 20;
        if (!this.rollItemCap.isEmpty() && this.tickCount <= maxTicks) {
            if (this.tickCount % 90 == 0) {
                int index = this.tickCount / 90 % this.rollItemCap.size();
                ItemStack currentItem = this.rollItemCap.get(index);
                LoomType roll = this.rolls.get(index);
                CapabilityRegistry.getCap((Player)this.player).setLoomHud(true);
                if (!currentItem.m_41619_()) {
                    CapabilityRegistry.getCap((Player)this.player).setLoomItem(currentItem);
                }
                CapabilityRegistry.getCap((Player)this.player).setLoomRoll(roll);
                SyncCapabilityManager.sync((Player)this.player);
                Networking.sendToClient(this.player, new S2CPacket(new CompoundTag(), 2));
                this.modifyStack(currentItem, roll);
                this.player.m_36356_(currentItem);
            }
        } else if (CapabilityRegistry.getCap((Player)this.player).isLoomHud()) {
            CapabilityRegistry.getCap((Player)this.player).setLoomHud(false);
            SyncCapabilityManager.sync((Player)this.player);
            this.isFinished = false;
        }
    }

    public ItemStack modifyStack(ItemStack itemStack, LoomType roll) {
        if (itemStack.m_41720_() instanceof ArtifactItem) {
            if (roll.equals((Object)LoomType.EPIC)) {
                ArtifactStatsManager.init(itemStack, 0.7f);
            } else if (roll.equals((Object)LoomType.LEGENDARY)) {
                ArtifactStatsManager.init(itemStack, 2.0f);
            }
            ArtifactStatsManager.setBlessed(itemStack);
        }
        return itemStack;
    }

    public LoomType roll(Player player) {
        double roll;
        EtheriaCapability cap = CapabilityRegistry.getCap(player);
        int mythicRolls = cap.getMythicRolls();
        int legendaryRolls = cap.getLegendaryRolls();
        int epicRolls = cap.getEpicRolls();
        int commonRolls = cap.getCommonRolls();
        if (legendaryRolls >= 40) {
            cap.setLegendaryRolls(0);
            cap.setEpicRolls(epicRolls + 1);
            cap.setCommonRolls(commonRolls + 1);
            SyncCapabilityManager.sync(player);
            return LoomType.LEGENDARY;
        }
        if (epicRolls >= 10) {
            cap.setEpicRolls(0);
            cap.setLegendaryRolls(legendaryRolls + 1);
            cap.setCommonRolls(commonRolls + 1);
            SyncCapabilityManager.sync(player);
            return LoomType.EPIC;
        }
        double baseLegendaryChance = 0.01;
        double baseEpicChance = 0.061;
        double baseMythicChance = 4.0E-5;
        if (legendaryRolls >= 15) {
            baseLegendaryChance += (double)(legendaryRolls - 15) * 0.01;
        }
        if (mythicRolls >= 40) {
            baseMythicChance += (double)(mythicRolls - 40) * 2.0E-5;
        }
        if ((roll = new Random().nextDouble()) < baseLegendaryChance) {
            cap.setLegendaryRolls(0);
            cap.setEpicRolls(epicRolls + 1);
            cap.setCommonRolls(commonRolls + 1);
            SyncCapabilityManager.sync(player);
            return LoomType.LEGENDARY;
        }
        if (roll < baseEpicChance) {
            cap.setEpicRolls(0);
            cap.setLegendaryRolls(legendaryRolls + 1);
            cap.setCommonRolls(commonRolls + 1);
            SyncCapabilityManager.sync(player);
            return LoomType.EPIC;
        }
        cap.setCommonRolls(commonRolls + 1);
        cap.setEpicRolls(epicRolls + 1);
        cap.setLegendaryRolls(legendaryRolls + 1);
        SyncCapabilityManager.sync(player);
        return LoomType.COMMON;
    }

    public static EnchantmentInstance getRandomEnchantment(int p_44818_, ItemStack p_44819_, boolean p_44820_) {
        List<EnchantmentInstance> availableEnchantments = EtherLoomManager.getAvailableEnchantmentResults(p_44818_, p_44819_, p_44820_);
        if (availableEnchantments.isEmpty()) {
            return null;
        }
        Random random = new Random();
        return availableEnchantments.get(random.nextInt(availableEnchantments.size()));
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int level, ItemStack p_44819_, boolean p_44820_) {
        ArrayList list = Lists.newArrayList();
        for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
            if (enchantment.m_6591_() && !p_44820_ || !enchantment.canApplyAtEnchantingTable(p_44819_) && !p_44819_.m_150930_(Items.f_42690_) || !enchantment.m_6081_(p_44819_) && !p_44819_.m_150930_(Items.f_42690_)) continue;
            int validLevel = Math.max(enchantment.m_44702_(), Math.min(level, enchantment.m_6586_()));
            list.add(new EnchantmentInstance(enchantment, validLevel));
        }
        return list;
    }

    public CompoundTag serializeNBT() {
        return NbtUtils.serialize(this);
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        NbtUtils.deserialize(this, compoundTag);
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isItemGived() {
        return this.isItemGived;
    }

    public boolean isScreenDimmed() {
        return this.isScreenDimmed;
    }

    public LoomType getBestRoll() {
        return this.bestRoll;
    }

    public List<LoomType> getRolls() {
        return this.rolls;
    }

    public List<ItemStack> getRollItem() {
        return this.rollItem;
    }

    public List<ItemStack> getRollItemCap() {
        return this.rollItemCap;
    }

    public int getRollCount() {
        return this.rollCount;
    }

    public LoomDataInfo getInfo() {
        return this.info;
    }

    public List<ParticleUtils.LineData> getLines() {
        return this.lines;
    }

    public void setType(LoomType type) {
        this.type = type;
    }

    public LoomType getType() {
        return this.type;
    }
}

